/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.EntityInfoCollection;
import com.kingdee.eas.framework.bireport.bimanager.client.DBCenterSelector;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlCompanyDBMappingInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.AbstractEtlCompanyDBMappingEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.framework.bireport.bimanager.util.UIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class EtlCompanyDBMappingEditUI
extends AbstractEtlCompanyDBMappingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EtlCompanyDBMappingEditUI.class);
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlClientResource";

    @Override
    public void onLoad() throws Exception {
        this.tbl.checkParsed();
        super.onLoad();
        this.initControl();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            UIHelper.initCompanyTree(this.tbl);
            this.fillDataToTable();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        try {
            super.storeFields();
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                this.addEntryInfo(i);
            }
            Iterator iter = this.editData.getEntry().iterator();
            while (iter.hasNext()) {
                EtlCompanyDBMappingEntryInfo entryInfo = (EtlCompanyDBMappingEntryInfo)iter.next();
                if (entryInfo.getDataCenter() != null && entryInfo.getDataCenter().trim().length() != 0) continue;
                iter.remove();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        System.out.println(this.editData.getEntry().size());
    }

    public void addEntryInfo(int rowIndex) {
        EtlCompanyDBMappingEntryCollection cols = this.editData.getEntry();
        Object value = this.tbl.getRow(rowIndex).getCell("id").getValue();
        for (int i = 0; i < cols.size(); ++i) {
            EtlCompanyDBMappingEntryInfo entryInfo = cols.get(i);
            if (!entryInfo.getCompany().getId().toString().equals(value.toString())) continue;
            Object dbID = this.tbl.getRow(rowIndex).getCell("dbID").getValue();
            if (dbID == null) {
                entryInfo.setDataCenter(null);
                return;
            }
            String[] split = dbID.toString().split(";");
            entryInfo.setExtendedProperty("isSetDataCenter", "true");
            entryInfo.setDataCenter(split[0].trim());
            for (int j = 1; j < split.length; ++j) {
                boolean flag = false;
                for (int k = 0; k < cols.size(); ++k) {
                    EtlCompanyDBMappingEntryInfo info = cols.get(k);
                    if (!info.getCompany().getId().toString().equals(value.toString()) || info.getExtendedProperty("isSetDataCenter") != null) continue;
                    info.setCompany((CompanyOrgUnitInfo)this.tbl.getRow(rowIndex).getCell("company").getValue());
                    info.setDataCenter(split[j].trim());
                    info.setExtendedProperty("isSetDataCenter", "true");
                    flag = true;
                }
                if (flag) continue;
                EtlCompanyDBMappingEntryInfo info = new EtlCompanyDBMappingEntryInfo();
                info.setCompany((CompanyOrgUnitInfo)this.tbl.getRow(rowIndex).getCell("company").getValue());
                info.setDataCenter(split[j].trim());
                cols.add(info);
            }
            return;
        }
        Object dbID = this.tbl.getRow(rowIndex).getCell("dbID").getValue();
        if (dbID == null) {
            return;
        }
        String[] split = dbID.toString().split(";");
        for (int j = 0; j < split.length; ++j) {
            EtlCompanyDBMappingEntryInfo info = new EtlCompanyDBMappingEntryInfo();
            info.setCompany((CompanyOrgUnitInfo)this.tbl.getRow(rowIndex).getCell("company").getValue());
            info.setDataCenter(split[j].trim());
            cols.add(info);
        }
    }

    private void fillDataToTable() {
        EtlCompanyDBMappingEntryCollection cols = this.editData.getEntry();
        for (int i = 0; i < cols.size(); ++i) {
            EtlCompanyDBMappingEntryInfo entryInfo = cols.get(i);
            IRow row = this.getRow(entryInfo);
            if (row == null) continue;
            System.out.println(row.getCell("number").getValue());
            try {
                EntityInfoCollection info;
                DBCenterModel model = DBConnectionMap.getInstance(null).get(entryInfo.getDataCenter());
                Object value = row.getCell("dataCenter").getValue();
                if (value instanceof EntityInfoCollection) {
                    info = (EntityInfoCollection)value;
                    info.addObject(model);
                    row.getCell("dbID").setValue((Object)info.toIDSString());
                    continue;
                }
                info = new EntityInfoCollection(null);
                info.addObject(model);
                row.getCell("dataCenter").setValue((Object)info);
                row.getCell("dbID").setValue((Object)info.toIDSString());
                continue;
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private IRow getRow(EtlCompanyDBMappingEntryInfo info) {
        if (info == null || info.getCompany() == null) {
            return null;
        }
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Object value = row.getCell("id").getValue();
            if (!info.getCompany().getId().toString().equals(value.toString())) continue;
            return row;
        }
        return null;
    }

    private void initControl() {
        KDBizPromptBox companyF7 = new KDBizPromptBox();
        companyF7.setQueryInfo("com.kingdee.eas.framework.bireport.bimanager.etl.app.EtlCompanyDBMappingQuery");
        companyF7.setVisible(true);
        companyF7.setEditable(false);
        companyF7.setDisplayFormat("$name$");
        companyF7.setEditFormat("$name$");
        companyF7.setSelector((KDPromptSelector)new CompanyF7());
        KDTDefaultCellEditor companyEdit = new KDTDefaultCellEditor((IKDEditor)companyF7);
        this.tbl.getColumn("company").setEditor((ICellEditor)companyEdit);
        KDBizPromptBox prmtDataCenter = new KDBizPromptBox();
        UIContext uiMap = new UIContext((Object)this);
        uiMap.put((Object)"isEnabledMultiSelection", (Object)"true");
        prmtDataCenter.setSelector((KDPromptSelector)new DBCenterSelector(uiMap));
        KDTDefaultCellEditor dataCenterEdit = new KDTDefaultCellEditor((IKDEditor)prmtDataCenter);
        this.tbl.getColumn("dataCenter").setEditor((ICellEditor)dataCenterEdit);
        this.tbl.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (UIHelper.isSame(e.getOldValue(), e.getValue())) {
                    return;
                }
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                String columnKey = EtlCompanyDBMappingEditUI.this.tbl.getColumnKey(colIndex);
                if ("dataCenter".equals(columnKey)) {
                    Object value = EtlCompanyDBMappingEditUI.this.tbl.getRow(rowIndex).getCell("dataCenter").getValue();
                    EntityInfoCollection info = new EntityInfoCollection(value);
                    EtlCompanyDBMappingEditUI.this.tbl.getRow(rowIndex).getCell("dataCenter").setValue((Object)info);
                    EtlCompanyDBMappingEditUI.this.tbl.getRow(rowIndex).getCell("dbID").setValue((Object)info.toIDSString());
                }
            }
        });
        this.tbl.getColumn("company").getStyleAttributes().setLocked(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int i;
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"numberIsNotNull"));
            SysUtil.abort();
        } else {
            char[] chs = number.trim().toCharArray();
            Pattern p = Pattern.compile("[a-zA-Z_0-9]");
            for (i = 0; i < chs.length; ++i) {
                Matcher m = p.matcher(Character.toString(chs[i]));
                if (m.matches()) continue;
                this.txtNumber.requestFocus(true);
                MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"onlyCharOANum"));
                SysUtil.abort();
            }
        }
        Object objName = this.txtName.getDefaultLangItemData();
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"nameIsNotNull"));
            SysUtil.abort();
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            Object value = row.getCell("dataCenter").getValue();
            if (!(value instanceof IObjectValue)) continue;
            String cellID = ((IObjectValue)value).get("id").toString();
            if (map.containsKey(cellID)) {
                MsgBox.showInfo((String)("\u7b2c" + ((Integer)map.get(cellID) + 1) + "\u884c\u4e0e\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e2d\u5fc3\u4e00\u81f4!"));
                SysUtil.abort();
            }
            map.put(cellID, new Integer(i));
        }
    }

    @Override
    protected IObjectValue createNewData() {
        EtlCompanyDBMappingInfo info = new EtlCompanyDBMappingInfo();
        Object objGroup = this.getUIContext().get("groupInfo");
        if (objGroup instanceof EtlCompanyDBMappingGroupInfo) {
            info.setGroup((EtlCompanyDBMappingGroupInfo)objGroup);
        }
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EtlCompanyDBMappingFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add("*");
        selectors.add("entry.*");
        return selectors;
    }
}

