/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerGroupInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchStatusEnum;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.IEtlDispatchManager;
import com.kingdee.eas.framework.bireport.bimanager.etl.LostStrategy_ETL;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.AbstractEtlDispatchManagerEditUI;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlLostStrategyUI;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlSchemeManagerListUI;
import com.kingdee.eas.framework.bireport.bimanager.util.PeriodSetUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.client.F7ListUISelector;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class EtlDispatchManagerEditUI
extends AbstractEtlDispatchManagerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EtlDispatchManagerEditUI.class);
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlClientResource";
    String periodXml = null;

    @Override
    public void storeFields() {
        for (int i = 0; i < this.tblScheme.getRowCount(); ++i) {
            Object value = this.tblScheme.getRow(i).getCell("lost").getValue();
            if (!(value instanceof LostStrategy_ETL)) continue;
            this.tblScheme.getRow(i).getCell("lost").setValue((Object)((LostStrategy_ETL)value).toSaveString());
        }
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setLostStrategy();
    }

    public void setLostStrategy() {
        for (int i = 0; i < this.tblScheme.getRowCount(); ++i) {
            Object value = this.tblScheme.getRow(i).getCell("lost").getValue();
            if (value == null || value.toString().trim().length() == 0) {
                this.tblScheme.getRow(i).getCell("lost").setValue(null);
            }
            if (value == null) continue;
            this.tblScheme.getRow(i).getCell("lost").setValue((Object)LostStrategy_ETL.str2LostStrategy(value.toString()));
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.tblScheme.checkParsed();
        this.initTable();
        super.onLoad();
        this.periodXml = this.editData.getPeriod();
        if (this.periodXml != null) {
            this.txtPeriod.setText(PeriodSetUtil.toScheduleTime(this.periodXml));
        }
        this.btnAdd.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_AddLine"));
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnMinus.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_RemoveLine"));
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.kDContainer1.addButton((JButton)this.btnAdd);
        this.kDContainer1.addButton((JButton)this.btnMinus);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPeriod.setIcon(EASResource.getIcon((String)"imgTbtn_slackentimesetting"));
        this.txtPeriod.setEnabled(false);
    }

    @Override
    protected void btnPeriod_actionPerformed(ActionEvent e) throws Exception {
        try {
            PeriodSetUtil util = new PeriodSetUtil();
            this.periodXml = util.getPeriodXml((CoreUI)this, this.periodXml);
            this.txtPeriod.setText(PeriodSetUtil.toScheduleTime(this.periodXml));
            this.txtPeriodBind.setText(this.periodXml);
        }
        catch (LinkageError e1) {
            WindowUtil.msgboxWarning((Object)"\u975eEAS\u73af\u5883\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u8c03\u5ea6\u65f6\u95f4\u5468\u671f\uff01", (String)"\u7cfb\u7edf\u63d0\u793a", (Component)((Object)this));
            logger.error((Object)"error", (Throwable)e1);
        }
        catch (Exception e2) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e2);
            logger.error((Object)"error", (Throwable)e2);
        }
    }

    public void initTable() {
        this.tblScheme.checkParsed();
        this.tblScheme.getSelectManager().setSelectMode(2);
        KDBizPromptBox f7etlScheme = new KDBizPromptBox();
        f7etlScheme.setQueryInfo("com.kingdee.eas.framework.bireport.bimanager.etl.app.EtlSchemeManagerQuery");
        f7etlScheme.setVisible(true);
        f7etlScheme.setEditable(true);
        f7etlScheme.setDisplayFormat("$name$");
        f7etlScheme.setEditFormat("$number$");
        try {
            F7ListUISelector.setListToPrmtF7HasSelector(f7etlScheme, (ListUI)new EtlSchemeManagerListUI());
        }
        catch (Exception exception) {
            // empty catch block
        }
        KDTDefaultCellEditor schemeEditor = new KDTDefaultCellEditor((IKDEditor)f7etlScheme);
        this.tblScheme.getColumn("etlScheme").setEditor((ICellEditor)schemeEditor);
        this.tblScheme.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    EtlDispatchManagerEditUI.this.tblScheme_editStopped(e);
                }
                catch (Exception e1) {
                    EtlDispatchManagerEditUI.this.handUIException(e1);
                }
            }
        });
        KDBizPromptBox f7lostStra = new KDBizPromptBox();
        f7lostStra.setSelector(new KDPromptSelector(){
            private EtlLostStrategyUI lostStraUI = null;

            public Object getData() {
                LostStrategy_ETL data = null;
                if (this.lostStraUI != null) {
                    data = this.lostStraUI.result;
                }
                return data;
            }

            public boolean isCanceled() {
                if (this.lostStraUI != null) {
                    return this.lostStraUI.isCancel;
                }
                return false;
            }

            public void show() {
                try {
                    UIContext uiContext = new UIContext((Object)EtlDispatchManagerEditUI.this);
                    int row = KDTableUtil.getSelectedRow((KDTable)EtlDispatchManagerEditUI.this.tblScheme);
                    if (row > -1) {
                        Object value = EtlDispatchManagerEditUI.this.tblScheme.getRow(row).getCell("etlScheme").getValue();
                        if (value instanceof EtlSchemeManagerInfo) {
                            EtlSchemeManagerInfo schemeInfo = (EtlSchemeManagerInfo)value;
                            if (schemeInfo.getComDBMapping() == null) {
                                uiContext.put((Object)"isBatch", (Object)"false");
                            } else {
                                uiContext.put((Object)"isBatch", (Object)("" + (schemeInfo.getComDBMapping().getEntry().size() > 1)));
                            }
                        } else {
                            uiContext.put((Object)"isBatch", (Object)"false");
                        }
                        uiContext.put((Object)"strategy", EtlDispatchManagerEditUI.this.tblScheme.getRow(row).getCell("lost").getValue());
                    }
                    IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EtlLostStrategyUI.class.getName(), (Map)uiContext, null);
                    window.show();
                    this.lostStraUI = (EtlLostStrategyUI)window.getUIObject();
                }
                catch (UIException e) {
                    EtlDispatchManagerEditUI.this.handUIException(e);
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        });
        KDTDefaultCellEditor lostEditor = new KDTDefaultCellEditor((IKDEditor)f7lostStra);
        this.tblScheme.getColumn("lost").setEditor((ICellEditor)lostEditor);
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblScheme.addRow();
    }

    @Override
    protected void btnMinus_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblScheme.getSelectManager().size() == 0 || this.isTableColumnSelected(this.tblScheme)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"notSelect"));
            return;
        }
        int top = this.tblScheme.getSelectManager().get().getTop();
        if (this.tblScheme.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"notSelect"));
            return;
        }
        this.tblScheme.removeRow(top);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
            if (this.getOprtState() == OprtState.ADDNEW) {
                this.txtPeriod.setText(null);
            }
        }
        catch (Exception e1) {
            this.setLostStrategy();
            throw e1;
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IEtlDispatchManager ietlDispatch;
        EtlDispatchManagerInfo info;
        String id = this.editData.getId().toString();
        if (id == null) {
            SysUtil.abort();
        }
        if ((info = (ietlDispatch = EtlDispatchManagerFactory.getRemoteInstance()).getEtlDispatchManagerInfo((IObjectPK)new ObjectStringPK(id))).isIsUsed()) {
            MsgBox.showWarning((String)EASResource.getString((String)resourceFileName, (String)"notEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IEtlDispatchManager ietlDispatch;
        EtlDispatchManagerInfo info;
        String id = this.editData.getId().toString();
        if (id == null) {
            SysUtil.abort();
        }
        if ((info = (ietlDispatch = EtlDispatchManagerFactory.getRemoteInstance()).getEtlDispatchManagerInfo((IObjectPK)new ObjectStringPK(id))).isIsUsed()) {
            MsgBox.showWarning((String)EASResource.getString((String)resourceFileName, (String)"notRemove"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String period;
        super.verifyInput(e);
        String number = this.txtNumber.getText();
        if (StringUtils.isEmpty((String)number)) {
            this.txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"numberIsNotNull"));
            SysUtil.abort();
        } else {
            char[] chs = number.trim().toCharArray();
            Pattern p = Pattern.compile("[a-zA-Z_0-9]");
            for (int i = 0; i < chs.length; ++i) {
                Matcher m = p.matcher(Character.toString(chs[i]));
                if (m.matches()) continue;
                this.txtNumber.requestFocus(true);
                MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"onlyCharOANum"));
                SysUtil.abort();
            }
        }
        Object objName = this.txtName.getDefaultLangItemData();
        if (objName == null || StringUtils.isEmpty((String)objName.toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"nameIsNotNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)(period = this.txtPeriod.getText()))) {
            this.txtPeriod.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"periodIsNotNull"));
            SysUtil.abort();
        }
        if (this.tblScheme.getRowCount() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"schemeIsNotNull"));
            SysUtil.abort();
        }
        for (int r = this.tblScheme.getRowCount() - 1; r >= 0; --r) {
            IRow row = this.tblScheme.getRow(r);
            for (int c = this.tblScheme.getColumnCount() - 1; c >= 0; --c) {
                ICell cell = row.getCell(c);
                if (cell.getValue() != null) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourceFileName, (String)"dataNotIntegrity"));
                SysUtil.abort();
            }
        }
    }

    protected void tblScheme_editStopped(KDTEditEvent e) throws Exception {
        if (!this.tblScheme.getColumnKey(e.getColIndex()).equals("etlScheme")) {
            return;
        }
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        if (oldValue == null && newValue == null) {
            return;
        }
        if (newValue instanceof EtlSchemeManagerInfo && oldValue instanceof EtlSchemeManagerInfo) {
            EtlSchemeManagerInfo n = (EtlSchemeManagerInfo)newValue;
            EtlSchemeManagerInfo o = (EtlSchemeManagerInfo)oldValue;
            if (o.getId().toString().equals(n.getId().toString())) {
                return;
            }
        }
        this.tblScheme.getRow(e.getRowIndex()).getCell("lost").setValue(null);
    }

    @Override
    protected IObjectValue createNewData() {
        EtlDispatchManagerInfo info = new EtlDispatchManagerInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setIsUsed(false);
        info.setIsExecute(false);
        Object objGroup = this.getUIContext().get("groupInfo");
        if (objGroup instanceof EtlDispatchManagerGroupInfo) {
            info.setGroup((EtlDispatchManagerGroupInfo)objGroup);
        }
        info.setStatus(EtlDispatchStatusEnum.NOTSTART);
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EtlDispatchManagerFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("isUsed");
        sic.add("BIProjectScheme");
        sic.add("etlBatchScheme.id");
        sic.add("etlBatchScheme.name");
        sic.add("etlBatchScheme.number");
        sic.add("etlSchemeTemplate.id");
        sic.add("etlSchemeTemplate.name");
        sic.add("etlSchemeTemplate.number");
        return sic;
    }
}

