/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.IEtlSchemeManager;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport.socket.Bytes;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class UpLoadFileAction {
    private static final String resourceFileName = "com.kingdee.eas.framework.bireport.bimanager.etl.client.EtlClientResource";

    public static void uploadFile(CoreUI ui, String id, boolean flag, String title) throws Exception {
        IEtlSchemeManager ischeme = EtlSchemeManagerFactory.getRemoteInstance();
        EtlSchemeManagerInfo schemeinfo = ischeme.getEtlSchemeManagerInfo((IObjectPK)new ObjectStringPK(id));
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".xml") || name.endsWith(".ktr");
            }

            @Override
            public String getDescription() {
                return "ETL\u65b9\u6848\u6587\u4ef6\uff08*.ktr; *.xml\uff09";
            }
        });
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        byte[] bytes = null;
        try {
            bytes = Bytes.getBytes(filePath);
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)ui, (String)"\u4e0a\u4f20\u5931\u8d25");
            return;
        }
        if (bytes != null && bytes.length != 0) {
            if (flag) {
                schemeinfo.setFileWay(bytes);
            } else {
                schemeinfo.setCatchScheme(bytes);
            }
            ischeme.save((CoreBaseInfo)schemeinfo);
            MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"etlFileUpOK"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)resourceFileName, (String)"etlUpFileLost"));
        }
    }

    public static Document getDocumentFile(String filePath) throws Exception {
        File file = new File(filePath);
        Document doc = null;
        if (file.exists()) {
            SAXReader reader = new SAXReader();
            doc = reader.read(file);
        }
        return doc;
    }
}

