/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlSchemeManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.ETLSchemeBean;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.KettleMessageListener;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.KettleServer;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.PackData;
import com.kingdee.eas.framework.bireport.bimanager.etl.client.kettleserver.VoidResultBean;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionMap;
import com.kingdee.eas.util.client.MsgBox;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class KettleMessageListenerImpl
implements KettleMessageListener {
    private EtlSchemeManagerInfo info;
    private boolean isTryCatch;
    private String schemeID;
    private String id;
    private boolean isUsed;

    public KettleMessageListenerImpl(EtlSchemeManagerInfo info, boolean isTryCatch) throws Exception {
        this.info = info;
        this.isTryCatch = isTryCatch;
        this.id = info.getId().toString();
        this.schemeID = info.getId().toString() + (isTryCatch ? "1" : "0");
        this.isUsed = info.isIsUsed();
    }

    @Override
    public Object onMessage(PackData pd) {
        String command = pd.getCommand();
        if ("SAVE".equals(command)) {
            boolean hasencoding;
            if (this.isUsed) {
                return "schemeisUsed";
            }
            String[] args = pd.getArgs();
            String scheme = args[0];
            boolean bl = hasencoding = scheme.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>") > 0;
            if (!hasencoding) {
                scheme = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + scheme;
            }
            try {
                if (this.isTryCatch) {
                    this.info.setFileWay(scheme.getBytes("UTF-8"));
                } else {
                    this.info.setCatchScheme(scheme.getBytes("UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            try {
                EtlSchemeManagerFactory.getRemoteInstance().save((CoreBaseInfo)this.info);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            return "null";
        }
        if ("QUIT".equals(command)) {
            KettleServer.removeMessageListener(this.schemeID);
            KettleServer.closeAclient(this.schemeID);
            return "null";
        }
        if ("GET_SCHEMA_CONTENT".equals(command)) {
            DBCenterModel centerKettleModel = null;
            if (this.info.getDataCenter(0) != null) {
                try {
                    centerKettleModel = DBConnectionMap.getInstance(null).get(this.info.getDataCenter(0));
                }
                catch (Exception scheme) {
                    // empty catch block
                }
            }
            LinkedList<DBCenterModel> dbCenter_list = new LinkedList<DBCenterModel>();
            List centers = DBConnectionMap.getInstance(null).getDBCenters();
            for (int i = 0; i < centers.size(); ++i) {
                DBCenterModel model = DBConnectionMap.copyDBCenterModel((DBCenterModel)centers.get(i));
                String dbCenterId = model.getDbCenterId();
                model.setDbCenterId(model.getDbName());
                model.setPassWord("psw");
                model.setDbName(dbCenterId);
                dbCenter_list.add(model);
            }
            if (centerKettleModel != null) {
                centerKettleModel.setDbCenterName("\u6a21\u677f\u6570\u636e\u4e2d\u5fc3");
                String dbCenterId = centerKettleModel.getDbCenterId();
                centerKettleModel.setDbCenterId(centerKettleModel.getDbName());
                centerKettleModel.setDbName("temp_" + dbCenterId);
                centerKettleModel.setPassWord("psw");
                dbCenter_list.add(centerKettleModel);
            }
            return dbCenter_list;
        }
        if ("GET_SCHEME".equals(command)) {
            ETLSchemeBean schem = new ETLSchemeBean();
            try {
                if (this.isTryCatch) {
                    if (this.info.getFileWay() == null) {
                        return "null";
                    }
                    schem.schemeETLXML = new String(this.info.getFileWay(), "UTF-8");
                } else {
                    if (this.info.getCatchScheme() == null) {
                        return "null";
                    }
                    schem.schemeETLXML = new String(this.info.getCatchScheme(), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                return "UnsupportedEncodingException";
            }
            return schem;
        }
        if ("START_CLIENT".equals(command)) {
            KettleServer.addClient(this.schemeID);
            return new VoidResultBean("START_CLIENT");
        }
        if ("GET_PARAMS".equals(command)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("kettle_commandID", this.info.getCompanyID(0));
            map.put("isEASParam", "true");
            return map;
        }
        if ("Re_Conntion".equals(command)) {
            VoidResultBean rs = new VoidResultBean("Re_Conntion");
            try {
                KettleServer.updateClientAccess(this.schemeID);
            }
            catch (Exception e) {
                rs.exception = e.getMessage();
            }
            return rs;
        }
        MsgBox.showWarning((String)("Received unknow command:" + command));
        return null;
    }
}

