/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.RMIInvoke;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.TimeOutException;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport.TransportObj;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ConnectFuture;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoConnector;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandlerAdapter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.BaseIoConnectorConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.filter.codec.ProtocolCodecFilter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractConnection
implements RMIInvoke {
    private String socketServerHost = "127.0.0.1";
    private int port;
    private Object lock = new Object();
    private static final int CONNECT_TIMEOUT = 30;
    private IoSession session;
    private Map messageCache = new Hashtable();
    private static final int defaultWaitTime = 100;

    public AbstractConnection(String socketServerHost, int port) {
        this.socketServerHost = socketServerHost;
        this.port = port;
        this.init();
    }

    protected abstract IoConnector createConnector();

    protected abstract BaseIoConnectorConfig getConfig();

    private void init() {
        IoConnector connector = this.createConnector();
        BaseIoConnectorConfig cfg = this.getConfig();
        cfg.setConnectTimeout(30);
        cfg.getFilterChain().addLast("codec", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
        ConnectFuture connectFuture = connector.connect((SocketAddress)new InetSocketAddress(this.socketServerHost, this.port), new IoHandlerAdapter(){

            @Override
            public void messageReceived(IoSession session, Object message) throws Exception {
                AbstractConnection.this.msgReceived(session, message);
            }

            @Override
            public void messageSent(IoSession session, Object message) throws Exception {
                AbstractConnection.this.messageSent(session, message);
            }
        }, cfg);
        connectFuture.join();
        this.session = connectFuture.getSession();
    }

    private IoSession getSession() {
        return this.session;
    }

    @Override
    public void exit() {
        if (this.session != null) {
            this.session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgReceived(IoSession session, Object message) {
        if (message instanceof TransportObj) {
            TransportObj to = (TransportObj)message;
            if (this.messageCache.containsKey(to.id)) {
                TransportObj command = (TransportObj)this.messageCache.get(to.id);
                command.setResult(to.getResult());
                Object object = command.lock;
                synchronized (object) {
                    command.lock.notify();
                }
            }
        }
    }

    private void messageSent(IoSession session, Object message) {
        if (message instanceof TransportObj) {
            TransportObj to = (TransportObj)message;
            this.messageCache.put(to.id, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object obj) throws IOException {
        if (this.getSession() == null) {
            throw new IOException();
        }
        TransportObj to = new TransportObj(obj);
        this.getSession().write(to);
        int i = 0;
        while (i < 100) {
            ++i;
            Object object = to.lock;
            synchronized (object) {
                if (!to.isComplete) {
                    try {
                        to.lock.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    break;
                }
            }
        }
        if (i == 100) {
            throw new TimeOutException();
        }
        return to.getResult();
    }
}

