/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.bireport.bimanager.InvokeResultEnum;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.EtlDispatchManagerInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.schedule.ETLDispatchCallBackAtTomcatImpl;
import com.kingdee.eas.framework.bireport.bimanager.sc.EMailSendTo;
import com.kingdee.eas.framework.bireport.bimanager.util.DispatchChainCallBack;
import com.kingdee.eas.framework.bireport.bimanager.util.IDispatchCallBack;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class ETLDispatchChainCallBackImpl
implements DispatchChainCallBack {
    public EtlDispatchManagerInfo info;
    public Context ctx;
    public StringBuffer logInfo = new StringBuffer();
    public String dispatchLogID = "";
    public Timestamp startTime = null;
    public Iterator iter = null;
    public int index = -1;
    private StringBuffer exceptionStr = new StringBuffer();

    public ETLDispatchChainCallBackImpl(Context ctx, EtlDispatchManagerInfo info) {
        this.ctx = ctx;
        this.info = info;
        this.iter = info.getEntry().iterator();
        if (info.getDispatchLogID() == null) {
            this.dispatchLogID = BOSUuid.create((BOSObjectType)new EtlDispatchLogInfo().getBOSType()).toString();
            info.setDispatchLogID(this.dispatchLogID);
        }
        this.dispatchLogID = info.getDispatchLogID();
        Date date = new Date();
        this.startTime = new Timestamp(date.getTime());
        for (int i = 0; i < info.getEntry().size(); ++i) {
            EtlDispatchManagerEntryInfo etlDispatchManagerEntryInfo = info.getEntry().get(i);
        }
    }

    @Override
    public void completeAll(InvokeResultEnum str) {
        Date date2 = new Date();
        Timestamp endTime = new Timestamp(date2.getTime());
        EtlDispatchLogInfo dispatchLogInfo = new EtlDispatchLogInfo();
        dispatchLogInfo.setId(BOSUuid.read((String)this.dispatchLogID));
        dispatchLogInfo.setStartTime(this.startTime);
        dispatchLogInfo.setEndTime(endTime);
        dispatchLogInfo.setEtlDispatchID(this.info.getId().toString());
        dispatchLogInfo.setLogContent(this.logInfo.toString().getBytes());
        dispatchLogInfo.setStatus(str.getAlias());
        try {
            EtlDispatchLogFactory.getLocalInstance(this.ctx).addLogInfo(dispatchLogInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public IDispatchCallBack next() {
        ++this.index;
        EtlDispatchManagerEntryInfo entryInfo = (EtlDispatchManagerEntryInfo)this.iter.next();
        ETLDispatchCallBackAtTomcatImpl callBack = new ETLDispatchCallBackAtTomcatImpl(this.ctx, entryInfo, this.index, this.dispatchLogID);
        return callBack;
    }

    @Override
    public void logException(Exception e) {
        this.exceptionStr.append(e.getMessage());
        this.exceptionStr.append("\n");
    }

    public String getExceptionStr() {
        return this.exceptionStr.toString();
    }

    public String getLogInfo() {
        return this.logInfo.toString();
    }

    public void setExceptionStr(StringBuffer sb) {
        this.exceptionStr = sb;
    }

    public void setLogInfo(StringBuffer sb) {
        this.logInfo = sb;
    }

    @Override
    public void logInfo(String str) {
        this.logInfo.append(str);
        this.logInfo.append("\n");
    }

    @Override
    public boolean first() {
        return true;
    }

    @Override
    public void waitIsCanExcute() {
    }

    public String getExceptionInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("\u6267\u884c\u65e5\u5fd7:\n");
        sb.append(this.logInfo.toString());
        sb.append("\n\u5f02\u5e38\u5982\u4e0b:\n");
        sb.append(this.exceptionStr.toString());
        sb.append("\n\u60c5\u5f62\u89c1web server\u8c03\u5ea6\u76d1\u63a7\u3002");
        return sb.toString();
    }

    @Override
    public String getEmailTitle() {
        boolean flag;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer();
        sb.append("ETL\u65b9\u6848  ");
        sb.append(this.info.getName());
        boolean bl = flag = this.exceptionStr.length() == 0;
        if (flag) {
            sb.append("\u6267\u884c\u6210\u529f\uff01\u62bd\u53d6\u65f6\u95f4:" + sdf.format(this.startTime));
        } else {
            sb.append("\u6267\u884c\u5931\u8d25\uff01\u62bd\u53d6\u65f6\u95f4:" + sdf.format(this.startTime));
        }
        return sb.toString();
    }

    @Override
    public String[] getEmailSendTo() {
        try {
            String[] str = EMailSendTo.getPersonEmails(this.ctx, null);
            if (str == null) {
                // empty if block
            }
            return str;
        }
        catch (BOSException e) {
            this.logInfo("\u83b7\u53d6\u90ae\u4ef6\u6536\u4fe1\u4eba\u5931\u8d25\uff01");
            this.logInfo(e.getMessage());
            return null;
        }
    }

    @Override
    public String getLogMessageInfo() {
        return this.logInfo.toString();
    }

    @Override
    public String getException() {
        return this.exceptionStr.toString();
    }
}

