/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.mdm.client;

import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.FieldTypeEnum;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataFactory;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.MasterDataModelInfo;
import com.kingdee.eas.framework.bireport.bimanager.mdm.client.AbstractMasterDataInputEditUI;
import com.kingdee.eas.framework.bireport.bimanager.util.BiManagerUtil;
import com.kingdee.eas.framework.bireport.bimanager.util.Constant;
import com.kingdee.eas.framework.bireport.bimanager.util.client.BIClientVerifyHelper;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class MasterDataInputEditUI
extends AbstractMasterDataInputEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MasterDataInputEditUI.class);
    private HashMap uiMap = new HashMap();
    private UIContext uiCtx;
    private HashMap oldData;

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        this.initWorkButton();
        this.initUI();
        this.showInfo();
    }

    private void showInfo() throws Exception {
        this.removeAll();
        this.uiMap.clear();
        this.uiCtx = new UIContext((Object)this);
        this.uiCtx.putAll(this.getUIContext());
        MasterDataModelInfo dataModel = (MasterDataModelInfo)this.uiCtx.get((Object)"dataModel");
        MasterDataModelEntryCollection col = dataModel.getEntry();
        if (col == null || col.size() <= 0) {
            MsgBox.showInfo((String)Constant.ModelNotCompleted);
            SysUtil.abort();
        }
        int x = 10;
        int y = 10;
        MasterDataModelEntryInfo entry = null;
        FieldTypeEnum fieldType = null;
        KDFormattedTextField component = null;
        String fieldName = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.uiCtx.get((Object)"node");
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.oldData = (HashMap)node.getUserObject();
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            KDFormattedTextField comp;
            entry = col.get(i);
            fieldName = entry.getAttribute();
            fieldType = entry.getFieldType();
            KDLabelContainer label = new KDLabelContainer();
            label.setBoundLabelText(entry.getAlias());
            label.setBoundLabelLength(100);
            label.setBoundLabelUnderline(true);
            label.setBounds(new Rectangle(x, y, 270, 19));
            this.add((Component)label, null);
            y += 30;
            if (FieldTypeEnum.Integer.equals((Object)fieldType)) {
                comp = new KDFormattedTextField();
                comp.setHorizontalAlignment(2);
                comp.setDataType(0);
                comp.setName(fieldName);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(fieldName));
                }
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.Decimal.equals((Object)fieldType)) {
                comp = new KDFormattedTextField();
                comp.setHorizontalAlignment(2);
                comp.setDataType(1);
                comp.setMinimumValue((Comparable)new BigDecimal("-1.0E18"));
                comp.setMaximumValue((Comparable)new BigDecimal("1.0E18"));
                comp.setPrecision(10);
                comp.setName(fieldName);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(fieldName));
                }
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.Date.equals((Object)fieldType)) {
                comp = new KDDatePicker();
                comp.setName(fieldName);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(fieldName));
                }
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.DateTime.equals((Object)fieldType)) {
                comp = new KDDatePicker();
                comp.setTimeEnabled(true);
                comp.setName(fieldName);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setValue(this.oldData.get(fieldName));
                }
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
            } else if (FieldTypeEnum.Text.equals((Object)fieldType)) {
                comp = new KDTextField();
                comp.setMaxLength(80);
                comp.setName(fieldName);
                if (!entry.isIsNull()) {
                    comp.setRequired(true);
                }
                label.setBoundEditor((JComponent)comp);
                component = comp;
                if (this.oldData != null) {
                    comp.setText((String)this.oldData.get(fieldName));
                }
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    comp.setEnabled(false);
                }
                if (Constant.ID.equals(fieldName)) {
                    comp.setEnabled(false);
                    if (this.oldData == null) {
                        comp.setText(Uuid.create().toString());
                    } else {
                        comp.setText((String)this.oldData.get(Constant.ID));
                    }
                }
                if (Constant.ParentID.equals(fieldName)) {
                    comp.setEnabled(false);
                    if (this.oldData == null) {
                        if (node.getUserObject() instanceof HashMap) {
                            comp.setText((String)((HashMap)node.getUserObject()).get(Constant.ID));
                        }
                    } else {
                        comp.setText((String)this.oldData.get(Constant.ParentID));
                    }
                }
            }
            this.uiMap.put(fieldName, component);
        }
    }

    private void initUI() {
        super.lockAction();
        ItemAction[] itemActions = new ItemAction[]{this.actionSubmit};
        BiManagerUtil.setActionsEnabledStatus(itemActions, true);
        BiManagerUtil.setVisibleToolBarStatus(this.toolBar);
        BiManagerUtil.setVisibleMenuBarStatus(this.menuBar);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BIClientVerifyHelper.verifyRequire((CoreUIObject)this);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        StringBuffer sb = new StringBuffer();
        SqlParams params = new SqlParams();
        if (this.oldData != null) {
            sb.append("delete from ").append(this.uiCtx.get((Object)"tableName").toString()).append(" where id=?");
            params.addString((String)this.oldData.get(Constant.ID));
            MasterDataFactory.getRemoteInstance().executeSql(sb.toString(), params);
        }
        sb = new StringBuffer();
        params = new SqlParams();
        sb.append("insert into ").append(this.uiCtx.get((Object)"tableName").toString()).append(" (");
        StringBuffer valueSb = new StringBuffer();
        Component[] components = this.getComponents();
        Component comp2 = null;
        IKDComponent c = null;
        String fieldName = null;
        for (Component comp2 : components) {
            Object obj;
            KDTextField txtEditor;
            KDLabelContainer ct;
            JComponent editor;
            if (!(comp2 instanceof KDLabelContainer) || !this.uiMap.containsKey(fieldName = (editor = (ct = (KDLabelContainer)comp2).getBoundEditor()).getName())) continue;
            c = (IKDComponent)editor;
            if (editor instanceof KDTextField) {
                txtEditor = (KDTextField)editor;
                obj = txtEditor.getText();
                if (obj == null) continue;
                sb.append(fieldName).append(",");
                valueSb.append("?,");
                params.addString((String)obj);
                continue;
            }
            if (editor instanceof KDDatePicker) {
                txtEditor = (KDDatePicker)editor;
                obj = txtEditor.getTimestamp();
                if (obj == null) continue;
                sb.append(fieldName).append(",");
                valueSb.append("?,");
                params.addObject(obj);
                continue;
            }
            if (!(editor instanceof KDFormattedTextField) || (obj = (txtEditor = (KDFormattedTextField)editor).getNumberValue()) == null) continue;
            sb.append(fieldName).append(",");
            valueSb.append("?,");
            params.addObject((Object)new Double(((Number)obj).doubleValue()));
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        valueSb.replace(valueSb.length() - 1, valueSb.length(), "");
        sb.append(") values (").append(valueSb).append(")");
        MasterDataFactory.getRemoteInstance().executeSql(sb.toString(), params);
        MsgBox.showInfo((String)Constant.SaveSuccess);
        this.disposeUIWindow();
    }
}

