/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class Queue
extends AbstractList
implements List,
Serializable {
    private static final long serialVersionUID = 3835151744526464313L;
    private static final int DEFAULT_CAPACITY = 4;
    private static final int DEFAULT_MASK = 3;
    private Object[] items = new Object[4];
    private int mask = 3;
    private int first = 0;
    private int last = 0;
    private int size = 0;

    public int capacity() {
        return this.items.length;
    }

    @Override
    public void clear() {
        Arrays.fill(this.items, null);
        this.first = 0;
        this.last = 0;
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        Object ret = this.items[this.first];
        this.items[this.first] = null;
        this.decreaseSize();
        return ret;
    }

    public void push(Object item) {
        if (item == null) {
            throw new NullPointerException("item");
        }
        this.ensureCapacity();
        this.items[this.last] = item;
        this.increaseSize();
    }

    public Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.first];
    }

    public Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.last + this.items.length - 1 & this.mask];
    }

    public Object get(int idx) {
        this.checkIndex(idx);
        return this.items[this.getRealIndex(idx)];
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        return "first=" + this.first + ", last=" + this.last + ", size=" + this.size + ", mask = " + this.mask;
    }

    private void checkIndex(int idx) {
        if (idx < 0 || idx >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(idx));
        }
    }

    private int getRealIndex(int idx) {
        return this.first + idx & this.mask;
    }

    private void increaseSize() {
        this.last = this.last + 1 & this.mask;
        ++this.size;
    }

    private void decreaseSize() {
        this.first = this.first + 1 & this.mask;
        --this.size;
    }

    private void ensureCapacity() {
        if (this.size < this.items.length) {
            return;
        }
        int oldLen = this.items.length;
        Object[] tmp = new Object[oldLen * 2];
        if (this.first < this.last) {
            System.arraycopy(this.items, this.first, tmp, 0, this.last - this.first);
        } else {
            System.arraycopy(this.items, this.first, tmp, 0, oldLen - this.first);
            System.arraycopy(this.items, 0, tmp, oldLen - this.first, this.last);
        }
        this.first = 0;
        this.last = oldLen;
        this.items = tmp;
        this.mask = tmp.length - 1;
    }

    @Override
    public boolean add(Object o) {
        this.push(o);
        return true;
    }

    public Object set(int idx, Object o) {
        this.checkIndex(idx);
        int realIdx = this.getRealIndex(idx);
        Object old = this.items[realIdx];
        this.items[realIdx] = o;
        return old;
    }

    public void add(int idx, Object o) {
        if (idx == this.size) {
            this.push(o);
            return;
        }
        this.checkIndex(idx);
        this.ensureCapacity();
        int realIdx = this.getRealIndex(idx);
        if (this.first < this.last) {
            System.arraycopy(this.items, realIdx, this.items, realIdx + 1, this.last - realIdx);
        } else if (realIdx >= this.first) {
            System.arraycopy(this.items, 0, this.items, 1, this.last);
            this.items[0] = this.items[this.items.length - 1];
            System.arraycopy(this.items, realIdx, this.items, realIdx + 1, this.items.length - realIdx - 1);
        } else {
            System.arraycopy(this.items, realIdx, this.items, realIdx + 1, this.last - realIdx);
        }
        this.items[realIdx] = o;
        this.increaseSize();
    }

    public Object remove(int idx) {
        if (idx == 0) {
            return this.pop();
        }
        this.checkIndex(idx);
        int realIdx = this.getRealIndex(idx);
        Object removed = this.items[realIdx];
        if (this.first < this.last) {
            System.arraycopy(this.items, this.first, this.items, this.first + 1, realIdx - this.first);
        } else if (realIdx >= this.first) {
            System.arraycopy(this.items, this.first, this.items, this.first + 1, realIdx - this.first);
        } else {
            System.arraycopy(this.items, 0, this.items, 1, realIdx);
            this.items[0] = this.items[this.items.length - 1];
            System.arraycopy(this.items, this.first, this.items, this.first + 1, this.items.length - this.first - 1);
        }
        this.items[this.first] = null;
        this.decreaseSize();
        return removed;
    }

    public boolean offer(Object o) {
        this.push(o);
        return true;
    }

    public Object poll() {
        return this.pop();
    }

    public Object remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.pop();
    }

    public Object peek() {
        return this.first();
    }

    public Object element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first();
    }
}

