/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.eas.framework.bireport.bimanager.GetDBCenterFacadeFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DBConnectionMap {
    private List dbCenters;
    Map cache = new Hashtable();
    public Context ctx;
    private static DBConnectionMap instance;

    private DBConnectionMap() {
    }

    public static synchronized DBConnectionMap getInstance(Context ctx) {
        instance = null;
        if (instance == null) {
            instance = new DBConnectionMap();
            DBConnectionMap.instance.ctx = ctx;
            instance.init();
        }
        return instance;
    }

    public Iterator iterator() {
        if (this.dbCenters == null) {
            return null;
        }
        return this.dbCenters.iterator();
    }

    public List getDBCenters() {
        return this.dbCenters;
    }

    private synchronized void setDBCenters(List list) {
        this.dbCenters = list;
        this.cache.clear();
        for (int i = 0; list != null && i < list.size(); ++i) {
            DBCenterModel model = (DBCenterModel)list.get(i);
            this.cache.put(model.getDbCenterId(), model);
        }
    }

    private List getDBCenter() {
        try {
            if (this.ctx == null) {
                return GetDBCenterFacadeFactory.getRemoteInstance().getDBConnectionCollection();
            }
            return GetDBCenterFacadeFactory.getLocalInstance(this.ctx).getDBConnectionCollection();
        }
        catch (BOSException e) {
            return null;
        }
    }

    public synchronized void init() {
        if (this.dbCenters != null && this.dbCenters.size() > 0) {
            return;
        }
        List center = this.getDBCenter();
        this.setDBCenters(center);
    }

    public synchronized void reInit() {
        List center = this.getDBCenter();
        this.setDBCenters(center);
    }

    public static DBCenterModel copyDBCenterModel(DBCenterModel source) {
        DBCenterModel modle = new DBCenterModel();
        modle.setBusiType(source.getBusiType());
        modle.setDbCenterId(source.getDbCenterId());
        modle.setDbCenterName(source.getDbCenterName());
        modle.setDbName(source.getDbName());
        modle.setDbType(source.getDbType());
        modle.setMaxActive(source.getMaxActive());
        modle.setMaxIdle(source.getMaxIdle());
        modle.setMinIdle(source.getMinIdle());
        modle.setMaxWait(source.getMaxWait());
        modle.setMinIdle(source.getMinIdle());
        modle.setPassWord(source.getPassWord());
        modle.setPort(source.getPort());
        modle.setUrl(source.getUrl());
        modle.setUserName(source.getUserName());
        modle.setWhenExhausted(source.getWhenExhausted());
        return modle;
    }

    public synchronized DBCenterModel get(String id) throws Exception {
        DBCenterModel model;
        int i;
        if (this.cache.containsKey(id)) {
            return (DBCenterModel)this.cache.get(id);
        }
        if (this.dbCenters == null || this.dbCenters.size() == 0) {
            this.init();
        }
        for (i = 0; i < this.dbCenters.size(); ++i) {
            model = (DBCenterModel)this.dbCenters.get(i);
            if (!model.getDbCenterId().equals(id)) continue;
            return model;
        }
        this.reInit();
        for (i = 0; i < this.dbCenters.size(); ++i) {
            model = (DBCenterModel)this.dbCenters.get(i);
            if (!model.getDbCenterId().equals(id)) continue;
            return model;
        }
        throw new Exception("\u670d\u52a1\u5668\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5931\u8d25!");
    }
}

