/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.ws.schedule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.bireport.bimanager.InvokeResultEnum;
import com.kingdee.eas.framework.bireport.bimanager.sc.EMailSendTo;
import com.kingdee.eas.framework.bireport.bimanager.util.DBConnectionTypeInfo;
import com.kingdee.eas.framework.bireport.bimanager.util.DispatchChainCallBack;
import com.kingdee.eas.framework.bireport.bimanager.util.IDispatchCallBack;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WSCompanyDBMappingEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeEntryCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeEntryInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsDispatchSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.WsExtractSchemeInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.util.UUIDUtil;
import com.kingdee.eas.framework.bireport.bimanager.ws.engine.visit.ClientAgent;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsScheduleLogFactory;
import com.kingdee.eas.framework.bireport.bimanager.ws.log.WsScheduleLogInfo;
import com.kingdee.eas.framework.bireport.bimanager.ws.schedule.WSDispatchCallBackImpl;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class WSDispatchChainCallBackImpl
implements DispatchChainCallBack {
    public WsDispatchSchemeInfo info;
    public Context ctx;
    public long id = 0L;
    public Map agent_ctx = new HashMap();
    public Map conn_ctx = new HashMap();
    public Iterator iter = null;
    private StringBuffer exceptions = new StringBuffer();
    private StringBuffer infos = new StringBuffer();
    private Date startTime;

    public WsDispatchSchemeInfo getWsDispatchSchemeInfo() {
        return this.info;
    }

    public void setContext(Map map) {
    }

    public WSDispatchChainCallBackImpl(Context ctx, WsDispatchSchemeInfo info) throws SQLException {
        this.ctx = ctx;
        this.info = info;
        this.startTime = new Date();
        this.id = new UUIDUtil().genUuid();
        this.iter = info.getEntry().iterator();
    }

    @Override
    public boolean first() {
        try {
            WsDispatchSchemeFactory.getLocalInstance(this.ctx).setIsExcuteFlag(this.info.getId().toString(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void completeAll(InvokeResultEnum str) {
        WsScheduleLogInfo logInfo = new WsScheduleLogInfo();
        logInfo.setStartTime(new Timestamp(this.startTime.getTime()));
        logInfo.setEndTime(new Timestamp(new Date().getTime()));
        logInfo.setLogContext(this.infos.toString());
        logInfo.setLogException(this.exceptions.toString());
        logInfo.setId(this.id);
        logInfo.setRunResult(str);
        logInfo.setDispatchSchemeID(this.info.getId().toString());
        try {
            WsScheduleLogFactory.getLocalInstance(this.ctx).addnew(logInfo);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        try {
            WsDispatchSchemeFactory.getLocalInstance(this.ctx).setIsExcuteFlag(this.info.getId().toString(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Object next : this.agent_ctx.keySet()) {
            Object object = this.agent_ctx.get(next);
            if (!(object instanceof ClientAgent)) continue;
            ClientAgent agent = (ClientAgent)object;
            agent.client().terminal();
        }
        for (Object key : this.conn_ctx.keySet()) {
            DBConnectionTypeInfo povProvider = (DBConnectionTypeInfo)this.conn_ctx.get(key);
            try {
                povProvider.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public IDispatchCallBack next() {
        return new WSDispatchCallBackImpl(this.ctx, (WsDispatchSchemeEntryInfo)this.iter.next(), this.id, this.agent_ctx, this.conn_ctx);
    }

    @Override
    public void logException(Exception e) {
        this.exceptions.append(e.getMessage());
        this.exceptions.append("\n");
    }

    @Override
    public void logInfo(String obj) {
        this.infos.append(obj);
        this.infos.append("\n");
    }

    public StringBuffer getLogInfo() {
        return this.infos;
    }

    public void setLogInfo(StringBuffer sb) {
        this.infos = sb;
    }

    public void setExceptionStr(StringBuffer sb) {
        this.exceptions = sb;
    }

    public StringBuffer getExceptionStr() {
        return this.exceptions;
    }

    @Override
    public void waitIsCanExcute() {
    }

    public String getExceptionInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("\u6267\u884c\u65e5\u5fd7:\n");
        sb.append(this.infos.toString());
        sb.append("\n\u5f02\u5e38\u5982\u4e0b:\n");
        sb.append(this.exceptions.toString());
        sb.append("\n\u60c5\u5f62\u89c1web server\u8c03\u5ea6\u76d1\u63a7\u3002");
        return sb.toString();
    }

    @Override
    public String getEmailTitle() {
        boolean flag;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sb = new StringBuffer();
        sb.append("Web server \u62bd\u53d6\u65b9\u6848 ");
        sb.append(this.info.getName());
        boolean bl = flag = this.exceptions.length() == 0;
        if (flag) {
            sb.append("\u6267\u884c\u6210\u529f\uff01\u62bd\u53d6\u65f6\u95f4:" + sdf.format(this.startTime));
        } else {
            sb.append("\u6267\u884c\u5931\u8d25\uff01\u62bd\u53d6\u65f6\u95f4:" + sdf.format(this.startTime));
        }
        return sb.toString();
    }

    @Override
    public String[] getEmailSendTo() {
        WsDispatchSchemeEntryCollection cols = this.info.getEntry();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < cols.size(); ++i) {
            WsDispatchSchemeEntryInfo entryInfo = cols.get(i);
            WsExtractSchemeInfo wsScheme = entryInfo.getWsScheme();
            if (wsScheme.isIsBatch()) {
                WSCompanyDBMappingEntryCollection batchCompany = wsScheme.getCompanyDBMapping().getEntry();
                Iterator iterator = batchCompany.iterator();
                while (iterator.hasNext()) {
                    WSCompanyDBMappingEntryInfo companyInfo = (WSCompanyDBMappingEntryInfo)iterator.next();
                    if (companyInfo.getCompany() == null) continue;
                    set.add(companyInfo.getCompany().getId().toString());
                }
                continue;
            }
            if (wsScheme.getCompany() == null) continue;
            set.add(wsScheme.getCompany().getId().toString());
        }
        try {
            String[] str = EMailSendTo.getPersonEmails(this.ctx, set);
            if (str == null) {
                // empty if block
            }
            return str;
        }
        catch (BOSException e) {
            this.logInfo("\u83b7\u53d6\u90ae\u4ef6\u6536\u4fe1\u4eba\u5931\u8d25\uff01");
            this.logInfo(e.getMessage());
            return null;
        }
    }

    @Override
    public String getLogMessageInfo() {
        return this.infos.toString();
    }

    @Override
    public String getException() {
        return this.exceptions.toString();
    }
}

