/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.report.forapp.bim.BimReportHelper;
import com.kingdee.bos.ctrl.report.reportframework.ReportException;
import com.kingdee.bos.ctrl.report.reportframework.invoke.IReportInvoker;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.report.LinkUICollection;
import com.kingdee.bos.metadata.report.LinkUIInfo;
import com.kingdee.bos.metadata.report.ParameterInfo;
import com.kingdee.bos.metadata.report.ParameterMappingCollection;
import com.kingdee.bos.metadata.report.ParameterMappingInfo;
import com.kingdee.bos.metadata.report.ReportInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.bim.rpt.client.AbstractBIMCommonReportUI;
import com.kingdee.eas.bim.rpt.client.BIMFormListUI;
import com.kingdee.eas.bim.rpt.client.Messages;
import com.kingdee.eas.bim.rpt.client.util.BIMCommonReportUtil;
import com.kingdee.eas.bim.rpt.client.util.BIMQueryDelegate;
import com.kingdee.eas.bim.rpt.client.util.BIMReportInvoker;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdom.JDOMException;

public class BIMCommonReportUI
extends AbstractBIMCommonReportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BIMCommonReportUI.class);
    private static final String LINK_REPORT_TYPE = "linkReport";
    private static final String LINK_EDITUI_TYPE = "linkEditUI";
    private static final String BIM_RPT_LINK_PARAMS = "BIMLinkParams";
    private static final String COMMON_REPORT_TYPE = "0";
    private static final String CUSTOM_FILTER_UI = "CustomFilterUI";
    private int curIndex = 0;
    private Uuid queryUuid = null;
    private boolean selectForTable = false;
    private boolean isOrderBy = false;
    private boolean theFirstFillData = true;
    private boolean defaultFilterInited;
    private boolean hasQueryPK = false;
    private boolean lessData = false;
    private Exception tableGetDataException = null;
    private String dirRoot;
    private String reportPK;
    private String defaultKDFTemplate = null;
    private ReportInfo rptInfo;
    private QueryInfo queryInfo;
    private boolean isCUQuery = false;
    private OrgType orgType = OrgType.NONE;
    private IReportInvoker reportIvk;
    private IRowSet rs = null;
    private EntityViewInfo selPrintFilter;
    private KDWorkButton btnView = null;
    private int sort = 0;
    private boolean isFristSortTable = true;
    private SorterItemCollection oldSortItem = null;
    private ISortManager sm = null;
    private SorterItemInfo pre_order = null;
    private SorterItemInfo current_order = null;
    private int order_count = 0;

    public BIMCommonReportUI() throws Exception {
        BIMCommonReportUtil.initMetaDataLoader();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.selectFirstRow();
    }

    protected void selectFirstRow() {
        if (!this.isSelectForTable() && this.tblMain.getRow(0) != null) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        if (rowSet == null || rowSet.size() == 0) {
            this.onNoResult();
        }
    }

    protected void onNoResult() {
    }

    public void onLoad() throws Exception {
        Object menuParams = this.getUIContext().get("UIClassParam");
        if (menuParams == null) {
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.RptNotExists"));
            SysUtil.abort();
        } else {
            this.reportPK = menuParams.toString();
        }
        if (this.getUIContext().get(BIM_RPT_LINK_PARAMS) == null) {
            this.setDefaultFilterInited(true);
        } else {
            FilterInfo linkParams = (FilterInfo)this.getUIContext().get(BIM_RPT_LINK_PARAMS);
            this.mainQuery = this.createLinkUIFilter(linkParams);
            this.setDefaultFilterInited(false);
        }
        this.dirRoot = BIMCommonReportUtil.createRootDir();
        logger.debug((Object)("\u62a5\u8868\u5143\u6570\u636e\u6839\u76ee\u5f55:" + this.dirRoot));
        try {
            this.rptInfo = BIMCommonReportUtil.syncLocalMetadata(this.reportPK, this.dirRoot, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.SyncRptTplError"), (String)e.getMessage());
            SysUtil.abort();
        }
        this.setUITitle(this.rptInfo.getAlias());
        try {
            this.orgType = OrgType.getEnum((String)this.rptInfo.getExtendedProperty("OrgType"));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.GetCurrOrgTypeFailed"), (String)err.getMessage());
            logger.error((Object)("\u83b7\u53d6\u5f53\u524d\u62a5\u8868\u6240\u5c5e\u7ec4\u7ec7\u7c7b\u578b\u5931\u8d25: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
            SysUtil.abort();
        }
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionOnLoad");
        try {
            IRowSet rsQuery = BIMCommonReportUtil.getQueryPKs(this.reportPK);
            if (rsQuery.size() == 0) {
                this.mainQueryPK = null;
            } else {
                rsQuery.absolute(1);
                String queryPK = rsQuery.getString("FQueryPKs");
                String[] items = StringUtils.split((String)queryPK, (String)"|");
                this.mainQueryPK = new MetaDataPK(items[0]);
            }
        }
        catch (Exception e) {
            this.mainQueryPK = null;
        }
        try {
            this.defaultKDFTemplate = BIMCommonReportUtil.setDefaultFormTemplate(this.dirRoot, this.reportPK, null, this.rptInfo);
        }
        catch (JDOMException e) {
            e.printStackTrace();
            MsgBox.showWarning((String)Messages.getString("BIMCommonReportUI.KDFTplParseError"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ArrayList list = BIMCommonReportUtil.injectAllClientQuery(this.dirRoot, this.reportPK);
            this.queryInfo = (QueryInfo)list.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.ClientInjectMetaError"), (String)e.getMessage());
            SysUtil.abort();
        }
        try {
            BIMCommonReportUtil.injectServerQuery(this.reportPK);
        }
        catch (BOSException e) {
            e.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.ServerInjectMetaError"), (String)e.getMessage());
            SysUtil.abort();
        }
        this.initToolbar();
        this.setKDTable(this.dirRoot + "/" + BIMCommonReportUtil.formatPKString(this.reportPK) + ".kdt");
        this.setUITitle(this.rptInfo.getAlias());
        this.checkQueryPK();
        super.onLoad();
        this.initListener();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(10);
        KDTableHelper.releaseEnterAndTab((JComponent)this.tblMain);
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
            this.setDataObject((IObjectValue)this.mainQuery);
        }
        this.checkQueryCU();
        if (this.isCUQuery) {
            try {
                this.mainQuery = this.getEntityViewInfo(this.mainQuery);
            }
            catch (BOSException ex) {
                this.handleException((Exception)((Object)ex));
            }
        }
        if (this.isDefaultFilterInited()) {
            this.actionQuery_actionPerformed(null);
        }
        this.enableExportExcel(this.tblMain);
    }

    protected void initListener() {
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (BIMCommonReportUI.this.tableGetDataException != null) {
                    BIMCommonReportUI.this.handleException(BIMCommonReportUI.this.tableGetDataException);
                    BIMCommonReportUI.this.tableGetDataException = null;
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    protected void checkQueryPK() {
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.mainQueryPK);
        if (queryInfo.getQueryPK() != null) {
            this.setHasQueryPK(true);
        } else {
            this.setHasQueryPK(false);
            this.tblMain.getDataRequestManager().setDataRequestMode(0);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IRow row = this.getSelectedRow();
        if (row == null) {
            return;
        }
        String srcName = ((KDWorkButton)e.getSource()).getName();
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, srcName.substring(4, srcName.length()));
        try {
            this.jump(row, srcName);
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.UIJumpError"), (String)err.getMessage());
            logger.error((Object)("\u754c\u9762\u8df3\u8f6c\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    private void jump(IRow row, String srcName) throws Exception {
        String linkUIName = srcName.substring(4, srcName.length());
        LinkUICollection linkUIs = this.rptInfo.getLinkUIs();
        int n = linkUIs.size();
        for (int i = 0; i < n; ++i) {
            LinkUIInfo uiInfo = linkUIs.get(i);
            if (!uiInfo.getName().equalsIgnoreCase(linkUIName)) continue;
            if (uiInfo.getLinkUIType().equalsIgnoreCase(LINK_REPORT_TYPE)) {
                FilterInfo filter = this.makeLinkReportParams(uiInfo, row);
                Map curUIContext = this.getUIContext();
                curUIContext.put("UIClassParam", uiInfo.getLinkReportPK());
                curUIContext.put(BIM_RPT_LINK_PARAMS, filter);
                IUIWindow linkUI = UIModelDialogFactory.newInstance().create(BIMCommonReportUI.class.getName(), curUIContext, null, OprtState.VIEW);
                linkUI.show();
                break;
            }
            if (!uiInfo.getLinkUIType().equalsIgnoreCase(LINK_EDITUI_TYPE)) continue;
            if (this.queryInfo == null || this.queryInfo.getQueryPK() == null) {
                MsgBox.showError((String)Messages.getString("BIMCommonReportUI.UIJumpError"), (String)Messages.getString("BIMCommonReportUI.QueryIsNull"));
                break;
            }
            String pkFieldName = this.queryInfo.getQueryPK().getKeyPropertys().get(0).getName().trim();
            String fieldKey = this.getTablePKFieldKey(pkFieldName);
            if (fieldKey == null) {
                logger.debug((Object)("Query PK FieldName: " + pkFieldName));
                MsgBox.showError((String)Messages.getString("BIMCommonReportUI.UIJumpError"), (String)Messages.getString("BIMCommonReportUI.CurrRptNoPK"));
                break;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.putAll(this.getUIContext());
            uiContext.put((Object)"ID", (Object)((String)row.getCell(fieldKey).getValue()));
            uiContext.put((Object)"IDList", (Object)new RealModeIDList());
            IUIWindow linkUI = UIModelDialogFactory.newInstance().create(uiInfo.getLinkEditUIPK(), (Map)uiContext, null, OprtState.VIEW);
            linkUI.show();
            break;
        }
    }

    private String getTablePKFieldKey(String pkFieldName) {
        String fieldKey = null;
        int m = this.tblMain.getColumnCount();
        for (int j = 0; j < m; ++j) {
            if (!this.tblMain.getColumn(j).getFieldName().equalsIgnoreCase(pkFieldName)) continue;
            fieldKey = this.tblMain.getColumnKey(j);
            break;
        }
        return fieldKey;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionPrint");
        try {
            this.preparePrintPage(this.tblMain);
            this.tblMain.getPrintManager().print();
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.PrintError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u6253\u5370\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionPrintPreview");
        try {
            this.preparePrintPage(this.tblMain);
            this.tblMain.getPrintManager().printPreview();
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.PrintPreviewError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u6253\u5370\u9884\u89c8\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.initCommonQueryDialog();
        if (dialog.show()) {
            this.mainQuery.getSorter().clear();
            this.mainQuery = this.isCUQuery ? this.getEntityViewInfo(dialog.getEntityViewInfoResult()) : dialog.getEntityViewInfoResult();
            this.isOrderBy = false;
            this.refreshList();
        } else {
            SysUtil.abort();
        }
    }

    public void actionFormPrint_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormPrint");
        if (this.defaultKDFTemplate == null) {
            MsgBox.showWarning((String)Messages.getString("BIMCommonReportUI.NoKDFTpl"));
            return;
        }
        try {
            BIMQueryDelegate query = new BIMQueryDelegate(this.mainQueryPK, this.mainQuery);
            BimReportHelper.printForm((String)this.getFormPath(), (BOSQueryDelegate)query, (Component)((Object)this));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.FormPrintError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u5957\u6253\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionFormPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormPrintPreview");
        if (this.defaultKDFTemplate == null) {
            MsgBox.showWarning((String)Messages.getString("BIMCommonReportUI.NoKDFTpl"));
            return;
        }
        try {
            BIMQueryDelegate query = new BIMQueryDelegate(this.mainQueryPK, this.mainQuery);
            BimReportHelper.browseForm((String)this.getFormPath(), (BOSQueryDelegate)query, (Component)((Object)this));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.FormPrintPreviewError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u5957\u6253\u9884\u89c8\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionFormSet_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormSet");
        this.createSelFormPrintEntityViewInfo();
        Map curUIContext = this.getUIContext();
        curUIContext.put("BIMCommonRptPath", this.dirRoot);
        curUIContext.put("BIMCommonRptPK", this.reportPK);
        curUIContext.put("BIMMainQuery", this.mainQuery);
        curUIContext.put("BIMSelEntityInfo", this.selPrintFilter);
        curUIContext.put("BIMMainQueryPK", this.mainQueryPK);
        curUIContext.put("BIMReportInfo", this.rptInfo);
        curUIContext.put("OrgType", this.orgType);
        IUIWindow uiFormList = UIModelDialogFactory.newInstance().create(BIMFormListUI.class.getName(), curUIContext, null, OprtState.VIEW);
        try {
            uiFormList.show();
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.FormSetError"), (String)err.getMessage());
            logger.error((Object)("\u5957\u6253\u8bbe\u7f6e\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionSelFormPrint_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormPrint");
        if (this.defaultKDFTemplate == null) {
            MsgBox.showWarning((String)Messages.getString("BIMCommonReportUI.NoKDFTpl"));
            return;
        }
        try {
            this.createSelFormPrintEntityViewInfo();
            BIMQueryDelegate query = new BIMQueryDelegate(this.mainQueryPK, this.selPrintFilter);
            BimReportHelper.printForm((String)this.getFormPath(), (BOSQueryDelegate)query, (Component)((Object)this));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.FormPrintError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u5957\u6253\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    public void actionSelFormPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        BIMCommonReportUtil.checkFuncPermission(this.orgType, this.reportPK, "actionFormPrintPreview");
        if (this.defaultKDFTemplate == null) {
            MsgBox.showWarning((String)Messages.getString("BIMCommonReportUI.NoKDFTpl"));
            return;
        }
        try {
            this.createSelFormPrintEntityViewInfo();
            BIMQueryDelegate query = new BIMQueryDelegate(this.mainQueryPK, this.selPrintFilter);
            BimReportHelper.browseForm((String)this.getFormPath(), (BOSQueryDelegate)query, (Component)((Object)this));
        }
        catch (Exception err) {
            err.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.FormPrintPreviewError"), (String)err.getMessage());
            logger.error((Object)("\u62a5\u8868\u5957\u6253\u9884\u89c8\u51fa\u9519: " + ExceptionUtil.getExcLinkStackTrace((Throwable)err)));
        }
    }

    private void createSelFormPrintEntityViewInfo() {
        String pkFieldName = this.queryInfo.getQueryPK().getKeyPropertys().get(0).getName().trim();
        String fieldKey = this.getTablePKFieldKey(pkFieldName);
        if (fieldKey == null) {
            logger.debug((Object)("Query PK FieldName: " + pkFieldName));
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.CurrRptNoPK"));
            return;
        }
        this.selPrintFilter = BIMCommonReportUtil.createSelRowFilter(this.tblMain, fieldKey, pkFieldName);
        if (this.isCUQuery) {
            try {
                this.selPrintFilter = this.getEntityViewInfo(this.selPrintFilter);
            }
            catch (BOSException ex) {
                this.handleException((Exception)((Object)ex));
            }
        }
    }

    private String getFormPath() {
        String kdfFullPath = this.dirRoot + "/" + BIMCommonReportUtil.getPKDir(this.reportPK);
        kdfFullPath = kdfFullPath + this.defaultKDFTemplate + ".kdf";
        return kdfFullPath;
    }

    protected IRow getSelectedRow() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            return row;
        }
        return null;
    }

    public void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = null;
        String dialogPK = this.rptInfo.getExtendedProperty(CUSTOM_FILTER_UI);
        if (dialogPK != null && dialogPK != "") {
            try {
                dialog = (CommonQueryDialog)Class.forName(dialogPK).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                MsgBox.showError((Component)((Object)this), (String)Messages.getString("BIMMDReportUI.InitCustomQueryDialogError"), (String)e.getMessage());
                SysUtil.abort();
            }
        } else {
            dialog = new CommonQueryDialog();
        }
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        dialog.setQueryObjectPK(this.mainQueryPK);
        dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter"));
        return dialog;
    }

    protected final EntityViewInfo getEntityViewInfo(EntityViewInfo QueryFilter) throws BOSException {
        FilterInfo filterCU = this.getDefaultFilterForQuery();
        if (filterCU != null && filterCU.size() > 0) {
            if (QueryFilter.getFilter() != null && QueryFilter.getFilter().size() > 0 && !QueryFilter.getFilter().toString().equals("")) {
                FilterItemCollection filters = QueryFilter.getFilter().getFilterItems();
                boolean hasCUFilter = false;
                for (int i = 0; i < filters.size(); ++i) {
                    if (!filters.get(i).getPropertyName().equals("CU.id")) continue;
                    hasCUFilter = true;
                    break;
                }
                if (!hasCUFilter) {
                    QueryFilter.getFilter().mergeFilter(filterCU, "AND");
                }
            } else {
                QueryFilter.setFilter(filterCU);
            }
        }
        return QueryFilter;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }

    public void refreshList() throws Exception {
        ActionEvent event = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        this.refresh(event);
    }

    protected void refresh(ActionEvent e) throws Exception {
        try {
            CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
            this.execQuery();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void execQuery() {
        this.setTheFirstFillData(true);
        this.queryUuid = null;
        this.saveCurrentLocation();
        this.tblMain.repaint();
        this.tblMain.removeRows();
        this.restoreCurrentLocation();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead()) {
            this.OrderByForTable(e);
        }
        if (e.getClickCount() == 2) {
            if (this.btnView == null) {
                return;
            }
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    private void OrderByForTable(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            if (this.isFristSortTable) {
                this.sm = new KDTSortManager(this.tblMain);
                this.oldSortItem = (SorterItemCollection)this.mainQuery.getSorter().clone();
                this.isFristSortTable = false;
            }
            this.sort = this.sort == 0 ? 1 : 0;
            this.sm.sort(e.getColIndex(), this.sort);
            if (this.sort == 0) {
                SorterItemInfo sortName = new SorterItemInfo(this.tblMain.getColumn(e.getColIndex()).getFieldName());
                sortName.setSortType(SortType.ASCEND);
                if (this.pre_order == null) {
                    this.pre_order = (SorterItemInfo)sortName.clone();
                    this.current_order = (SorterItemInfo)sortName.clone();
                } else if (this.current_order != null && !this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    ++this.order_count;
                    if (this.order_count > 0) {
                        this.pre_order = (SorterItemInfo)this.current_order.clone();
                        this.order_count = 0;
                        this.current_order = (SorterItemInfo)sortName.clone();
                    }
                }
                this.setSortForQuery(sortName, this.pre_order);
            } else {
                SorterItemInfo sortName = new SorterItemInfo(this.tblMain.getColumn(e.getColIndex()).getFieldName());
                sortName.setSortType(SortType.DESCEND);
                if (this.pre_order == null) {
                    this.pre_order = (SorterItemInfo)sortName.clone();
                    this.current_order = (SorterItemInfo)sortName.clone();
                } else if (this.current_order != null && !this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    ++this.order_count;
                    if (this.order_count > 0) {
                        this.pre_order = (SorterItemInfo)this.current_order.clone();
                        this.order_count = 0;
                        this.current_order = (SorterItemInfo)sortName.clone();
                    }
                }
                this.setSortForQuery(sortName, this.pre_order);
            }
        }
    }

    private void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        this.mainQuery.getSorter().clear();
        this.mainQuery.getSorter().addObjectCollection((IObjectCollection)this.oldSortItem);
        Iterator iter = this.mainQuery.getSorter().iterator();
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                SorterItemInfo sort = (SorterItemInfo)iter.next();
                if (!sort.getPropertyName().equals(sortItem.getPropertyName())) continue;
                sort.setSortType(sortItem.getSortType());
            }
        } else {
            if (this.getBizInterface() instanceof IBillBase) {
                this.mainQuery.getSorter().add(new SorterItemInfo("id"));
            }
            if (sortItem.getPropertyName() != "id") {
                this.mainQuery.getSorter().add(sortItem);
            }
            if (oldSortItem != null && !oldSortItem.getPropertyName().equals(sortItem.getPropertyName())) {
                this.mainQuery.getSorter().add(oldSortItem);
            }
        }
        this.refreshListForOrder();
    }

    public void refreshListForOrder() throws Exception {
        this.isOrderBy = true;
        ActionEvent event = new ActionEvent(this.btnRefresh, 1001, this.btnRefresh.getActionCommand());
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        this.setTheFirstFillData(true);
        this.queryUuid = null;
        this.tblMain.removeRows();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_doRequestRowSetForNoQueryPK(RequestRowSetEvent e) {
        if (this.mainQuery != null) {
            Date nowBegin = new Date();
            this.reportIvk = new BIMReportInvoker(this.reportPK, COMMON_REPORT_TYPE);
            try {
                this.reportIvk = BimReportHelper.executeQuery((QueryInfo)this.queryInfo, (EntityViewInfo)this.mainQuery, (IReportInvoker)this.reportIvk);
                this.setTheFirstFillData(false);
            }
            catch (ReportException e1) {
                e1.printStackTrace();
                MsgBox.showError((String)Messages.getString("BIMCommonReportUI.ExcuteRptError"), (String)e1.getMessage());
                logger.error((Object)("Execute report error : " + e1.getMessage()));
            }
            try {
                this.rs = BimReportHelper.requestKDTableRowSet((RequestRowSetEvent)e, (IReportInvoker)this.reportIvk);
                this.getRowSetBeforeFillTable(this.rs);
                e.setRowSet(this.rs);
                this.onGetRowSet(this.rs);
            }
            catch (Exception ee) {
                e.setRowSet(null);
                this.handUIException(ee);
            }
            Date nowEnd = new Date();
            float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
            logger.debug((Object)("the old doRequestRowSet used of times : " + waitSecond + " second."));
        }
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.isHasQueryPK()) {
            this.tblMain_doRequestRowSetForHasQueryPK(e);
        } else {
            this.tblMain_doRequestRowSetForNoQueryPK(e);
        }
    }

    protected void tblMain_doRequestRowSetForHasQueryPK(RequestRowSetEvent e) {
        if (this.tblMain.getRowCount() == -1 && (Integer)e.getParam1() == 0) {
            this.setTheFirstFillData(true);
            this.queryUuid = null;
        }
        if (this.isTheFirstFillData()) {
            this.getDataFirsetTime(e);
            return;
        }
        if (this.mainQuery != null) {
            try {
                Date nowBegin = new Date();
                this.rs = BimReportHelper.requestKDTableRowSet((RequestRowSetEvent)e, (IReportInvoker)this.reportIvk);
                this.getRowSetBeforeFillTable(this.rs);
                e.setRowSet(this.rs);
                this.onGetRowSet(this.rs);
                Date nowEnd = new Date();
                float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
                logger.debug((Object)("getData used of times : " + waitSecond + " second."));
            }
            catch (Exception ee) {
                e.setRowSet(null);
                this.setTableGetDataException(ee);
            }
        }
    }

    protected void getDataFirsetTime(RequestRowSetEvent e) {
        if (this.mainQuery == null) {
            return;
        }
        Date nowBegin = new Date();
        this.reportIvk = new BIMReportInvoker(this.reportPK, COMMON_REPORT_TYPE);
        try {
            this.reportIvk = BimReportHelper.executeQuery((QueryInfo)this.queryInfo, (EntityViewInfo)this.mainQuery, (IReportInvoker)this.reportIvk);
            this.setTheFirstFillData(false);
        }
        catch (ReportException e1) {
            e1.printStackTrace();
            MsgBox.showError((String)Messages.getString("BIMCommonReportUI.ExcuteRptError"), (String)e1.getMessage());
            logger.error((Object)("Execute report error : " + e1.getMessage()));
        }
        this.fillFirstData(e);
        if (this.tableGetDataException != null) {
            return;
        }
        Date nowEnd = new Date();
        float waitSecond = (float)(nowEnd.getTime() - nowBegin.getTime()) / 1000.0f;
        logger.debug((Object)("fillFirstData used of times : " + waitSecond + " second."));
        if (!this.isHasQueryPK() || !this.isLessData()) {
            // empty if block
        }
    }

    protected void fillFirstData(RequestRowSetEvent e) {
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        try {
            this.setButtonEnabled(false);
            this.rs = BimReportHelper.requestKDTableRowSet((RequestRowSetEvent)e, (IReportInvoker)this.reportIvk);
            if (this.rs.size() < length) {
                this.setLessData(true);
                this.setButtonEnabled(true);
            } else {
                this.setLessData(false);
            }
            this.getRowSetBeforeFillTable(this.rs);
            e.setRowSet(this.rs);
            this.onGetRowSet(this.rs);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.setButtonEnabled(true);
            e.setRowSet(null);
            this.onGetRowSet(null);
            this.setTableGetDataException(ee);
        }
    }

    protected void setButtonEnabled(boolean enabled) {
        this.btnRefresh.setEnabled(enabled);
    }

    protected final void setTableGetDataException(Exception e) {
        this.tableGetDataException = e;
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    public boolean isLessData() {
        return this.lessData;
    }

    protected final boolean isDefaultFilterInited() {
        return this.defaultFilterInited;
    }

    public boolean isTheFirstFillData() {
        return this.theFirstFillData;
    }

    public boolean isHasQueryPK() {
        return this.hasQueryPK;
    }

    protected final void setDefaultFilterInited(boolean value) {
        this.defaultFilterInited = value;
    }

    public void setTheFirstFillData(boolean theFirstFillData) {
        this.theFirstFillData = theFirstFillData;
    }

    public void setHasQueryPK(boolean hasQueryPK) {
        this.hasQueryPK = hasQueryPK;
    }

    public void setLessData(boolean lessData) {
        this.lessData = lessData;
    }

    public boolean isSelectForTable() {
        return this.selectForTable;
    }

    public void setSelectForTable(boolean selectForTable) {
        this.selectForTable = selectForTable;
    }

    private void saveCurrentLocation() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        this.curIndex = selectBlock != null ? selectBlock.getTop() : 0;
    }

    private void restoreCurrentLocation() {
        if (this.tblMain.getRow(this.curIndex) != null) {
            this.tblMain.getSelectManager().select(this.curIndex, 0);
        }
    }

    private void setKDTable(String kdtFileName) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(kdtFileName);
            this.tblMain.setFormatXml((InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.showError((String)(Messages.getString("BIMCommonReportUI.NotFindTplFile") + kdtFileName), (String)e.getMessage());
            SysUtil.abort();
        }
        this.tblMain.putBindContents("mainQuery", new String[0]);
        this.tblMain.checkParsed();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BIMCommonReportUI.this.rs.first();
                    BimReportHelper.fillKDTableGrouping((KDTable)BIMCommonReportUI.this.tblMain, (int)e.getFirstRow(), (ResultSet)BIMCommonReportUI.this.rs);
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void initToolbar() {
        LinkUICollection linkUIs = this.rptInfo.getLinkUIs();
        int n = linkUIs.size();
        for (int i = 0; i < n; ++i) {
            LinkUIInfo uiInfo = linkUIs.get(i);
            KDWorkButton btnLink = new KDWorkButton();
            btnLink.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionView), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
            btnLink.setName("BIM_" + uiInfo.getName());
            btnLink.setText(uiInfo.getAlias());
            btnLink.setToolTipText(uiInfo.getAlias());
            this.toolBar.add((Component)btnLink);
            this.setButtonDefaultStyl(btnLink);
            btnLink.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
            if (!uiInfo.isDefault()) continue;
            this.btnView = btnLink;
        }
    }

    private FilterInfo makeLinkReportParams(LinkUIInfo uiInfo, IRow row) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        ParameterMappingCollection pmc = uiInfo.getParameterMappings();
        int n = pmc.size();
        for (int i = 0; i < n; ++i) {
            ParameterMappingInfo pmi = pmc.get(i);
            ParameterInfo srcParam = pmi.getSrcParameter();
            ParameterInfo desParam = pmi.getDesParameter();
            CompareType compareType = pmi.getCompareType();
            ICell cell = row.getCell(srcParam.getAlias());
            if (cell == null) continue;
            FilterItemInfo fiInfo = new FilterItemInfo(desParam.getName(), cell.getValue(), compareType);
            fic.add(fiInfo);
        }
        return filter;
    }

    private EntityViewInfo createLinkUIFilter(FilterInfo filter) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        return evi;
    }

    private void checkQueryCU() {
        this.isCUQuery = BIMCommonReportUtil.checkQueryCU(this.queryInfo);
    }
}

