/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bim.rpt.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.report.reportframework.ReportException;
import com.kingdee.bos.ctrl.report.reportframework.invoke.AReportInvoker;
import com.kingdee.eas.bim.rpt.IBIMReportService;
import com.kingdee.eas.bim.rpt.client.util.BIMReportServiceFactory;
import java.util.HashMap;

public class BIMReportInvoker
extends AReportInvoker {
    private String reportPK;
    private String rptType;
    private String rptId;

    public BIMReportInvoker(String reportPK, String rptType) {
        this.reportPK = reportPK;
        this.rptType = rptType;
    }

    public void execute(HashMap params) throws ReportException {
        try {
            IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
            this.rptId = service.execute(this.reportPK, this.rptType, params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public Object invoke(String methodName, Class[] argTypes, Object[] args) throws ReportException {
        try {
            IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
            if (this.rptId == null) {
                throw new NullPointerException("Report excute failed!");
            }
            return service.invoke(this.rptId, methodName, argTypes, args);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() throws ReportException {
        try {
            IBIMReportService service = BIMReportServiceFactory.getRemoteInstance();
            service.close(this.rptId);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

