/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.eas.common.app.dao.EntryHeadInfo;
import com.kingdee.util.db.SQLUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EntityCompositionBuilder {
    private final IMetaDataLoader loader;
    private PrintStream out;
    private Connection conn = null;
    private static Logger logger = Logger.getLogger(EntityCompositionBuilder.class);
    private static ArrayList headDetailArr = new ArrayList();

    private EntityCompositionBuilder() {
        this.loader = null;
    }

    public EntityCompositionBuilder(String metadataFilePath, String outFilePath) throws FileNotFoundException, UnsupportedEncodingException {
        MetaDataLoaderFactory.setClientMetaDataPath((String)metadataFilePath);
        this.loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        this.out = new PrintStream((OutputStream)new FileOutputStream(outFilePath, true), false, "UTF-8");
    }

    public EntityCompositionBuilder(String metadataFilePath, Connection conn) {
        MetaDataLoaderFactory.setClientMetaDataPath((String)metadataFilePath);
        this.loader = MetaDataLoaderFactory.getMetaDataLoader(null);
        this.out = null;
        this.conn = conn;
    }

    public void doIt() {
        headDetailArr.clear();
        EntityObjectCollection entityColl = this.loader.getEntityCollection();
        int size = entityColl.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo eoInfo = entityColl.get(i);
            EntityCompositionBuilder.buildEntity(eoInfo);
        }
        this.output();
    }

    private void testOutut() {
        try {
            this.out = new PrintStream((OutputStream)new FileOutputStream("c:/entryhead.sql", true), false, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.output();
    }

    private void output() {
        this.outputClearSql(this.out);
        int size = headDetailArr.size();
        for (int i = 0; i < size; ++i) {
            EntryHeadInfo info = (EntryHeadInfo)headDetailArr.get(i);
            this.output(this.out, info);
        }
        this.out.close();
    }

    private void outputClearSql(PrintStream out) {
        out.println(EntityCompositionBuilder.getClearSql() + ";");
    }

    private void output(PrintStream out, EntryHeadInfo info) {
        String sql = EntityCompositionBuilder.getInsertSql(info);
        out.println(sql + ";");
    }

    private static String getClearSql() {
        return "delete from T_SYS_ENTRYHEAD";
    }

    private static String getInsertSql(EntryHeadInfo info) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_SYS_ENTRYHEAD ( FENTRYTABLENAME,FHEADTABLENAME,FRELATIONFIELDNAME) ").append(" values ('").append(info.getEntryTableName()).append("',").append(" '").append(info.getHeadTableName()).append("',").append(" '").append(info.getRelationFieldName()).append("')");
        return sql.toString();
    }

    public static void build(Context ctx) {
        headDetailArr.clear();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectCollection entityColl = loader.getEntityCollection();
        int size = entityColl.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo eoInfo = entityColl.get(i);
            EntityCompositionBuilder.buildEntity(eoInfo);
        }
        EntityCompositionBuilder.insert2DB(ctx);
        EntityCompositionBuilder builder = new EntityCompositionBuilder();
        builder.testOutut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insert2DB(Context ctx) {
        Connection conn = null;
        Statement stat = null;
        try {
            conn = EntityCompositionBuilder.getConnection(ctx);
            stat = conn.createStatement();
            stat.addBatch(EntityCompositionBuilder.getClearSql());
            int size = headDetailArr.size();
            for (int i = 0; i < size; ++i) {
                EntryHeadInfo info = (EntryHeadInfo)headDetailArr.get(i);
                StringBuffer sql = new StringBuffer();
                sql.append("insert into T_SYS_ENTRYHEAD ( FENTRYTABLENAME,FHEADTABLENAME,FRELATIONFIELDNAME) ").append(" values ('").append(info.getEntryTableName()).append("',").append(" '").append(info.getHeadTableName()).append("',").append(" '").append(info.getRelationFieldName()).append("')");
                stat.addBatch(sql.toString());
            }
            stat.executeBatch();
        }
        catch (SQLException e1) {
            try {
                e1.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stat, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stat, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)stat, (Connection)conn);
    }

    private static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static void buildEntity(EntityObjectInfo ent) {
        PropertyCollection propCol = ent.getInheritedNoDuplicatedProperties();
        int m = propCol.size();
        for (int j = 0; j < m; ++j) {
            PropertyInfo propInfo;
            RelationshipInfo rel;
            PropertyInfo prop = propCol.get(j);
            if (!(prop instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(rel = ((LinkPropertyInfo)prop).getRelationship()).getType())) continue;
            EntityObjectInfo head = null;
            EntityObjectInfo detail = null;
            if (CardinalityType.isOneORZero((CardinalityType)rel.getClientCardinality()) && !CardinalityType.isOneORZero((CardinalityType)rel.getSupplierCardinality())) {
                head = rel.getClientObject();
                detail = rel.getSupplierObject();
            } else if (!CardinalityType.isOneORZero((CardinalityType)rel.getClientCardinality()) && CardinalityType.isOneORZero((CardinalityType)rel.getSupplierCardinality())) {
                head = rel.getSupplierObject();
                detail = rel.getClientObject();
            } else if (CardinalityType.isOneORZero((CardinalityType)rel.getClientCardinality()) && CardinalityType.isOneORZero((CardinalityType)rel.getSupplierCardinality())) {
                head = rel.getClientObject();
                detail = rel.getSupplierObject();
            } else assert (false);
            assert (head != null);
            assert (detail != null);
            if (head == null || detail == null || !detail.getType().equals((Object)ent.getType()) || head.isAbstract()) continue;
            DataTableInfo headTable = head.getTable();
            String headTableName = null;
            if (headTable != null) {
                headTableName = headTable.getName();
                if (headTable.getColumnByName("FControlUnitID") == null) continue;
            }
            DataTableInfo detailTable = detail.getTable();
            String detailTableName = null;
            if (detailTable != null) {
                detailTableName = detailTable.getName();
                if (detailTable.getColumnByName("FControlUnitID") != null) continue;
            }
            if ((propInfo = rel.getSupplierProperty()) == null || propInfo.getMappingField() == null) {
                logger.error((Object)(rel.getName() + "'s supplierProperty is null or mappingField is null"));
                continue;
            }
            String relationFieldName = propInfo.getMappingField().getName();
            EntityCompositionBuilder.addtoColl(headTableName, detailTableName, relationFieldName);
        }
    }

    private static void addtoColl(String headTable, String entryTable, String relationFieldName) {
        EntryHeadInfo info = new EntryHeadInfo();
        info.setEntryTableName(entryTable);
        info.setHeadTableName(headTable);
        info.setRelationFieldName(relationFieldName);
        headDetailArr.add(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildReference() {
        headDetailArr.clear();
        EntityObjectCollection entityColl = this.loader.getEntityCollection();
        int size = entityColl.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo eoInfo = entityColl.get(i);
            EntityCompositionBuilder.buildEntity(eoInfo);
        }
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            stat.addBatch("delete from T_SYS_ENTRYHEAD;");
            String sql = null;
            int size2 = headDetailArr.size();
            for (int i = 0; i < size2; ++i) {
                EntryHeadInfo info = (EntryHeadInfo)headDetailArr.get(i);
                sql = EntityCompositionBuilder.getInsertSql(info) + ";";
                stat.addBatch(sql);
                if (i % 2000 != 0) continue;
                stat.executeBatch();
            }
            stat.executeBatch();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            System.out.println("BizReferenceException: 3");
            boolean bl = false;
            return bl;
        }
        finally {
            SQLUtils.cleanup((Statement)stat);
        }
    }
}

