/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.client;

import com.kingdee.bos.apploader.message.MessageHandler;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ComponentUtil {
    private static Logger logger = Logger.getLogger(ComponentUtil.class);
    private static ArrayList<JFrame> defaultFameList = new ArrayList();
    private static DaemonDefaultFrameThread defaultFrameDaemon = null;

    public static Component getRootComponent(Component component) {
        if (component instanceof Frame || component instanceof Dialog) {
            return component;
        }
        Window child = null;
        if (component instanceof IUIObject) {
            Component c = component;
            child = SwingUtilities.getWindowAncestor(c);
        } else if (component instanceof IUIWindow) {
            child = SwingUtilities.getWindowAncestor((Component)((IUIWindow)component).getUIObject());
        }
        return child;
    }

    public static Window getOwnerWindow(Component component) {
        if (component == null) {
            return ComponentUtil.getActiveWindow();
        }
        Component topComp = ComponentUtil.getRootComponent(component);
        if (topComp instanceof JDialog && topComp.getName().equals("TOOLBAR_LAB_POPUP")) {
            return ComponentUtil.getActiveWindow();
        }
        if (topComp instanceof Window) {
            return (Window)topComp;
        }
        return ComponentUtil.getActiveWindow();
    }

    private static Window getActiveWindow() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        while (w instanceof JDialog && w.getName().equals("TOOLBAR_LAB_POPUP")) {
            w = w.getOwner();
        }
        if (w != null && w.isVisible()) {
            return w;
        }
        if (SystemEntry.instance.isWebStart()) {
            return ComponentUtil.getOwnerFrame();
        }
        return w;
    }

    public static void setWindowsCursorOfWair() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            window.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void setWindowCursorOfDefault() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void setWindowCursor(Cursor cursor) {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window != null) {
            window.setCursor(cursor);
        }
    }

    public static void setWindowsCursorOfWair(Window window) {
        if (window != null) {
            window.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void setWindowCursorOfDefault(Window window) {
        if (window != null) {
            window.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void setWindowCursor(Window window, Cursor cursor) {
        if (window != null) {
            window.setCursor(cursor);
        }
    }

    public static Window getCurrentActiveWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
    }

    protected static Frame getOwnerFrame() {
        JFrame portalFrame = new JFrame();
        portalFrame.setName("apploader");
        portalFrame.setIconImage(EASResource.getImage("imgEas_16"));
        portalFrame.setTitle(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "25_ComponentUtil"));
        portalFrame.setSize(300, 150);
        portalFrame.setResizable(false);
        portalFrame.setLocationRelativeTo(null);
        portalFrame.setLayout(new BorderLayout());
        KDLabel label = new KDLabel(EASResource.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "25_ComponentUtil"), 0);
        portalFrame.add((Component)label, "Center");
        defaultFameList.add(portalFrame);
        portalFrame.setAlwaysOnTop(true);
        if (defaultFrameDaemon == null) {
            defaultFrameDaemon = new DaemonDefaultFrameThread();
            defaultFrameDaemon.setName("DefaultFrameDaemon\u2014\u2014ComponentUtil");
            defaultFrameDaemon.setDaemon(true);
            defaultFrameDaemon.start();
        }
        return portalFrame;
    }

    static class DaemonDefaultFrameThread
    extends Thread {
        private HashMap<JFrame, Long> map = new HashMap();
        private HashMap<JFrame, Long> jFrameMapAlwaysOnTopTime = new HashMap();
        private long timeout = 300000L;
        private long idlesseTime = -1L;

        DaemonDefaultFrameThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ArrayList arrayList = defaultFameList;
                        synchronized (arrayList) {
                            if (defaultFameList != null && defaultFameList.size() > 0) {
                                for (int i = defaultFameList.size() - 1; i >= 0; --i) {
                                    JFrame fm = (JFrame)defaultFameList.get(i);
                                    if (fm == null) continue;
                                    Window[] ownedWin = fm.getOwnedWindows();
                                    if (ownedWin != null && ownedWin.length > 0) {
                                        Window window = ownedWin[0];
                                        if (Dialog.class.isInstance(window)) {
                                            fm.setTitle(((Dialog)window).getTitle());
                                        } else if (Frame.class.isInstance(window)) {
                                            fm.setTitle(((Frame)window).getTitle());
                                        }
                                        boolean visible = window.isVisible();
                                        if (!visible) {
                                            for (int j = 1; j < ownedWin.length; ++j) {
                                                if (ownedWin[j] == null || !ownedWin[j].isVisible()) continue;
                                                visible = true;
                                                break;
                                            }
                                        }
                                        if (fm.isVisible() != visible) {
                                            fm.setVisible(visible);
                                            if (visible) {
                                                try {
                                                    MessageHandler.sendCloseDivMsg();
                                                }
                                                catch (Throwable j) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (visible) {
                                            Long time = this.jFrameMapAlwaysOnTopTime.get(fm);
                                            if (time != null) {
                                                if (System.currentTimeMillis() - time <= 10000L) continue;
                                                for (Window win : ownedWin) {
                                                    win.setAlwaysOnTop(false);
                                                }
                                                fm.setAlwaysOnTop(false);
                                                continue;
                                            }
                                            window.setVisible(true);
                                            this.jFrameMapAlwaysOnTopTime.put(fm, System.currentTimeMillis());
                                            continue;
                                        }
                                        Long startTime = this.map.get(fm);
                                        if (startTime != null) {
                                            if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                                            defaultFameList.remove(fm);
                                            fm = null;
                                            this.idlesseTime = 0L;
                                            continue;
                                        }
                                        this.map.put(fm, System.currentTimeMillis());
                                        continue;
                                    }
                                    fm.setVisible(false);
                                    Long startTime = this.map.get(fm);
                                    if (startTime != null) {
                                        if (System.currentTimeMillis() - startTime <= this.timeout) continue;
                                        defaultFameList.remove(fm);
                                        fm = null;
                                        this.idlesseTime = 0L;
                                        continue;
                                    }
                                    this.map.put(fm, System.currentTimeMillis());
                                }
                            }
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

