/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.eas.client.recorder.Utils;
import com.kingdee.util.LoggerItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.List;

public class SQLDetailDialog
extends TypicalDialog {
    KDTable table = new KDTable();
    KDPanel sqlPanel = new KDPanel();
    KDTextPane textPane = new KDTextPane();
    String[] header = new String[]{"\u5e8f\u53f7", "\u65b9\u6cd5", "\u5f00\u59cb\u65f6\u95f4", "\u8017\u65f6(\u6beb\u79d2)", "sql"};
    private List itemList;

    public SQLDetailDialog(Frame frame) {
        super(frame);
    }

    public SQLDetailDialog(Dialog dialog) {
        super(dialog);
    }

    protected void todoInit() {
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        int i;
        this.setTitle("SQL\u4fe1\u606f");
        this.setBounds(new Rectangle(800, 680));
        KDPanel content = new KDPanel();
        content.setLayout((LayoutManager)new BorderLayout());
        KDSplitPane splitPane = new KDSplitPane();
        content.add((Component)splitPane, (Object)"Center");
        KDScrollPane scrollPane = new KDScrollPane((Component)this.textPane);
        splitPane.setOrientation(0);
        splitPane.add((Component)this.table, (Object)"top");
        splitPane.add((Component)scrollPane, (Object)"bottom");
        splitPane.setDividerLocation(300);
        parent.add((Component)content, thisCell);
        IRow headRow = this.table.addHeadRow();
        for (i = 0; i < this.header.length; ++i) {
            this.table.addColumn().setKey("F" + i);
        }
        for (i = 0; i < this.header.length; ++i) {
            headRow.getCell(i).setValue((Object)this.header[i]);
        }
        this.table.getColumn(4).setWidth(300);
        Utils.makeCenter((Window)((Object)this));
        this.table.getSelectManager().setSelectMode(2);
        this.table.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                SQLDetailDialog.this.selectRow();
            }
        });
    }

    protected void selectRow() {
        KDTSelectBlock block = this.table.getSelectManager().get();
        int rowIndex = -1;
        if (block != null) {
            rowIndex = block.getTop();
        }
        if (rowIndex > -1) {
            this.selectRow(rowIndex);
        }
    }

    private void selectRow(int rowIndex) {
        IRow trow = this.table.getRow(rowIndex);
        LoggerItem.ExecuteItem item = (LoggerItem.ExecuteItem)trow.getUserObject();
        if (item != null) {
            this.textPane.setText(item.ksql);
        }
    }

    public void setItemList(List<LoggerItem> itemList) {
        if (!this.isAddControls) {
            this.addControls();
            this.isAddControls = true;
        }
        if (itemList != this.itemList) {
            this.table.removeRows();
            this.itemList = itemList;
            int index = 0;
            for (LoggerItem item : itemList) {
                this.addRow(item, index++);
            }
            this.table.getSelectManager().select(0, 0);
        }
    }

    private void addRow(LoggerItem item, int itemIndex) {
        IRow row = this.table.addRow();
        int index = 0;
        row.getCell(index++).setValue((Object)(itemIndex + 1));
        row.getCell(index++).setValue((Object)item.method);
        row.getCell(index++).setValue((Object)com.kingdee.bos.rpcrecorder.Utils.formatSimpleTime((long)item.startTime));
        row.getCell(index++).setValue((Object)("" + (item.endTime - item.startTime)));
        if (item instanceof LoggerItem.ExecuteItem) {
            row.getCell(index++).setValue((Object)((LoggerItem.ExecuteItem)item).ksql);
        } else if (item instanceof LoggerItem.AddBatchItem) {
            row.getCell(index++).setValue((Object)((LoggerItem.AddBatchItem)item).ksql);
        } else {
            row.getCell(index++).setValue((Object)"");
        }
        row.setUserObject((Object)item);
    }
}

