/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework;

import com.kingdee.eas.framework.IFrameWorkService;
import com.kingdee.eas.framework.configuration.client.ClientConfiguationManager;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public abstract class AbstraceFrameWorkService
implements IFrameWorkService {
    private Logger logger = Logger.getLogger(AbstraceFrameWorkService.class);
    private boolean is_enabled = true;
    public static final String EAS_HOME = "EAS_HOME";

    public AbstraceFrameWorkService() {
        this.initService();
    }

    protected void initService() {
        String property_key = "easframework." + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1).toLowerCase() + ".enabled";
        if (ClientConfiguationManager.getConfiguation("bos").containsKey(property_key)) {
            this.is_enabled = ClientConfiguationManager.getConfiguation("bos").getBoolean(property_key);
        }
    }

    @Override
    public boolean isEnable() {
        return this.is_enabled;
    }

    @Override
    public Object doService(String method_name, Object[] params) {
        if (params == null || params.length == 0) {
            return this.tryInvokeMethod(method_name, null);
        }
        return this.tryInvokeMethod(method_name, params);
    }

    protected Object tryInvokeMethod(String method_name) {
        return this.tryInvokeMethod(method_name, null);
    }

    protected Object tryInvokeMethod(String method_name, Object[] params) {
        Class<?> ownerClass = this.getClass();
        Class[] argsClass = new Class[]{};
        if (params != null) {
            argsClass = new Class[params.length];
            int j = params.length;
            for (int i = 0; i < j; ++i) {
                argsClass[i] = params[i].getClass();
            }
        }
        try {
            Method method = ownerClass.getMethod(method_name, argsClass);
            return method.invoke((Object)this, params);
        }
        catch (NoSuchMethodException e) {
            this.handException("no suchMethod[" + method_name + "] at " + this.getClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            this.handException("IllegalArgument [" + method_name + "] at " + this.getClass().getName(), e);
        }
        catch (Exception e) {
            this.handException("fail invoke method[" + method_name + "] at " + this.getClass().getName(), e);
        }
        return null;
    }

    protected void handException(String error, Exception ex) {
        this.logger.error((Object)error);
    }
}

