/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.cache;

import com.kingdee.bos.cache.CacheException;
import com.kingdee.bos.cache.CacheLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.framework.cache.CacheStat;
import com.kingdee.eas.framework.cache.LoadArguments;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CollectionLoader
implements CacheLoader {
    private static final String PREFIX = "get";
    private static final String SUFFIX = "Collection";
    private static final String REMOTEMETHOD = "getRemoteInstance";
    private static final String REMOTEFACTORY = "Factory";
    private static final int PARAMETER_NUMBER = 1;
    private static CollectionLoader loader;

    private CollectionLoader() {
    }

    public static synchronized CollectionLoader getInstance() {
        if (loader != null) {
            return loader;
        }
        loader = new CollectionLoader();
        return loader;
    }

    public synchronized Object load(Object args) {
        LoadArguments loadArgs = (LoadArguments)args;
        IMetaDataPK metaPK = loadArgs.getMetaPK();
        String nameOfFactory = this.getFactoryClassName(metaPK);
        Object result = null;
        try {
            Class[] parameterTypes = null;
            Object[] parameters = null;
            Class<?> objectOfFactory = Class.forName(nameOfFactory);
            Method methodOfFactory = objectOfFactory.getMethod(REMOTEMETHOD, parameterTypes);
            Object objSource = methodOfFactory.invoke(objectOfFactory, parameterTypes);
            Object argsOfMethod = loadArgs.getDataPK().getArgs();
            if (argsOfMethod != null) {
                parameterTypes = new Class[1];
                parameters = new Object[1];
                parameterTypes[0] = argsOfMethod.getClass();
                parameters[0] = argsOfMethod;
            }
            Method method = objSource.getClass().getMethod(PREFIX + metaPK.getName(), parameterTypes);
            result = method.invoke(objSource, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new CacheException((Throwable)nsme);
        }
        catch (IllegalAccessException ilae) {
            throw new CacheException((Throwable)ilae);
        }
        catch (InvocationTargetException ite) {
            throw new CacheException((Throwable)ite);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CacheException((Throwable)cnfe);
        }
        CacheStat.getInstance().doStat(loadArgs.getMetaPK().toString(), loadArgs.getDataPK().getPK(), true);
        return result;
    }

    private String getFactoryClassName(IMetaDataPK metaPK) {
        String name = metaPK.getName();
        String packageName = metaPK.getPackage();
        if (name.endsWith(SUFFIX)) {
            name = name.substring(0, name.lastIndexOf(SUFFIX));
        }
        return packageName + "." + name + REMOTEFACTORY;
    }
}

