/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.eas.framework.client.ITableLocate;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.service.TableLocationServer;
import com.kingdee.eas.framework.util.ConfigParams;

class ListTableLocate
implements ITableLocate {
    private TableLocationServer locate_server = new TableLocationServer();
    private TableLocationServer.LocateParam locate_param;

    @Override
    public boolean locate() {
        if (this.locate_param != null) {
            int row_index = this.locate_server.locateFirstRow(this.locate_param);
            this.scrollToRow(row_index);
            return row_index > 0;
        }
        return false;
    }

    protected void scrollToRow(int row_index) {
        KDTable tblMain = this.locate_server.getTblMain();
        if (tblMain.getRow(row_index) != null) {
            tblMain.getSelectManager().select(row_index, 0);
            tblMain.getLayoutManager().scrollRowToShow(row_index);
        } else {
            tblMain.getSelectManager().removeAll();
        }
    }

    protected void setLocateParam(TableLocationServer.LocateParam locate_param) {
        this.locate_param = locate_param;
    }

    @Override
    public void setLocateParams(String col_name, String search_text, ListUI list_ui) {
        this.locate_server.setTblMain(list_ui.getMainTable());
        ConfigParams option = new ConfigParams();
        int max_row = list_ui.getRowCount();
        if (max_row > list_ui.getMaxReturnRowCount()) {
            max_row = list_ui.getMaxReturnRowCount();
        }
        option.addIntParam("row_count", max_row);
        option.addIntParam("current_select_index", this.getCurrentSelectRowIndex(list_ui));
        this.setLocateParam(new TableLocationServer.LocateParam(search_text, col_name, option));
    }

    public int getCurrentSelectRowIndex(ListUI list_ui) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)list_ui.getMainTable());
        int selectIndex = -1;
        if (selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        return selectIndex;
    }

    @Override
    public void stopLocate() {
        this.locate_server.setStop(true);
    }
}

