/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.eas.framework.client.IMultiOrgBizInfo;
import com.kingdee.eas.framework.client.uicontroller.IRowDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class MultiOrgBizInfo
implements IMultiOrgBizInfo {
    private IRowDataProvider provider;
    private boolean is_fill_data = false;
    private ArrayList org_list;
    private HashMap org_map_id;
    private HashMap org_map_entry;
    private boolean is_fillAll_data = false;
    private ArrayList idList;

    public MultiOrgBizInfo(IRowDataProvider provider) {
        this.provider = provider;
    }

    private void fillData() {
        if (!this.is_fill_data) {
            this.org_map_id = new HashMap();
            this.org_map_entry = new HashMap();
            this.org_list = new ArrayList();
            int org_index = this.provider.indexOf(this.provider.getOrgName());
            int id_index = this.provider.indexOf(this.provider.getPkName());
            int entry_index = -1;
            if (this.provider.getEntryName() != null) {
                entry_index = this.provider.indexOf(this.provider.getEntryName());
            }
            for (int i = 0; i < this.provider.getRowCount(); ++i) {
                IRowDataProvider.IRowData row_data = this.provider.getRowData(i);
                this.appendRowData(row_data, id_index, org_index, entry_index);
            }
        }
        this.is_fill_data = true;
    }

    private void appendRowData(IRowDataProvider.IRowData row_data, int id_index, int org_index, int entry_index) {
        Object org_value = row_data.getColumnData(org_index);
        if (!this.org_list.contains(org_value)) {
            this.org_list.add(org_value);
        }
        Object id_value = row_data.getColumnData(id_index);
        Object entry_value = null;
        if (entry_index != -1) {
            entry_value = row_data.getColumnData(entry_index);
        }
        if (org_value != null) {
            this.appToMap(this.org_map_id, org_value, id_value);
            if (entry_value != null) {
                this.appToMap(this.org_map_entry, org_value, entry_value);
            }
        }
    }

    private void appToMap(HashMap target, Object org_value, Object value) {
        ArrayList<Object> id_list = (ArrayList<Object>)target.get(org_value);
        if (id_list == null) {
            id_list = new ArrayList<Object>();
        }
        if (!id_list.contains(value)) {
            id_list.add(value);
        }
        target.put(org_value, id_list);
    }

    @Override
    public List getEntryIDList(String orgID) {
        this.fillData();
        return (List)this.org_map_entry.get(orgID);
    }

    @Override
    public List getIDList(String orgID) {
        this.fillData();
        return (List)this.org_map_id.get(orgID);
    }

    @Override
    public List getOrgIDList() {
        this.fillData();
        return this.org_list;
    }

    @Override
    public List getAllSelectedId() {
        if (!this.is_fillAll_data) {
            this.idList = new ArrayList();
            int id_index = this.provider.indexOf(this.provider.getPkName());
            for (int i = 0; i < this.provider.getRowCount(); ++i) {
                IRowDataProvider.IRowData row_data = this.provider.getRowData(i);
                Object billHeadId = row_data.getColumnData(id_index);
                if (this.idList.contains(billHeadId)) continue;
                this.idList.add(billHeadId);
            }
            this.is_fillAll_data = true;
            return this.idList;
        }
        return this.idList;
    }
}

