/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bizrule.RuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.UILifeCycleHander;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.expression.BizRuleSetExecutor;
import com.kingdee.eas.framework.expression.IBizConfigureInfo;
import com.kingdee.eas.framework.expression.UILayoutExecutor;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class OldUILifeCycleHander
extends UILifeCycleHander {
    private static final Logger logger = CoreUIObject.getLogger(OldUILifeCycleHander.class);
    String oldMainOrgID = null;
    Map backupStatusMap = null;
    IBizConfigureInfo backupConfigure = null;
    BizRuleSetExecutor ruleSetExecutor = null;
    UILayoutExecutor layoutExecutor = null;
    CoreUI ui = null;
    Map localCtx = null;
    IObjectCollection uicfgCol = null;

    public static UILifeCycleHander getRuleHanderInstance() {
        return new OldUILifeCycleHander();
    }

    public void executeUIConfigure(CoreUI ui, String id) throws Exception {
        logger.info((Object)("configure id in context is :" + id));
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        this.ui = ui;
        if (this.uicfgCol == null) {
            this.uicfgCol = DynamicObjectFactory.getCachedRemoteInstance().getCollection(BOSObjectType.create((String)"74FB65D8"), "WHERE ID = '" + id + "'");
        }
        if (this.uicfgCol != null && this.uicfgCol.size() > 0) {
            int n = this.uicfgCol.size();
            for (int i = 0; i < n; ++i) {
                if (!(this.uicfgCol.getObject(i) instanceof IBizConfigureInfo)) continue;
                IBizConfigureInfo configure = (IBizConfigureInfo)this.uicfgCol.getObject(i);
                this.executeUIConfigure(ui, configure);
                break;
            }
        } else {
            logger.error((Object)("can't find configureInfo : " + id));
        }
    }

    public void executeUIConfigure(CoreUI ui, IMetaDataPK pk) throws Exception {
        if (ui == null || pk == null) {
            return;
        }
        this.ui = ui;
        OrgType orgType = ui.getMainBizOrgType();
        if (orgType == null) {
            this.executeUIConfigure(ui, pk, orgType, "");
        } else {
            OrgUnitInfo orgUnit = (OrgUnitInfo)ui.getUIContext().get(ui.getMainType());
            KDBizPromptBox orgF7 = this.getMainOrgFromOrgContextManager(ui);
            if (orgF7 != null) {
                logger.info((Object)"[UILifeCycleHander]found main org from org context manager...");
                orgF7.addDataChangeListener((DataChangeListener)new OrgUnitDataChangeListener(this, ui, pk));
            } else if (ui.getMainBizOrg() != null) {
                logger.info((Object)"[UILifeCycleHander]found main biz org from ui.getMainBizOrg()...");
                ui.getMainBizOrg().addDataChangeListener((DataChangeListener)new OrgUnitDataChangeListener(this, ui, pk));
            }
            if (orgUnit != null) {
                String orgid = "";
                if (orgUnit.getId() != null) {
                    orgid = orgUnit.getId().toString();
                }
                this.executeUIConfigure(ui, pk, orgType, orgid);
            }
        }
    }

    public void executeUIConfigure(CoreUI ui, IMetaDataPK pk, OrgType orgType, String mainOrgID) throws Exception {
        if (ui == null || pk == null) {
            return;
        }
        if (orgType == null) {
            IBizConfigureInfo configure = this.getBizConfigure(pk, orgType, mainOrgID);
            this.executeUIConfigure(ui, configure);
        } else {
            if (this.oldMainOrgID == null && this.backupStatusMap == null) {
                this.backupStatusMap = this.backupUIStatus(this.getLocalCtx(ui));
            }
            if (!StringUtils.isEmpty((String)mainOrgID) && !mainOrgID.equals(this.oldMainOrgID)) {
                IBizConfigureInfo configure = this.getBizConfigure(pk, orgType, mainOrgID);
                if (configure != null) {
                    this.oldMainOrgID = mainOrgID;
                    this.destroyUIConfigure(ui);
                    this.executeUIConfigure(ui, configure);
                    this.backupConfigure = configure;
                    if (this.ui != null && this.ui instanceof EditUI && this.ui.getDataObject() != null && this.ui.getDataObject("billInfo") == null) {
                        this.ui.loadFields();
                    }
                } else if (!StringUtils.isEmpty((String)this.oldMainOrgID)) {
                    this.oldMainOrgID = null;
                    this.destroyUIConfigure(ui);
                    this.backupConfigure = null;
                }
            } else if (!StringUtils.isEmpty((String)mainOrgID) && mainOrgID.equals(this.oldMainOrgID)) {
                RuleSetInfo ruleSet = this.getBizRuleSet(this.backupConfigure);
                if (ruleSet != null) {
                    this.ruleSetExecutor = new BizRuleSetExecutor(ui, ContextManager.getContext(), this.getLocalCtx(ui), ruleSet);
                    this.ruleSetExecutor.execute();
                }
                if (this.ui != null && this.ui instanceof EditUI && this.ui.getDataObject() != null && this.ui.getDataObject("billInfo") == null) {
                    this.ui.loadFields();
                }
            } else if (StringUtils.isEmpty((String)mainOrgID) && !StringUtils.isEmpty((String)this.oldMainOrgID)) {
                this.oldMainOrgID = null;
                this.destroyUIConfigure(ui);
                this.backupConfigure = null;
            }
            this.fireAfterLoadField(this, ui.getDataObject());
        }
    }

    public void executeUIConfigure(CoreUI ui, IBizConfigureInfo configure) throws Exception {
        RuleSetInfo ruleSet;
        if (ui == null || configure == null) {
            return;
        }
        UIObjectInfo uiObject = this.getConfigUIModel(configure);
        if (ui instanceof EditUI) {
            // empty if block
        }
        if (uiObject != null && ui.getDataBinder() != null) {
            this.layoutExecutor = new UILayoutExecutor(ui, ContextManager.getContext(), this.getLocalCtx(ui), uiObject, ui.getDataBinder(), configure, this);
            this.layoutExecutor.execute();
        }
        if ((ruleSet = this.getBizRuleSet(configure)) != null) {
            this.ruleSetExecutor = new BizRuleSetExecutor(ui, ContextManager.getContext(), this.getLocalCtx(ui), ruleSet);
            this.ruleSetExecutor.execute();
        }
    }

    public void destroyUIConfigure(CoreUI ui) {
        this.linkRuleListener.clear();
        if (this.ruleSetExecutor != null || this.layoutExecutor != null) {
            Map localCtx = this.getLocalCtx(ui);
            this.restoreUIStatus(localCtx, this.backupStatusMap);
            this.removeConfigure(localCtx, this.backupConfigure);
            if (this.layoutExecutor != null) {
                this.layoutExecutor.destroy();
            }
            if (this.ruleSetExecutor != null) {
                this.ruleSetExecutor.destroy();
            }
        }
        ui.revalidate();
    }

    private void addComponentsToMap(Component[] components, Map map) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            String cName = components[i].getName();
            if (StringUtils.isEmpty((String)cName)) {
                cName = String.valueOf((double)System.currentTimeMillis() + new SecureRandom().nextDouble());
            }
            if (map.get(cName) == null) {
                map.put(cName, components[i]);
            }
            if (!(components[i] instanceof Container) || ((Container)components[i]).getComponents().length <= 0) continue;
            this.addComponentsToMap(((Container)components[i]).getComponents(), map);
        }
    }

    private Map getLocalCtx(CoreUI coreUI) {
        if (this.localCtx == null) {
            this.localCtx = new HashMap();
            this.localCtx.put("owner", coreUI);
            this.localCtx.put("CoreUI", coreUI);
            this.addComponentsToMap(coreUI.getComponents(), this.localCtx);
        }
        return this.localCtx;
    }

    private IBizConfigureInfo getBizConfigure(IMetaDataPK pk, OrgType orgType, String mainOrgID) {
        if (mainOrgID == null) {
            mainOrgID = "";
        }
        try {
            if (pk != null) {
                String currentUserId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                String currentUserOrgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                currentUserId = StringUtils.isEmpty((String)currentUserId) ? "" : currentUserId;
                currentUserOrgId = StringUtils.isEmpty((String)currentUserOrgId) ? "" : currentUserOrgId;
                Object obj = DynamicObjectFactory.getCachedRemoteInstance().invoke(BOSObjectType.create((String)"6F3DB90B"), "getEditUIBizConfig", new Object[]{currentUserId, currentUserOrgId, mainOrgID, pk.getFullName()});
                if (obj instanceof IBizConfigureInfo) {
                    return (IBizConfigureInfo)obj;
                }
                logger.error((Object)("can't find configureinfo for ui :" + pk.getFullName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private RuleSetInfo getBizRuleSet(IBizConfigureInfo configure) {
        if (configure == null) {
            return null;
        }
        try {
            String ruleSetXml = configure.getBizRuleSet();
            return (RuleSetInfo)new RuleSetCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(ruleSetXml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private UIObjectInfo getConfigUIModel(IBizConfigureInfo configure) {
        if (configure == null) {
            return null;
        }
        try {
            String uiObjectXml = configure.getUIObject();
            UIObjectInfo uiObj = (UIObjectInfo)new UIObjectCtrl(ContextManager.getContext()).load((InputStream)new ByteArrayInputStream(uiObjectXml.getBytes("UTF-8")));
            uiObj.setAssembled(false);
            uiObj = UIObjectAssembler.assembleUI((Context)ContextManager.getContext(), (UIObjectInfo)uiObj);
            return uiObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map backupUIStatus(Map localCtx) {
        HashMap status = new HashMap();
        if (localCtx != null) {
            for (Object key : localCtx.keySet()) {
                Object value = localCtx.get(key);
                if (!(value instanceof JComponent)) continue;
                JComponent component = (JComponent)value;
                HashMap<String, Object> entry = new HashMap<String, Object>();
                entry.put("visible", new Boolean(component.isVisible()));
                entry.put("enabled", new Boolean(component.isEnabled()));
                if (component instanceof KDLabelContainer) {
                    entry.put("boundLabelText", ((KDLabelContainer)component).getBoundLabelText());
                }
                if (component.getClientProperty("KDLayoutConstraints") != null) {
                    KDLayout.Constraints old = (KDLayout.Constraints)component.getClientProperty("KDLayoutConstraints");
                    KDLayout.Constraints constraint = new KDLayout.Constraints(old.originalBounds.x, old.originalBounds.y, old.originalBounds.width, old.originalBounds.height, old.anchor);
                    entry.put("_constraint", constraint);
                }
                if (component.getBounds() != null) {
                    Rectangle rec = new Rectangle();
                    rec.setBounds(component.getBounds());
                    entry.put("_bounds", rec);
                }
                if (value instanceof KDTable) {
                    HashMap editors;
                    if (((KDTable)value).getFormatXml() != null) {
                        entry.put("_formatxml", ((KDTable)value).getFormatXml());
                    }
                    if ((editors = OldUILifeCycleHander.getTableEditorAndRenderToMap((KDTable)value)) != null) {
                        entry.put("_editors", editors);
                    }
                }
                status.put(component, entry);
            }
        }
        return status;
    }

    private static HashMap getTableEditorAndRenderToMap(KDTable table) {
        if (table == null || table.getColumns() == null || table.getColumns().size() == 0) {
            return null;
        }
        HashMap tableEditorRenderMap = new HashMap();
        KDTColumns columns = table.getColumns();
        KDTColumn column = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = columns.getColumn(i);
            HashMap<String, Object> maps = new HashMap<String, Object>();
            if (column.getEditor() != null) {
                maps.put("TableEditor", column.getEditor());
            }
            if (column.getRenderer() != null) {
                maps.put("TableRender", column.getRenderer());
            }
            tableEditorRenderMap.put(column.getKey(), maps);
        }
        return tableEditorRenderMap;
    }

    private static void setTableEditorAndRenderToMap(KDTable table, HashMap tableEditorRenderMap) {
        if (table == null || table.getColumns() == null || table.getColumns().size() == 0 || tableEditorRenderMap == null) {
            return;
        }
        KDTColumns columns = table.getColumns();
        KDTColumn column = null;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            column = columns.getColumn(i);
            if (tableEditorRenderMap.get(column.getKey()) == null) continue;
            HashMap maps = (HashMap)tableEditorRenderMap.get(column.getKey());
            if (maps.get("TableEditor") != null) {
                column.setEditor((ICellEditor)maps.get("TableEditor"));
            }
            if (maps.get("TableRender") == null) continue;
            column.setRenderer((IBasicRender)maps.get("TableRender"));
        }
    }

    public void restoreUIStatus(Map localCtx, Map status) {
        if (status != null) {
            for (Object key : status.keySet()) {
                Object obj;
                Object value;
                Map entry = (Map)status.get(key);
                if (!(key instanceof JComponent)) continue;
                JComponent component = (JComponent)key;
                if (component instanceof KDTable) {
                    value = entry.get("_formatxml");
                    if (value != null) {
                        ((KDTable)component).setFormatXml(value.toString());
                        ((KDTable)component).checkParsed(true);
                    }
                    if ((value = entry.get("_editors")) != null && value instanceof HashMap) {
                        OldUILifeCycleHander.setTableEditorAndRenderToMap((KDTable)component, (HashMap)value);
                    }
                }
                if ((value = entry.get("enabled")) != null && value instanceof Boolean) {
                    KDLabelContainer container;
                    JComponent inner;
                    component.setEnabled((Boolean)value);
                    if (component instanceof KDLabelContainer && (inner = (container = (KDLabelContainer)component).getBoundEditor()) != null) {
                        Object iValue;
                        Map iEntry = (Map)status.get(inner);
                        if (iEntry == null) {
                            inner = (JComponent)localCtx.get(inner.getName());
                            iEntry = (Map)status.get(inner);
                        }
                        if (iEntry != null && (iValue = iEntry.get("enabled")) != null && iValue instanceof Boolean) {
                            inner.setEnabled((Boolean)iValue);
                        }
                    }
                }
                if ((value = entry.get("visible")) != null && value instanceof Boolean) {
                    component.setVisible((Boolean)value);
                }
                if (component instanceof KDLabelContainer && (value = entry.get("boundLabelText")) != null && value instanceof String) {
                    ((KDLabelContainer)component).setBoundLabelText((String)value);
                }
                if ((obj = entry.get("_constraint")) != null && obj instanceof KDLayout.Constraints) {
                    KDLayout.Constraints old = (KDLayout.Constraints)obj;
                    KDLayout.Constraints constraint = new KDLayout.Constraints(old.originalBounds.x, old.originalBounds.y, old.originalBounds.width, old.originalBounds.height, old.anchor);
                    component.putClientProperty("KDLayoutConstraints", constraint);
                }
                if ((obj = entry.get("_bounds")) == null || !(obj instanceof Rectangle)) continue;
                Rectangle rec = new Rectangle();
                rec.setBounds((Rectangle)obj);
                component.setBounds(rec);
            }
        }
    }

    private void removeConfigure(Map localCtx, IBizConfigureInfo configure) {
        UIObjectInfo uiObject = this.getConfigUIModel(configure);
        if (localCtx != null && uiObject != null) {
            try {
                this.layoutExecutor.remove(uiObject, localCtx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private KDBizPromptBox getMainOrgFromOrgContextManager(CoreUI ui) {
        IMultiOrgSupport mos;
        if (ui != null && ui.orgContextManager != null && (mos = ui.orgContextManager.getOwner()) != null) {
            return mos.getMainOrg();
        }
        return null;
    }

    class OrgUnitDataChangeListener
    implements DataChangeListener {
        OldUILifeCycleHander hander;
        private CoreUI ui;
        private IMetaDataPK pk;

        public OrgUnitDataChangeListener(OldUILifeCycleHander hander, CoreUI ui, IMetaDataPK pk) {
            this.hander = hander;
            this.ui = ui;
            this.pk = pk;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            try {
                if (eventObj != null) {
                    if (eventObj.getNewValue() != null && eventObj.getNewValue() instanceof OrgUnitInfo) {
                        OrgUnitInfo orgUnit = (OrgUnitInfo)eventObj.getNewValue();
                        if (orgUnit.getId() != null) {
                            DataComponentMap dcMap;
                            ArrayList headerFields;
                            DataBinder binder = this.ui.getDataBinder();
                            if (binder != null && binder.getDataComponentMap() != null && (headerFields = (dcMap = binder.getDataComponentMap()).getHeaderFields()) != null && headerFields.size() > 0) {
                                int length = headerFields.size();
                                Field field = null;
                                ComponentProperty compProp = null;
                                KDBizPromptBox bizOrg = OldUILifeCycleHander.this.getMainOrgFromOrgContextManager(this.ui);
                                if (bizOrg == null) {
                                    bizOrg = this.ui.getMainBizOrg();
                                }
                                for (int i = 0; i < length; ++i) {
                                    field = (Field)headerFields.get(i);
                                    compProp = dcMap.getComponentProperty(field);
                                    if (compProp.getComponent() != bizOrg) continue;
                                    BindingUtility.storeData((IObjectValue)binder.getValueObject(), (Field)field, (ComponentProperty)compProp);
                                    break;
                                }
                            }
                            OldUILifeCycleHander.this.executeUIConfigure(this.ui, this.pk, this.ui.getMainBizOrgType(), orgUnit.getId().toString());
                        } else {
                            this.hander.executeUIConfigure(this.ui, this.pk, this.ui.getMainBizOrgType(), "");
                        }
                    } else {
                        this.hander.executeUIConfigure(this.ui, this.pk, this.ui.getMainBizOrgType(), "");
                    }
                }
            }
            catch (Exception e) {
                logger.info((Object)"UILifeCycleHander.dataChanged()");
                logger.info((Object)e);
            }
        }
    }
}

