/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.framework.client.ProductInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.Base64Encoder;
import com.kingdee.util.DateTimeUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;

public class ProductService {
    private static Logger logger = Logger.getLogger(ProductService.class);
    public static final String IP_link = "http://service.kingdee.com/csso/customer/getClientIP.action";
    public static final String SERVICE_LOGIN_URL = "http://service.kingdee.com/csso/customer/productLogin.action";
    public static final String SERVICE_SITE = "http://service.kingdee.com/";
    public static final String SERVICE_ANSWER = "http://service.kingdee.com/knowledge/index.html";
    public static final String SERVICE_REMOTE_ASSIST = "http://csrc.kingdee.com/Web1800/";
    public static final String SERVICE_KNOWSTORE = "http://service.kingdee.com/knowledge/index.html";
    public static final String SERVICE_HELP = "http://csrc.kingdee.com";
    public static final String SERVICE_APPLY_SITE = "http://mall.kingdee.com/goods/view.action?id=447041";
    public static ProductInfo productInfo;

    public static ProductInfo getProductInfo() throws Exception {
        if (productInfo == null) {
            productInfo = new ProductInfo();
            boolean isEnableWeb20 = false;
            String className = "com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil";
            try {
                Class<?> c = Class.forName(className);
                Method staticMethod = c.getDeclaredMethod("isEnableWeb20", new Class[0]);
                Object obj = staticMethod.invoke(c, new Object[0]);
                if (obj instanceof Boolean) {
                    isEnableWeb20 = (Boolean)obj;
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (isEnableWeb20) {
                ProductService.getProductService();
            }
        }
        return productInfo;
    }

    private static void getProductService() throws Exception {
        String ip = null;
        try {
            ip = ProductService.getClientIPFromURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
        LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
        ProductService.productInfo.isRegister = baseInfo.isRegistedVersion();
        ProductService.productInfo.serviceDate = baseInfo.getServiceDate();
        ProductService.productInfo.serialNum = baseInfo.getSerialNum();
        ProductService.productInfo.licenseTo = baseInfo.getLicenseTo();
        String no = agent.getProductNo();
        logger.info((Object)(ProductService.productInfo.isRegister + "," + ProductService.productInfo.serviceDate + "," + no));
        if (no != null) {
            no = Base64Encoder.byteArrayToBase64((byte[])no.getBytes());
        }
        logger.info((Object)("base64 ProductNo=" + no));
        ProductService.productInfo.productNo = no;
        if (ProductService.productInfo.isRegister) {
            String hash;
            Date curDate;
            ProductService.productInfo.serverDate = curDate = SysUtil.getAppServerTime(null);
            String dt = DateTimeUtils.format((Date)curDate, (String)"yyyy-MM-dd");
            String tempHash = no + dt + ip;
            logger.info((Object)("hash for not MD5 =" + tempHash));
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(tempHash.getBytes());
            ProductService.productInfo.hash = hash = ProductService.bytesToHexString(md.digest());
        }
    }

    private static String bytesToHexString(byte[] bt) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bt.length; ++i) {
            String s = Integer.toHexString(bt[i] & 0xFF);
            if (s.length() == 1) {
                buffer.append("0");
            }
            buffer.append(s);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getClientIPFromURL() throws Exception {
        HttpURLConnection connection = null;
        InputStream stream = null;
        ByteArrayInputStream inputStream = null;
        String ip = null;
        try {
            URL url = new URL(IP_link);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(3000);
            connection.setRequestMethod("GET");
            stream = connection.getInputStream();
            int available = stream.available();
            byte[] bt = new byte[available];
            stream.read(bt);
            String str = new String(bt);
            inputStream = new ByteArrayInputStream(str.trim().getBytes());
            connection.disconnect();
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)inputStream);
            ElementFilter filter = new ElementFilter("IP");
            List contents = doc.getContent((Filter)filter);
            if (contents != null && contents.size() > 0) {
                ip = ((Element)contents.get(0)).getText();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (stream != null) {
                stream.close();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return ip;
    }
}

