/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import java.util.HashMap;
import java.util.Map;

public class UITypeHelper {
    private static final Map uiTypes = new HashMap();
    private static String oldDSessionId = null;
    private static final Map objTypes = new HashMap();

    public static final BOSObjectType getType(ListUI listUI) throws Exception {
        UITypeHelper.checkSession();
        String className = listUI.getMetaDataPK().toString();
        if (uiTypes.containsKey(className)) {
            return (BOSObjectType)uiTypes.get(className);
        }
        ICoreBase bosObject = listUI.getBizInterface();
        if (bosObject == null) {
            return null;
        }
        boolean isCustom = listUI.getUIContext().containsKey("UIClassParam");
        BOSObjectType type = UITypeHelper.getType((IBOSObject)bosObject, isCustom);
        uiTypes.put(className, type);
        return type;
    }

    private static void checkSession() {
        String sessionId = SysContext.getSysContext().getSessionID();
        if (oldDSessionId == null) {
            oldDSessionId = sessionId;
        } else if (!sessionId.equals(oldDSessionId)) {
            oldDSessionId = sessionId;
            uiTypes.clear();
            objTypes.clear();
        }
    }

    public static final BOSObjectType getType(EditUI editUI) throws Exception {
        UITypeHelper.checkSession();
        String className = editUI.getMetaDataPK().toString();
        if (uiTypes.containsKey(className)) {
            return (BOSObjectType)uiTypes.get(className);
        }
        ICoreBase bosObject = editUI.getBizInterface();
        if (bosObject == null) {
            return null;
        }
        boolean isCustom = editUI.getUIContext().containsKey("UIClassParam");
        BOSObjectType type = UITypeHelper.getType((IBOSObject)bosObject, isCustom);
        uiTypes.put(className, type);
        return type;
    }

    private static final BOSObjectType getType(IBOSObject bosObj, boolean isCustom) {
        if (isCustom) {
            return bosObj.getType();
        }
        String className = bosObj.getClass().getName();
        if (objTypes.containsKey(className)) {
            return (BOSObjectType)objTypes.get(className);
        }
        BOSObjectType type = bosObj.getType();
        objTypes.put(className, type);
        return type;
    }
}

