/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.attachMent;

import com.kingdee.bos.ctrl.swing.KDArrowButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.framework.client.attachMent.AttachMentHelper;
import com.kingdee.eas.framework.client.attachMent.IAttachMentListPanel;
import com.kingdee.eas.framework.client.attachMent.KDLinkedLabel;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIManager;

public class AttachMentListPanel
extends KDPanel
implements IAttachMentListPanel {
    private String id = null;
    private int topCount = 5;
    private int rowSize = 0;
    private KDDialog popupDialog = null;
    private WindowListener dialogWindowHandler = null;
    private boolean isPopupVisible = false;
    private final KDArrowButton button = new KDArrowButton(5);
    private static final int MAX_FILENAME_LENGTH = 14;
    private static final Color backgroundColor = new Color(198, 221, 238);
    private static final Icon icon = EASResource.getIcon((String)"imgBill_icon_4");

    public AttachMentListPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(backgroundColor);
    }

    @Override
    public void setPopupDialog(KDDialog dialog) {
        if (dialog == null && this.popupDialog != null) {
            this.popupDialog.dispose();
        }
        this.popupDialog = dialog;
    }

    public KDDialog getPopupDialog() {
        return this.popupDialog;
    }

    @Override
    public void setBillId(String id) {
        this.id = id;
    }

    public void setTopCount(int topCount) {
        this.topCount = topCount;
    }

    @Override
    public void fillAttachment() throws Exception {
        this.removeAll();
        if (this.id == null) {
            this.revalidate();
            this.repaint();
            return;
        }
        this.setTopCount(5);
        final KDPanel attachPanel = this.fillAttachment(this.topCount, false);
        if (this.rowSize >= 1) {
            this.add((Component)attachPanel, "Center");
            if (this.rowSize != 1) {
                this.add((Component)this.button, "East");
                this.button.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        try {
                            if (!AttachMentListPanel.this.isPopupVisible) {
                                AttachMentListPanel.this.showOrHideDialog(attachPanel, true);
                                AttachMentListPanel.this.button.setDirection(1);
                            } else {
                                AttachMentListPanel.this.button.setDirection(5);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        this.revalidate();
        this.repaint();
    }

    public KDPanel fillAttachment(int topCount, boolean isPaintBorder) throws Exception {
        KDPanel panel = new KDPanel();
        panel.setBackground(backgroundColor);
        this.setTopCount(topCount);
        IRowSet rowSet = AttachMentHelper.getAttachment(this.id, this.topCount);
        int size = rowSet.size();
        if (size == 0) {
            return null;
        }
        int row = 1;
        int ov = size % 4;
        if (size > 4) {
            row = size / 4;
            if (ov > 0) {
                ++row;
            }
        }
        this.rowSize = row;
        GridLayout layOut = null;
        if (this.topCount > 5) {
            panel.setPreferredSize(new Dimension(0, 12 * row));
            layOut = new GridLayout(row, 4);
        } else {
            panel.setPreferredSize(new Dimension(0, 12));
            layOut = new GridLayout(1, 4);
        }
        panel.setLayout((LayoutManager)layOut);
        row = 0;
        while (rowSet.next()) {
            String id = rowSet.getString("id");
            String name = rowSet.getString("name");
            String suffixName = rowSet.getString("simpleName");
            String fullName = this.getFullName(name, suffixName);
            String attachMentName = this.constructAttachMentName(fullName);
            KDLinkedLabel label = new KDLinkedLabel(attachMentName);
            label.setHorizontalAlignment(2);
            label.setUserObject(id);
            label.setIcon(icon);
            label.setToolTipText(fullName);
            this.add(panel, label);
            if (++row != 4 || this.topCount != 5) continue;
            break;
        }
        if (ov > 0 && row != 4) {
            for (int i = 0; i < 4 - ov; ++i) {
                KDLabel label = new KDLabel();
                panel.add((Component)label);
            }
        }
        if (isPaintBorder) {
            panel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("ComboBox.popupBorderLineColor")));
        }
        return panel;
    }

    private String constructAttachMentName(String name) {
        StringBuffer nameBuffer = new StringBuffer(name);
        if (nameBuffer.length() > 14) {
            nameBuffer.delete(14, nameBuffer.length());
            nameBuffer.append("...");
        }
        return nameBuffer.toString();
    }

    private String getFullName(String name, String suffixName) {
        StringBuffer buffer = new StringBuffer();
        if (name != null) {
            buffer.append(name);
        }
        if (suffixName != null) {
            buffer.append(".");
            buffer.append(suffixName);
        }
        return buffer.toString();
    }

    private void add(final KDPanel panel, final KDLinkedLabel label) {
        panel.add((Component)((Object)label));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AttachMentHelper.doClick(e, (Component)panel);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setText(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setText(false);
            }
        });
    }

    private void showOrHideDialog(KDPanel owner, boolean isVisible) throws Exception {
        if (this.getPopupDialog() == null && owner != null) {
            this.createDialog(owner);
        }
        if (this.getPopupDialog() != null) {
            boolean b = this.getPopupDialog().isVisible();
            if (b && !isVisible) {
                this.setPopupDialog(null);
            } else if (!b && isVisible) {
                this.getPopupDialog().setVisible(true);
            }
        }
    }

    private void createDialog(KDPanel owner) throws Exception {
        KDPanel panel = this.fillAttachment(Integer.MAX_VALUE, true);
        panel.setPreferredSize(new Dimension(owner.getWidth(), this.rowSize * 20));
        panel.setBackground(backgroundColor);
        Point point = owner.getLocationOnScreen();
        KDDialog dialog = new KDDialog();
        dialog.setUndecorated(true);
        dialog.setBackground(backgroundColor);
        this.setPopupDialog(dialog);
        if (this.dialogWindowHandler != null) {
            this.getPopupDialog().removeWindowListener(this.dialogWindowHandler);
            this.dialogWindowHandler = null;
        }
        if (this.dialogWindowHandler == null) {
            this.dialogWindowHandler = new DialogWindowHandler();
            this.getPopupDialog().addWindowListener(this.dialogWindowHandler);
        }
        this.getPopupDialog().getContentPane().add((Component)panel);
        this.getPopupDialog().setBounds(point.x, point.y, owner.getWidth(), this.rowSize * 20);
    }

    private class DialogWindowHandler
    extends WindowAdapter {
        private DialogWindowHandler() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            AttachMentListPanel.this.isPopupVisible = false;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            AttachMentListPanel.this.isPopupVisible = true;
            try {
                AttachMentListPanel.this.showOrHideDialog(null, false);
                AttachMentListPanel.this.button.setDirection(5);
                AttachMentListPanel.this.button.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

