/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.cloud.screen.draw;

import com.kingdee.eas.framework.client.cloud.screen.draw.Eraser;
import com.kingdee.eas.framework.client.cloud.screen.draw.IShape;
import com.kingdee.eas.framework.client.cloud.screen.draw.Line;
import com.kingdee.eas.framework.client.cloud.screen.draw.Oval;
import com.kingdee.eas.framework.client.cloud.screen.draw.PolyGon;
import com.kingdee.eas.framework.client.cloud.screen.draw.PolyLine;
import com.kingdee.eas.framework.client.cloud.screen.draw.Rect;
import com.kingdee.eas.framework.client.cloud.screen.draw.WordShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class DrawingBoard
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int TOOL_LINE = 0;
    public static final int TOOL_RECT = 1;
    public static final int TOOL_OVAL = 2;
    public static final int TOOL_DIAMOND = 3;
    public static final int TOOL_PENCIL = 4;
    public static final int TOOL_ERASER = 5;
    public static final int TOOL_POLYGON = 6;
    public static final int TOOL_WORD = 7;
    public static final Stroke[] STROKES = new Stroke[]{new BasicStroke(1.0f), new BasicStroke(2.0f), new BasicStroke(5.0f), new BasicStroke(7.5f), new BasicStroke(10.0f)};
    public static final Stroke[] ERASER_STROKES = new Stroke[]{new BasicStroke(15.0f), new BasicStroke(20.0f), new BasicStroke(30.0f), new BasicStroke(50.0f), new BasicStroke(100.0f)};
    private ArrayList shapes = new ArrayList();
    private IShape currentShape = null;
    private int tool = 1;
    private int strokeIndex = 0;
    private int eraserIndex = 0;
    private boolean isDrawed = false;
    Image img;
    int x;
    int y;
    int w;
    int h;

    public DrawingBoard() {
        this.setCursor(new Cursor(1));
        this.setOpaque(true);
        this.setForeground(Color.red);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setImage(Image img) {
        this.img = img;
        this.x = this.getX();
        this.y = this.getY();
        this.w = this.getWidth();
        this.h = this.getHeight();
    }

    public void setTool(int t) {
        if (t < 0 || t > 7) {
            throw new IllegalArgumentException("Invaild Tool Specified!");
        }
        this.tool = t;
    }

    public void setStrokeIndex(int i) {
        if (i < 0 || i > 4) {
            throw new IllegalArgumentException("Invaild Weight Specified!");
        }
        this.strokeIndex = i;
    }

    public void setEraserIndex(int i) {
        if (i < 0 || i > 4) {
            throw new IllegalArgumentException("Invaild Size Specified!");
        }
        this.eraserIndex = i;
    }

    public void clearBoard() {
        this.shapes.clear();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int size = this.shapes.size();
        Graphics2D g2d = (Graphics2D)g;
        this.setSize(this.w, this.h);
        this.setLocation(this.x, this.y);
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this);
        }
        for (int i = 0; i < size; ++i) {
            ((IShape)this.shapes.get(i)).draw(g2d);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            switch (this.tool) {
                case 0: {
                    this.currentShape = new Line(this.getForeground(), STROKES[this.strokeIndex], e.getX(), e.getY());
                    break;
                }
                case 1: {
                    this.currentShape = new Rect(this.getForeground(), STROKES[this.strokeIndex], e.getX(), e.getY());
                    break;
                }
                case 2: {
                    this.currentShape = new Oval(this.getForeground(), STROKES[this.strokeIndex], e.getX(), e.getY());
                    break;
                }
                case 4: {
                    this.currentShape = new PolyLine(this.getForeground(), STROKES[this.strokeIndex], e.getX(), e.getY());
                    break;
                }
                case 5: {
                    this.currentShape = new Eraser(this, ERASER_STROKES[this.eraserIndex], e.getX(), e.getY());
                    break;
                }
                case 6: {
                    this.currentShape = new PolyGon(this.getForeground(), STROKES[this.strokeIndex], e.getX(), e.getY());
                    break;
                }
                case 7: {
                    this.currentShape = new WordShape(this, this.getForeground(), e.getX(), e.getY());
                }
            }
            this.shapes.add(this.currentShape);
            this.isDrawed = true;
            this.repaint();
        } else if (e.getButton() == 3 && this.currentShape != null) {
            this.currentShape.processCursorEvent(e, 0);
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentShape != null) {
            this.currentShape.processCursorEvent(e, 2);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.currentShape != null) {
            this.currentShape.processCursorEvent(e, 1);
            this.currentShape = null;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean isDrawed() {
        return this.isDrawed;
    }
}

