/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.commonquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldCollection;
import com.kingdee.eas.base.commonquery.DynQuerySelectFieldInfo;
import com.kingdee.eas.base.commonquery.DynQuerySolutionFactory;
import com.kingdee.eas.base.commonquery.DynQuerySolutionInfo;
import com.kingdee.eas.base.commonquery.IDynQuerySolution;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.util.LocaleUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class DynamicQueryUtil {
    private static Logger logger = Logger.getLogger(DynamicQueryUtil.class);
    public static final String IS_DYNQUERY_FIELD = "isDynQueryField";
    public static final String IS_NEED_QUERY_FIELD = "isNeedQueryField";
    public static final String IS_VISIBLE_IN_TABLE = "isVisibleInTable";

    public static DynQuerySelectFieldCollection getDynQuerySelectFields(DynQuerySolutionInfo dynQuerySolution) throws BOSException {
        DynQuerySelectFieldCollection collection = null;
        IDynQuerySolution dynQuerySolutionFactory = DynQuerySolutionFactory.getRemoteInstance();
        if (dynQuerySolutionFactory != null && dynQuerySolution != null) {
            collection = QueryUtils.getQueryFieldsInDB((BOSUuid)dynQuerySolution.getId(), (IDynQuerySolution)dynQuerySolutionFactory);
        }
        return collection;
    }

    public static SelectorItemCollection getDynSelectors(DynQuerySelectFieldCollection selectFieldcollection) {
        SelectorItemCollection itemCollection = null;
        if (selectFieldcollection != null && selectFieldcollection.size() != 0) {
            itemCollection = new SelectorItemCollection();
            for (DynQuerySelectFieldInfo field : selectFieldcollection) {
                SelectorItemInfo selectorInfo = new SelectorItemInfo();
                selectorInfo.setPropertyName(field.getNumber());
                selectorInfo.setDisplayName(field.getName(LocaleUtils.locale_l1), LocaleUtils.locale_en_US);
                selectorInfo.setDisplayName(field.getName(LocaleUtils.locale_l2), LocaleUtils.locale_zh_CN);
                selectorInfo.setDisplayName(field.getName(LocaleUtils.locale_l3), LocaleUtils.locale_zh_TW);
                selectorInfo.setAliasName(field.getAlias());
                selectorInfo.getExtendedProperties().put("isCommonQueryFilter", new Boolean(field.isIsFilter()).toString());
                selectorInfo.getExtendedProperties().put("isCommonQuerySorter", new Boolean(field.isIsOrderBy()).toString());
                selectorInfo.getExtendedProperties().put(IS_DYNQUERY_FIELD, field.isIsDynField() ? "true" : "false");
                selectorInfo.getExtendedProperties().put(IS_NEED_QUERY_FIELD, field.isIsInSelect() ? "true" : "false");
                selectorInfo.getExtendedProperties().put(IS_VISIBLE_IN_TABLE, field.isIsVisibleInTable() ? "true" : "false");
                itemCollection.add(selectorInfo);
            }
        }
        return itemCollection;
    }

    public static SelectorItemCollection getDynSelectors(DynQuerySolutionInfo dynQuerySolution) throws BOSException {
        return DynamicQueryUtil.getDynSelectors(DynamicQueryUtil.getDynQuerySelectFields(dynQuerySolution));
    }

    public static SelectorItemCollection getNotNeedQuerySelectors(DynQuerySolutionInfo dynQuerySolution) throws BOSException {
        return DynamicQueryUtil.getNotNeedQuerySelectors(DynamicQueryUtil.getDynSelectors(dynQuerySolution));
    }

    public static SelectorItemCollection getNotNeedQuerySelectors(SelectorItemCollection dynSelectors) {
        SelectorItemCollection notNeedQuerySelectors = null;
        if (dynSelectors != null && dynSelectors.size() != 0) {
            notNeedQuerySelectors = new SelectorItemCollection();
            for (SelectorItemInfo info : dynSelectors) {
                String isNeedQueryField = info.getExtendedProperty(IS_NEED_QUERY_FIELD);
                if (!"false".equals(isNeedQueryField)) continue;
                notNeedQuerySelectors.add(info);
            }
        }
        return notNeedQuerySelectors;
    }

    public static SelectorItemCollection getDynQuerySelectors(DynQuerySolutionInfo dynQuerySolution) throws BOSException {
        return DynamicQueryUtil.getDynQuerySelectors(DynamicQueryUtil.getDynSelectors(dynQuerySolution));
    }

    public static SelectorItemCollection getDynQuerySelectors(SelectorItemCollection dynSelectors) {
        SelectorItemCollection dynQuerySelectors = null;
        if (dynSelectors != null && dynSelectors.size() != 0) {
            dynQuerySelectors = new SelectorItemCollection();
            for (SelectorItemInfo info : dynSelectors) {
                String dynQueryField = info.getExtendedProperty(IS_DYNQUERY_FIELD);
                String IsVisibleInTableField = info.getExtendedProperty(IS_VISIBLE_IN_TABLE);
                if (!"true".equals(dynQueryField) || !"true".equals(IsVisibleInTableField)) continue;
                dynQuerySelectors.add(info);
            }
        }
        return dynQuerySelectors;
    }

    public static SelectorItemCollection getVisibleAndNotBindedSelectors(List alreadyBindedFieldNames, SelectorItemCollection dynSelectors) {
        SelectorItemCollection visibleAndNotBindedSelectors = null;
        if (dynSelectors != null && dynSelectors.size() != 0) {
            visibleAndNotBindedSelectors = new SelectorItemCollection();
            for (SelectorItemInfo info : dynSelectors) {
                String dynQueryField = info.getExtendedProperty(IS_DYNQUERY_FIELD);
                String IsVisibleInTableField = info.getExtendedProperty(IS_VISIBLE_IN_TABLE);
                if (alreadyBindedFieldNames != null && (alreadyBindedFieldNames.contains(info.getPropertyName()) || !"true".equals(IsVisibleInTableField) || !"false".equals(dynQueryField))) continue;
                visibleAndNotBindedSelectors.add(info);
            }
        }
        return visibleAndNotBindedSelectors;
    }
}

