/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.context.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.client.context.f7.AbstractF7Adaptor;
import com.kingdee.eas.framework.client.context.f7.AbstractF7AdaptorBuilder;
import com.kingdee.eas.framework.client.context.f7.CommonF7AdaptorBuilder;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.framework.client.context.f7.RegisterF7Param;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultF7ContextManager
implements IF7ContextChange,
IF7Register {
    private Component owner = null;
    private ContextTypeEnum contextType = null;
    private int masterDF7ViewType;
    private List F7AdaptorList = new ArrayList();

    public DefaultF7ContextManager(Component owner, OrgType mainOrgType, ContextTypeEnum contextType, int masterDF7ViewType) {
        this.owner = owner;
        this.contextType = contextType;
        this.masterDF7ViewType = masterDF7ViewType;
        try {
            this.init();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void init() throws EASBizException, BOSException {
    }

    @Override
    public void changeF7Context(Map uiContext, Context mainOrgContext) {
        for (AbstractF7Adaptor adaptor : this.F7AdaptorList) {
            adaptor.changeF7Context(uiContext, mainOrgContext);
        }
    }

    @Override
    public void changeF7Context(Map uiContext, Context mainOrgContext, OrgUnitCollection collection) {
        for (AbstractF7Adaptor adaptor : this.F7AdaptorList) {
            adaptor.changeF7Context(uiContext, mainOrgContext, collection);
        }
    }

    @Override
    public void setBOTPContext() {
    }

    public void removeRegistedF7(KDBizPromptBox prmtBox) {
        for (AbstractF7Adaptor adaptor : this.F7AdaptorList) {
            if (adaptor.getPromptBox() != prmtBox) continue;
            this.F7AdaptorList.remove(adaptor);
            break;
        }
    }

    public AbstractF7Adaptor getRegistedF7Adaptor(KDBizPromptBox prmtBox) {
        for (AbstractF7Adaptor adaptor : this.F7AdaptorList) {
            if (adaptor.getPromptBox() != prmtBox) continue;
            return adaptor;
        }
        return null;
    }

    public void registerContextChangeF7(RegisterF7Param param) {
        String mainOrgProperty = param.getMainOrgProperty();
        CommonF7AdaptorBuilder builder = new CommonF7AdaptorBuilder(mainOrgProperty);
        AbstractF7Adaptor adaptor = builder.buildAdaptor(param.getMainOrgType(), param.getQueryInfo(), param.getBizPromptBox());
        this.F7AdaptorList.add(adaptor);
        this.setRendorAndMainOrg(param);
    }

    private void setRendorAndMainOrg(RegisterF7Param param) {
        if (param.getCol() != null) {
            param.getCol().setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)param.getBizPromptBox()));
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
            param.getCol().setRenderer((IBasicRender)avr);
        }
        if (param.getMainOrg() != null) {
            param.getBizPromptBox().setCurrentMainBizOrgUnit(param.getMainOrg(), param.getMainOrgType());
        }
    }

    @Override
    public void registerF7(RegisterF7Param param, AbstractF7AdaptorBuilder builder) {
        if (builder == null) {
            return;
        }
        AbstractF7Adaptor adaptor = builder.buildAdaptor(param.getMainOrgType(), param.getQueryInfo(), param.getBizPromptBox());
        this.F7AdaptorList.add(adaptor);
        this.setRendorAndMainOrg(param);
    }
}

