/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.mutex;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.mutex.IDataObjectMutex;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataObjectMutex
implements IDataObjectMutex {
    private static Logger logger = Logger.getLogger(DataObjectMutex.class);

    @Override
    public void requestDataObjectLock(IObjectValue dataObject) throws Throwable {
        String msg = null;
        ObjectUpdateLock exist = this.getMutex(this.getObjectId(dataObject));
        if (exist != null) {
            msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ObjectUpdateLock_User");
            String userName = exist.getUserName();
            UserInfo user = UserFactory.getRemoteInstance().getUserInfoByNumber(exist.getUserName());
            if (user != null) {
                userName = user.getNumber() + "\uff08" + user.getName() + "\uff09";
            }
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new Object[]{userName});
            throw new EASBizException(new NumericExceptionSubItem("100", result));
        }
    }

    @Override
    public void requestDataObjectLock(String objId) throws Throwable {
        ObjectUpdateLock exist = this.getMutex(objId);
        if (exist != null) {
            throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
        }
        logger.info((Object)("locked object :" + objId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getMutexUser() {
        String dcName = SysContext.getSysContext().getDcName();
        IMutexServiceControl iMutexSC = MutexServiceControlFactory.getRemoteInstance();
        Map updateLocks = Collections.synchronizedMap(iMutexSC.getObjIDForUpdateList());
        Map.Entry entry2 = null;
        String key = null;
        ObjectUpdateLock lock = null;
        String userName = null;
        String objId = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (updateLocks == null) {
            return null;
        }
        Map map2 = updateLocks;
        synchronized (map2) {
            for (Map.Entry entry2 : updateLocks.entrySet()) {
                key = (String)entry2.getKey();
                lock = (ObjectUpdateLock)entry2.getValue();
                userName = lock.getUserName();
                if (dcName != null && dcName.trim().length() != 0 && (lock.getDcName() == null || lock.toString().length() <= 0 || !lock.getDcName().trim().equals(dcName))) continue;
                objId = dcName == null ? key : key.substring(0, key.length() - dcName.length());
                map.put(objId, userName);
            }
        }
        return map;
    }

    @Override
    public void releaseDataObjectLock(String objId) {
        if (objId == null || objId.trim().equals("")) {
            return;
        }
        this.releaseObjectLock(objId);
    }

    @Override
    public void releaseDataObjectLock(IObjectValue dataObject) {
        String id = this.getObjectId(dataObject);
        if (id == null || id.trim().equals("")) {
            return;
        }
        this.releaseObjectLock(id);
    }

    @Override
    public void batchDataService(IObjectValue requestObject, IObjectValue repleaseObject) {
        ArrayList<String> reqeustList = new ArrayList<String>();
        ArrayList<String> repleaseList = new ArrayList<String>();
        reqeustList.add(this.getObjectId(requestObject));
        repleaseList.add(this.getObjectId(repleaseObject));
        this.batchObjectService(reqeustList, repleaseList);
    }

    private ObjectUpdateLock getMutex(String id) {
        if (id == null || id.trim().equals("")) {
            return null;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        ObjectUpdateLock exist = mutexServiceControl.requestObjIDForUpdate2(id, SysContext.getSysContext().getUserName(), dcName);
        return exist;
    }

    private void releaseObjectLock(String id) {
        if (id == null || id.trim().equals("")) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.releaseObjIDForUpdate(id);
        logger.info((Object)("released object :" + id));
    }

    private void batchObjectService(List requestList, List repleaseList) {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.batchObjectUpdateLockService(requestList, repleaseList);
    }

    private String getObjectId(IObjectValue dataObject) {
        CoreBaseInfo obj;
        String id = "";
        if (dataObject != null && dataObject instanceof CoreBaseInfo && (obj = (CoreBaseInfo)dataObject).getId() != null && obj.getId().toString().length() > 0) {
            id = obj.getId().toString();
        }
        return id;
    }
}

