/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.client.monitor.LicenseClientUtil;
import com.kingdee.eas.base.permission.client.daq.DataAcquisitionClientHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.depend.RunTimeUtil;
import com.kingdee.eas.ep.client.util.CustomUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LicenseService {
    private Logger logger = Logger.getLogger(LicenseService.class);
    private boolean hasLicence = false;
    private IUIObject ui;
    public static String MODULENAME = "moduleName";
    public static String USERDEF = ".UserDef";
    public static final String BOS_CUSTOM_MODULE_UI = "com.kingdee.bos.custom.BOSCustomModuleUI";
    public static final String BOS_CUSTOM_MODULE_MIX_UI = "com.kingdee.bos.custom.BOSCustomModuleMixUI";
    public static final String BOS_CUSTOM_MODULE_PRO_MIX_UI = "com.kingdee.bos.custom.BOSCustomModuleProMixUI";
    public static final String BOS_CUSTOM_MODULE_MIX_ALL_UI = "com.kingdee.bos.custom.BOSCustomModuleMixALLUI";
    private static List licenseRecordList = new ArrayList();

    public LicenseService(IUIObject ui) {
        this.ui = ui;
    }

    public void checkLicence() throws Exception {
        String moduleName;
        String className;
        LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
        LicenseController lc = FrameWorkClientUtils.getLicenseController();
        if (!this.needCheck(lc, className = this.getUIClassName(this.ui))) {
            return;
        }
        ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
        boolean isSHRMultilingual = iLicenseSrvAgent.isSHRMultilingual();
        boolean isEASMultilingual = iLicenseSrvAgent.isEASMultilingual();
        int isSHRModuleNumberUI = iLicenseSrvAgent.isSHRModuleNumber(className);
        if (SysContext.getSysContext().getOriginLocale().equals(LocaleUtils.locale_en_US)) {
            if (isSHRModuleNumberUI == 1) {
                if (!isSHRMultilingual || !isEASMultilingual) {
                    MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_isNotMultilingual"), (String)this.constructMessage(lc, className), (int)0);
                    this.abort();
                }
            } else if (!isEASMultilingual) {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_isNotMultilingual"), (String)this.constructMessage(lc, className), (int)0);
                this.abort();
            }
        }
        if (!StringUtils.isEmpty((String)(moduleName = this.getModuleName()))) {
            this.userDefRequestLicense(lc, className, moduleName);
            return;
        }
        int licenselcFlag = lc.requestLicense(user, className);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("checkLicense.className: " + className + " licenselcFlag : " + licenselcFlag));
        }
        switch (licenselcFlag) {
            case 1: {
                this.hasLicence = true;
                if (!licenseRecordList.contains(className)) {
                    licenseRecordList.add(className);
                }
                try {
                    DataAcquisitionClientHelper.uiOnloadDeal((String)className);
                }
                catch (Exception e) {
                    this.logger.error((Object)"\u9875\u9762\u6253\u5f00\u6570\u636e\u91c7\u96c6\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case 4: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, className), (int)0);
                this.abort();
                break;
            }
            case 2: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"), (String)this.constructMessage(lc, className), (int)0);
                this.abort();
                break;
            }
            case 7: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_MIX_UI), (int)0);
                this.abort();
                break;
            }
            case 8: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_UI), (int)0);
                this.abort();
                break;
            }
            case 9: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_PRO_MIX_UI), (int)0);
                this.abort();
                break;
            }
            case 10: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_MIX_ALL_UI), (int)0);
                this.abort();
            }
        }
    }

    private String getModuleName() {
        Map params;
        String moduleName = (String)this.ui.getUIContext().get(MODULENAME);
        if (StringUtils.isEmpty((String)moduleName) && (params = CustomUI.getUIParam((String)((String)this.ui.getUIContext().get("UIClassParam")))) != null) {
            moduleName = (String)params.get(MODULENAME);
        }
        return moduleName;
    }

    private boolean isBosRuntimeMix() throws Exception {
        if (!RunTimeUtil.isCreateByDep((IUIObject)this.ui) && (RunTimeUtil.isExtendInBaseLayoutExcludeSys((CoreUIObject)((CoreUIObject)this.ui)) || RunTimeUtil.isExtendInIndividuationLayoutExcludeSys((CoreUIObject)((CoreUIObject)this.ui)))) {
            return true;
        }
        String clazzName = this.ui.getClass().getName();
        int EnhancerIndex = clazzName.indexOf("$$EnhancerByCGLIB");
        String string = clazzName = EnhancerIndex > 0 ? clazzName.substring(0, EnhancerIndex) : clazzName;
        return clazzName.endsWith("CTEx") || clazzName.endsWith("PIEx");
    }

    public void releaseLicense() throws Exception {
        if (this.hasLicence) {
            String sessionId = SysContext.getSysContext().getSessionID();
            LicenseController lc = FrameWorkClientUtils.getLicenseController();
            try {
                if (lc.isRegister()) {
                    return;
                }
                String className = this.getUIClassName(this.ui);
                if (!this.needCheck(lc, className)) {
                    return;
                }
                String moduleName = this.getModuleName();
                if (!StringUtils.isEmpty((String)moduleName)) {
                    this.userDefReleaseLicense(lc, className, moduleName);
                    return;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("releaseLicense releaseLicense.className: " + className));
                }
                lc.releaseLicense(sessionId, className);
                licenseRecordList.remove(className);
            }
            catch (LicenseException lex) {
                this.logger.error((Object)lex);
            }
            this.hasLicence = false;
        }
    }

    public void userDefReleaseLicense(LicenseController lc, String className, String moduleName) throws Exception {
        if (this.hasLicence) {
            String sessionId = SysContext.getSysContext().getSessionID();
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("releaseLicense userDefReleaseLicense.className: " + className + " moduleName: " + moduleName));
                }
                lc.releaseLicenseByModuleAndUIName(sessionId, moduleName, className);
                String userDef = moduleName + USERDEF;
                licenseRecordList.remove(userDef);
            }
            catch (LicenseException licenseException) {
                // empty catch block
            }
            this.hasLicence = false;
        }
    }

    public void userDefRequestLicense(LicenseController lc, String className, String moduleName) throws Exception {
        LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
        int licenselcFlag = lc.reqeustLicenseByModuleAndUIName(user, moduleName, className);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("checkLicense userDefRequestLicense.className: " + className + " moduleName: " + moduleName + " licenselcFlag : " + licenselcFlag));
        }
        switch (licenselcFlag) {
            case 1: {
                this.hasLicence = true;
                String userDef = moduleName + USERDEF;
                licenseRecordList.add(userDef);
                try {
                    DataAcquisitionClientHelper.uiOnloadDeal((String)className);
                }
                catch (Exception e) {
                    this.logger.error((Object)"\u9875\u9762\u6253\u5f00\u6570\u636e\u91c7\u96c6\u5931\u8d25", (Throwable)e);
                }
                break;
            }
            case 4: {
                ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
                boolean isCustom = iLicenseSrvAgent.isSubSystemControl(className);
                String errorDetail = null;
                errorDetail = isCustom ? this.constructMessage(lc, BOS_CUSTOM_MODULE_UI) : this.constructMessageByModuleName(lc, moduleName);
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)errorDetail, (int)0);
                this.abort();
                break;
            }
            case 2: {
                ILicenseSrvAgent iLicenseSrvAgent = LicenseSrvAgentFactory.getRemoteInstance();
                boolean isCustom = iLicenseSrvAgent.isSubSystemControl(className);
                String errorDetail = null;
                errorDetail = isCustom ? this.constructMessage(lc, BOS_CUSTOM_MODULE_UI) : this.constructMessageByModuleName(lc, moduleName);
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"), (String)errorDetail, (int)0);
                this.abort();
                break;
            }
            case 7: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_MIX_UI), (int)0);
                this.abort();
                break;
            }
            case 8: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_UI), (int)0);
                this.abort();
                break;
            }
            case 9: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_PRO_MIX_UI), (int)0);
                this.abort();
                break;
            }
            case 10: {
                MsgBox.showDetailAndOK((Component)((Object)((CoreUI)this.ui)), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)this.constructMessage(lc, BOS_CUSTOM_MODULE_MIX_ALL_UI), (int)0);
                this.abort();
            }
        }
    }

    private String getUIClassName(IUIObject uiObject) {
        String className = null;
        className = uiObject.getMetaDataPK() != null ? uiObject.getMetaDataPK().getFullName() : uiObject.getClass().getName();
        return className;
    }

    private String constructMessageByModuleName(LicenseController lc, String moduleName) throws LicenseException {
        if (lc == null || moduleName == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append(this.ui.getUITitle() + "[" + this.getUIClassName(this.ui) + "]");
        buffer.append("\n");
        buffer.append(LicenseService.constructLicenseMessageByModuleName(lc, moduleName));
        return buffer.toString();
    }

    private boolean needCheck(LicenseController lc, String fullClassName) throws LicenseException {
        String check = (String)this.ui.getUIContext().get("checkLicense");
        if (!StringUtils.isEmpty((String)check) && check.trim().equalsIgnoreCase("true")) {
            this.logger.info((Object)("license main menu,need check\uff1a" + fullClassName));
            return true;
        }
        this.logger.info((Object)("coreui license unlimited \uff1a" + fullClassName));
        return false;
    }

    private String constructMessage(LicenseController lc, String className) throws LicenseException {
        if (lc == null || className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ClassName"));
        buffer.append("[" + this.getUIClassName(this.ui) + "]");
        buffer.append("\n");
        buffer.append(LicenseService.constructLicenseMessage(lc, className));
        return buffer.toString();
    }

    private final String getPackageNameForClass(Class cls) {
        String packageName = this.getUIClassName(this.ui);
        return packageName.substring(0, packageName.lastIndexOf(".") + 1);
    }

    private void abort() {
        ((CoreUI)this.ui).setCursorOfDefault();
        SysUtil.abort();
    }

    public static final List getLicenseRecordList() {
        return licenseRecordList;
    }

    public static final String constructLicenseMessage(LicenseController lc, String className) throws LicenseException {
        if (lc == null || className == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName"));
        String moduleName = lc.getModuleByPackage(className);
        if (moduleName == null || moduleName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)moduleName) + "[" + moduleName + "]");
        }
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SubSystem"));
        String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)moduleName);
        if (subSysName == null || subSysName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName) + "[" + subSysName + "]");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public static final String constructLicenseMessageByModuleName(LicenseController lc, String moduleName) throws LicenseException {
        if (lc == null || moduleName == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ModuleName"));
        buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)moduleName) + "[" + moduleName + "]");
        buffer.append("\n");
        buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_SubSystem"));
        String subSysName = LicenseClientUtil.getSubSystemNameByModularName((String)moduleName);
        if (subSysName == null || subSysName.trim().length() == 0) {
            buffer.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_UnlimitUI"));
        } else {
            buffer.append(LicenseClientUtil.getModularAliasNameByModularName((String)subSysName) + "[" + subSysName + "]");
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

