/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.IPrintSetting;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Logger;

public class PrintServiceSet
implements IPrintActionListener {
    private Logger logger = Logger.getLogger(CoreUI.class);
    IPrintSetting printSetting = null;
    CoreUI ui = null;
    boolean isChange = false;
    private static String printDateMsg = "Print_date";
    private static String printPersonMsg = "Print_person";
    private static String printPageCountMsg = "Print_pageCount";

    public PrintServiceSet() {
    }

    public PrintServiceSet(CoreUI ui) {
        this.printSetting = ui;
        this.ui = ui;
    }

    public KDF getKDFForTable(KDTable kdt) {
        KDTPrintManager kdtPrintM = kdt.getPrintManager();
        KDF kdf = new KDF();
        kdtPrintM.saveToKDF(kdf);
        return kdf;
    }

    public boolean loadPrintSetting() throws Exception {
        KDF kdf = null;
        String setting = null;
        boolean isExist = false;
        KDTable table = this.printSetting.getTableForPrint();
        if (!this.printSetting.isUsePrintDefault()) {
            if (this.printSetting.getQuerySolutionInfo() != null) {
                setting = this.printSetting.getQuerySolutionInfo().getPrintSolution();
            } else if (this.printSetting.getPrintHelper() != null) {
                setting = this.printSetting.getPrintHelper().getPrintSetting(table);
            }
        }
        if (setting != null && !"".equals(setting) && !"null".equalsIgnoreCase(setting)) {
            kdf = new KDF((Reader)new StringReader(setting));
            isExist = true;
        } else {
            kdf = new KDF();
        }
        KDTPrintManager kdtPrintM = table.getPrintManager();
        kdtPrintM.setFromKDF(kdf);
        if (this.printSetting.getExtVarProvider() != null) {
            kdtPrintM.addHeaderFooterVarProvider(this.printSetting.getExtVarProvider());
        }
        return isExist;
    }

    private void saveSolutionInfo(String printString) {
        try {
            this.printSetting.getQuerySolutionInfo().setPrintSolution(printString);
            BOSUuid uuid = this.printSetting.getQuerySolutionInfo().getId();
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            IQuerySolution querySolution = QuerySolutionFactory.getRemoteInstance();
            QuerySolutionInfo solutionInfo = querySolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setPrintSolution(printString);
            querySolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void savePrintSetting() {
        KDTable table = this.printSetting.getTableForPrint();
        KDTPrintManager kdtPrintM = table.getPrintManager();
        KDF kdf = new KDF();
        kdtPrintM.saveToKDF(kdf);
        StringWriter writer = new StringWriter();
        kdf.save((Writer)writer);
        if (this.printSetting.getQuerySolutionInfo() != null) {
            this.saveSolutionInfo(writer.toString());
        } else {
            this.printSetting.getPrintHelper().setPrintSetting(table, writer.toString());
        }
    }

    public void preparePrintPage(KDTable table) {
        if (table == null) {
            table = this.printSetting.getTableForPrint();
        }
        try {
            boolean isExist = this.loadPrintSetting();
            if (!isExist) {
                this.getDefaultPrintSetting(table);
            }
            KDTPrintManager manager = table.getPrintManager();
            if (this.ui.getUITitle() != null && this.ui.getUITitle().trim().length() != 0) {
                manager.setPrintJobName(this.ui.getUITitle());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"load Print setting Error", (Throwable)e);
        }
    }

    private void getDefaultPrintSetting(KDTable table) {
        HeadFootModel header = new HeadFootModel();
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(14);
        sa.setBold(true);
        header.addRow(this.printSetting.getPrintTitle(), sa);
        header.addRow("");
        HeadFootModel footer = new HeadFootModel();
        String dateString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printDateMsg)) + "&[Date]";
        String personString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPersonMsg)) + SysContext.getSysContext().getCurrentUserInfo().getName();
        String pageNumber = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPageCountMsg)) + "&[Page]/&[PageCount]";
        String footerString = dateString + "&|" + personString + "&|" + pageNumber;
        StyleAttributes sb = Styles.getDefaultSA();
        footer.addRow(footerString, sb);
        this.printSetting.preparePrintHeader(header);
        this.printSetting.preparePrintFooter(footer);
        Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        Page fPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)footer);
        ExtVarProvider extVarProvider = this.printSetting.getExtVarProvider();
        if (extVarProvider != null) {
            table.getPrintManager().setHeaderFooter(hPage, fPage, extVarProvider);
        } else {
            table.getPrintManager().setHeaderFooter(hPage, fPage);
        }
        table.getPrintManager().getNewPrintManager().getPrinter().setParentWindow((Component)((Object)this.ui));
        table.getPrintManager().getNewPrintManager().getPrinter().getParentWindow().addNotify();
        Graphics g = table.getPrintManager().getNewPrintManager().getPrinter().getParentWindow().getGraphics();
        table.getPrintManager().autoAdjustBodyTopMargin(g);
    }

    public void beforePrintOrPreview() {
    }

    public void closePreview() {
        if (this.isChange) {
            this.savePrintSetting();
            this.isChange = false;
        }
    }

    public void beforePreview() {
        this.preparePrintPage(null);
    }

    public void beforePrint() {
    }

    public class PrinterSetChange
    implements IConfigChangeListener {
        public void configChanged() {
            PrintServiceSet.this.isChange = true;
        }

        public void configOver() {
        }

        public void configWillChange() {
        }
    }
}

