/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.ui.layout.JSONUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RiskService {
    private static Logger logger = Logger.getLogger(RiskService.class);
    private static Class riskClientUtilClazz = null;
    private static Method actionRiskBatchM = null;
    private static Method actionRiskForModelM = null;
    private static Method actionRiskMarkM = null;
    private static Method weakRiskBatchM = null;
    private static Method weakRiskForModelM = null;
    private static final String operateMark_cancel = "cancel";
    private static final String operateMark_no = "no";
    private static final String operateMark_confirm = "confirm";
    private static final String FrameWorkRes = "com.kingdee.eas.framework.FrameWorkResource";

    public static ArrayList checkRiskBillIds(ArrayList billIds, IMetaDataPK metaPK, String actionName) {
        if (riskClientUtilClazz == null || actionRiskBatchM == null) {
            return billIds;
        }
        int choice = 0;
        ArrayList resultBillIds = billIds;
        ArrayList successBillIds = new ArrayList();
        try {
            JSONObject json;
            Object result = actionRiskBatchM.invoke(null, billIds, metaPK.getFullName(), actionName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("fireRiskBeforeAction " + metaPK.getFullName() + "\nactionName is" + actionName + " getActionRiskBatch result is : \n" + result));
            }
            if ((json = new JSONObject(result.toString())).length() > 0) {
                String operateMark;
                String execBatchNumber = JSONUtils.getString((JSONObject)json, (String)"execBatchNumber");
                int successNum = JSONUtils.getIntger((JSONObject)json, (String)"successNum");
                int failNum = JSONUtils.getIntger((JSONObject)json, (String)"failNum");
                RiskDetailInfo info = new RiskDetailInfo();
                JSONArray failDetail = JSONUtils.getJSONArray((JSONObject)json, (String)"failDetail");
                if (failNum > 0 && failDetail != null) {
                    RiskService.handleDetail(info, failDetail, "RiskFailNumber");
                    choice = MsgBox.showConfirm4a(null, (String)EASResource.getString((String)FrameWorkRes, (String)"CheckRiskBillIdsResult", (Object[])new Object[]{info.getPassSize() + info.getFailSize(), successNum, failNum}), (String)info.getDetail().toString());
                    successBillIds = (ArrayList)RiskService.removeErrorIdByRiskDetail(billIds, failDetail);
                }
                if (MsgBox.isCancel((int)choice)) {
                    operateMark = operateMark_cancel;
                    resultBillIds = null;
                } else if (MsgBox.isNo((int)choice)) {
                    operateMark = operateMark_no;
                    resultBillIds = successBillIds;
                } else {
                    operateMark = operateMark_confirm;
                    resultBillIds = billIds;
                }
                if (actionRiskMarkM != null && !StringUtils.isEmpty((String)execBatchNumber)) {
                    try {
                        actionRiskMarkM.invoke(null, execBatchNumber, operateMark);
                    }
                    catch (Exception e1) {
                        logger.error((Object)("RiskClientUtil#actionRiskMark error! execBatchNumber is " + execBatchNumber + " and operateMark is " + operateMark + " actionName is " + actionName), (Throwable)e1);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("RiskClientUtil#getActionRiskBatch error! uipk is " + metaPK.getFullName() + " and ids is " + billIds + " actionName is " + actionName), (Throwable)ex);
            return billIds;
        }
        if (MsgBox.isCancel((int)choice) || resultBillIds.size() == 0) {
            SysUtil.abort();
        }
        return resultBillIds;
    }

    public static boolean checkRiskBill(IObjectValue model, IMetaDataPK metaPK, String actionName, BOTRelationCollection botRelColl) {
        if (riskClientUtilClazz == null || actionRiskForModelM == null) {
            return true;
        }
        int choice = 0;
        JSONObject json = null;
        try {
            Object result = actionRiskForModelM.invoke(null, model, metaPK.getFullName(), actionName, botRelColl);
            if (logger.isDebugEnabled()) {
                logger.info((Object)("checkActionRisk " + metaPK.getFullName() + "\nactionName is" + actionName + " getActionRisk result is : \n" + result));
            }
            json = new JSONObject(result.toString());
        }
        catch (Exception ex) {
            logger.error((Object)("getActionRiskBatch error! uipk is " + metaPK.getFullName() + " and actionName is " + actionName), (Throwable)ex);
        }
        if (json != null && json.length() > 0) {
            boolean saved = JSONUtils.getBoolean(json, (String)"saved");
            if (!saved) {
                MsgBox.showInfo(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightSavedCheck"));
                SysUtil.abort();
                return false;
            }
            try {
                RiskDetailInfo info = new RiskDetailInfo();
                String execBatchNumber = JSONUtils.getString((JSONObject)json, (String)"execBatchNumber");
                boolean success = JSONUtils.getBoolean((JSONObject)json, (String)"allExecSuccess");
                if (!success) {
                    Integer passSize;
                    Integer failSize;
                    JSONArray list1 = JSONUtils.getJSONArray((JSONObject)json, (String)"list");
                    if (list1 != null) {
                        RiskService.handelJSONList(info.getDetail(), list1);
                    }
                    if ((failSize = JSONUtils.getIntger((JSONObject)json, (String)"failSize")) != null) {
                        info.addFail(failSize);
                    }
                    if ((passSize = JSONUtils.getIntger((JSONObject)json, (String)"passSize")) != null) {
                        info.addPass(passSize);
                    }
                }
                if (info.getPassSize() + info.getFailSize() > 0) {
                    String operateMark;
                    choice = MsgBox.showConfirm3a(null, (String)EASResource.getString((String)FrameWorkRes, (String)"CheckRiskBillResult", (Object[])new Object[]{info.getPassSize() + info.getFailSize()}), (String)info.getDetail().toString());
                    String string = operateMark = MsgBox.isCancel((int)choice) ? operateMark_cancel : operateMark_confirm;
                    if (actionRiskMarkM != null && !StringUtils.isEmpty((String)execBatchNumber)) {
                        try {
                            actionRiskMarkM.invoke(null, execBatchNumber, operateMark);
                        }
                        catch (Exception e1) {
                            logger.error((Object)("RiskClientUtil#actionRiskMark error! execBatchNumber is " + execBatchNumber + " and operateMark is " + operateMark + " actionName is " + actionName), (Throwable)e1);
                        }
                    }
                }
            }
            catch (JSONException jex) {
                jex.printStackTrace();
            }
        }
        if (MsgBox.isCancel((int)choice)) {
            SysUtil.abort();
            return false;
        }
        return true;
    }

    private static void handelJSONList(StringBuilder sb, JSONArray list1) throws JSONException {
        for (int i = 0; i < list1.length(); ++i) {
            JSONObject obj1 = list1.getJSONObject(i);
            JSONArray list2 = JSONUtils.getJSONArray((JSONObject)obj1, (String)"list");
            if (list2 == null) continue;
            sb.append(obj1.getString("typeName")).append("\t");
            sb.append(list2.length()).append(EASResource.getString((String)FrameWorkRes, (String)"RiskItem")).append("\r\n");
            for (int j = 0; j < list2.length(); ++j) {
                JSONArray showDataList;
                JSONObject obj2 = list2.getJSONObject(j);
                sb.append(EASResource.getString((String)FrameWorkRes, (String)"RiskResult")).append(j + 1).append("\uff1a").append(obj2.getString("explains")).append("\r\n");
                JSONArray billOpts = JSONUtils.getJSONArray((JSONObject)obj2, (String)"billOpts");
                if (billOpts != null && billOpts.length() > 0) {
                    for (int k = 0; k < billOpts.length(); ++k) {
                        JSONObject obj3 = billOpts.getJSONObject(k);
                        sb.append(obj3.getString("fieldName")).append("\uff1a").append(obj3.getString("fieldValue")).append("\r\n");
                    }
                }
                if ((showDataList = JSONUtils.getJSONArray((JSONObject)obj2, (String)"showDataList")) == null || showDataList.length() <= 0) continue;
                for (int k = 0; k < showDataList.length(); ++k) {
                    JSONObject obj3 = showDataList.getJSONObject(k);
                    sb.append(obj3.getString("showName")).append("\uff1a").append(obj3.getString("showValue")).append("\r\n");
                }
            }
        }
    }

    public static void handleDetail(RiskDetailInfo info, JSONArray detail, String resName) throws JSONException {
        for (int i = 0; i < detail.length(); ++i) {
            JSONArray list1;
            Integer passSize;
            JSONObject detailObj = detail.getJSONObject(i);
            Integer failSize = JSONUtils.getIntger((JSONObject)detailObj, (String)"failSize");
            if (failSize != null) {
                info.addFail(failSize);
            }
            if ((passSize = JSONUtils.getIntger((JSONObject)detailObj, (String)"passSize")) != null) {
                info.addPass(passSize);
            }
            if ((list1 = JSONUtils.getJSONArray((JSONObject)detailObj, (String)"list")) == null) continue;
            info.getDetail().append(EASResource.getString((String)FrameWorkRes, (String)resName)).append(detailObj.getString("billNumber")).append("\r\n");
            RiskService.handelJSONList(info.getDetail(), list1);
        }
    }

    public static List<String> removeErrorIdByRiskDetail(List<String> billIds, JSONArray detail) throws JSONException {
        ArrayList<String> newIds = new ArrayList<String>(billIds);
        for (int i = 0; i < detail.length(); ++i) {
            JSONObject failDetailObj = detail.getJSONObject(i);
            JSONArray list1 = JSONUtils.getJSONArray((JSONObject)failDetailObj, (String)"list");
            if (list1 == null) continue;
            String failId = failDetailObj.getString("billId");
            for (int j = newIds.size() - 1; j >= 0; --j) {
                if (!failId.equals(newIds.get(j))) continue;
                newIds.remove(j);
            }
        }
        return newIds;
    }

    public static void actionRiskInsightForBatch(ArrayList billIds, IMetaDataPK metaPK) {
        if (riskClientUtilClazz == null || weakRiskBatchM == null) {
            return;
        }
        try {
            Object result = weakRiskBatchM.invoke(null, billIds, metaPK.getFullName());
            logger.info((Object)(metaPK.getFullName() + " actionRiskInsight result is : " + result));
            JSONObject json = new JSONObject(result.toString());
            if (json.length() > 0) {
                JSONArray successDetail;
                int successNum = JSONUtils.getIntger((JSONObject)json, (String)"successNum");
                int failNum = JSONUtils.getIntger((JSONObject)json, (String)"failNum");
                RiskDetailInfo info = new RiskDetailInfo();
                JSONArray failDetail = JSONUtils.getJSONArray((JSONObject)json, (String)"failDetail");
                if (failNum > 0 && failDetail != null) {
                    RiskService.handleDetail(info, failDetail, "RiskFailNumber");
                }
                if ((successDetail = JSONUtils.getJSONArray((JSONObject)json, (String)"successDetail")) != null) {
                    RiskService.handleDetail(info, successDetail, "RiskSuccessNumber");
                }
                if (info.getPassSize() + info.getFailSize() > 0) {
                    if (info.getFailSize() > 0) {
                        MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightBatchResultDetail", (Object[])new Object[]{successNum + failNum, info.getPassSize() + info.getFailSize(), successNum, failNum, info.getFailSize()}), (String)info.getDetail().toString(), (int)1);
                    } else {
                        MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightBatchResultNoFail", (Object[])new Object[]{successNum + failNum, info.getPassSize() + info.getFailSize(), successNum}), (String)info.getDetail().toString(), (int)1);
                    }
                } else {
                    MsgBox.showInfo(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightNoData"));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("actionRiskInsight error! uipk is " + metaPK.getFullName() + " and ids is " + billIds), (Throwable)ex);
        }
    }

    public static void actionRiskInsightForModel(IObjectValue bill, IMetaDataPK metaPK, BOTRelationCollection botRelColl) {
        if (riskClientUtilClazz == null || weakRiskForModelM == null) {
            return;
        }
        JSONObject json = null;
        try {
            Object result = weakRiskForModelM.invoke(null, bill, metaPK.getFullName(), botRelColl);
            logger.info((Object)(metaPK.getFullName() + " actionRiskInsight result is : " + result));
            json = new JSONObject(result.toString());
        }
        catch (Exception ex) {
            logger.error((Object)("actionRiskInsight error! uipk is " + metaPK.getFullName() + " and editData is " + bill), (Throwable)ex);
        }
        if (json != null && json.length() > 0) {
            boolean saved = JSONUtils.getBoolean(json, (String)"saved");
            if (!saved) {
                MsgBox.showInfo(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightSaveCheck"));
                SysUtil.abort();
            }
            RiskDetailInfo info = new RiskDetailInfo();
            try {
                Integer passSize;
                Integer failSize;
                JSONArray list1 = JSONUtils.getJSONArray((JSONObject)json, (String)"list");
                if (list1 != null) {
                    RiskService.handelJSONList(info.getDetail(), list1);
                }
                if ((failSize = JSONUtils.getIntger((JSONObject)json, (String)"failSize")) != null) {
                    info.addFail(failSize);
                }
                if ((passSize = JSONUtils.getIntger((JSONObject)json, (String)"passSize")) != null) {
                    info.addPass(passSize);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"actionRiskInsight error!", (Throwable)ex);
            }
            if (info.getPassSize() + info.getFailSize() > 0) {
                MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightModelResult", (Object[])new Object[]{info.getPassSize() + info.getFailSize(), info.getPassSize(), info.getFailSize()}), (String)info.getDetail().toString(), (int)1);
            } else {
                MsgBox.showInfo(null, (String)EASResource.getString((String)FrameWorkRes, (String)"RiskInsightNoData"));
            }
        }
    }

    public static String handleRiskExceptionJson(String str) throws JSONException {
        JSONObject json = new JSONObject(str);
        StringBuilder sb = new StringBuilder();
        JSONArray list1 = JSONUtils.getJSONArray((JSONObject)json, (String)"list");
        if (list1 != null) {
            RiskService.handelJSONList(sb, list1);
        }
        return sb.toString();
    }

    static {
        try {
            riskClientUtilClazz = Class.forName("com.kingdee.eas.base.risk.service.client.RiskClientUtil");
            try {
                actionRiskBatchM = riskClientUtilClazz.getMethod("getActionRiskBatch", List.class, String.class, String.class);
            }
            catch (Exception e) {
                logger.error((Object)"getMethod getActionRiskBatch error!", (Throwable)e);
                actionRiskBatchM = null;
            }
            try {
                actionRiskForModelM = riskClientUtilClazz.getMethod("getActionRiskForModel", IObjectValue.class, String.class, String.class, IObjectCollection.class);
            }
            catch (Exception e) {
                logger.error((Object)"getMethod getActionRiskForModel error!", (Throwable)e);
                actionRiskForModelM = null;
            }
            try {
                actionRiskMarkM = riskClientUtilClazz.getMethod("actionRiskMark", String.class, String.class);
            }
            catch (Exception e) {
                logger.error((Object)"getMethod actionRiskMark error!", (Throwable)e);
                actionRiskMarkM = null;
            }
            try {
                weakRiskBatchM = riskClientUtilClazz.getMethod("getWeakRiskBatch", List.class, String.class);
            }
            catch (Exception e) {
                logger.error((Object)"getMethod getWeakRiskBatch error!", (Throwable)e);
                weakRiskBatchM = null;
            }
            try {
                weakRiskForModelM = riskClientUtilClazz.getMethod("getWeakRiskForModel", IObjectValue.class, String.class, IObjectCollection.class);
            }
            catch (Exception e) {
                logger.error((Object)"getMethod getWeakRiskForModel error!", (Throwable)e);
                weakRiskForModelM = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"class forName error!", (Throwable)e);
            riskClientUtilClazz = null;
        }
    }

    static class RiskDetailInfo {
        private int failSize = 0;
        private int passSize = 0;
        private StringBuilder detail = new StringBuilder();

        public int getFailSize() {
            return this.failSize;
        }

        public void setFailSize(int failSize) {
            this.failSize = failSize;
        }

        public int getPassSize() {
            return this.passSize;
        }

        public void setPassSize(int passSize) {
            this.passSize = passSize;
        }

        public StringBuilder getDetail() {
            return this.detail;
        }

        public void setDetail(StringBuilder detail) {
            this.detail = detail;
        }

        public void addFail(int size) {
            this.failSize += size;
        }

        public void addPass(int size) {
            this.passSize += size;
        }
    }
}

