/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.sidebar;

import com.kingdee.eas.framework.client.sidebar.SideBarArea;
import com.kingdee.eas.framework.client.sidebar.SideBarBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class SideBarImgTips
extends SideBarBase {
    private static Logger logger = Logger.getLogger(SideBarArea.class);
    public static final String EAS_SIDEBAR_ICON = "imgWBSidebar_right";
    private static String strTip = null;
    private static Icon imageIcon = null;
    private boolean isShowWebBrowser = false;
    SideBarArea side = null;

    public SideBarImgTips(JComponent owner) {
        super(owner);
        this.getSideBarPane().setLayout(new FlowLayout(1, 0, 0));
        this.getSideBarPane().add(this.createSideBar());
    }

    private JPanel createSideBar() {
        JLabel label = new JLabel();
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setBackground(this.getColor(0xAAAAFF, 0.85f));
        Border border1 = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        label.setBorder(border1);
        label.setIcon(this.getIcon());
        JPanel p = new JPanel();
        SideBarImgMouseListener li = new SideBarImgMouseListener(p);
        p.addMouseListener(li);
        p.setLayout(new FlowLayout(1, 0, 0));
        p.add(label);
        return p;
    }

    private Color getColor(int i, float f) {
        int b = (int)((float)(i & 0xFF) * f);
        int g = (int)((float)((i >>= 8) & 0xFF) * f);
        int r = (int)((float)((i >>= 8) & 0xFF) * f);
        return new Color(r, g, b);
    }

    @Override
    public Icon getIcon() {
        return EASResource.getIcon((String)EAS_SIDEBAR_ICON);
    }

    public void setTipText(String text) {
        strTip = text;
    }

    public String getTipText() {
        return strTip;
    }

    @Override
    public void setBillID(String billid) {
        super.setBillID(billid);
        if (this.side != null) {
            this.side.setBillID(billid);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.getIcon().getIconWidth() > 0 ? this.getIcon().getIconWidth() : 30;
        int height = this.getIcon().getIconHeight() > 0 ? this.getIcon().getIconHeight() : 130;
        return new Dimension(width, height);
    }

    public void reLocation() {
        if (this.isShowWebBrowser || this.getOwner() == null) {
            return;
        }
        if (this.getOwnerWindow() == null) {
            return;
        }
        int x = this.getOwnerWindow().getX() + this.getOwnerWindow().getWidth();
        int y = this.getOwnerWindow().getY();
        if (x <= 0 || this.getOwnerWindow().getHeight() < this.getDialog().getHeight() || this.getOwnerWindow().getWidth() < this.getDialog().getWidth()) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        x = x - this.getDialog().getWidth() - 2;
        y = y + this.getOwnerWindow().getHeight() / 2 - this.getDialog().getHeight() / 2;
        this.getDialog().setSize(this.getIcon().getIconWidth(), this.getIcon().getIconHeight());
        this.getDialog().setLocation(x, y);
    }

    public final void setShowWebBrowser(boolean b) {
        this.isShowWebBrowser = b;
    }

    @Override
    public void show() {
        this.isShowWebBrowser = false;
        super.show();
    }

    void addComponentListener() {
        this.getDialog().addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                SideBarImgTips.this.getDialog().hide();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                SideBarImgTips.this.side.reLocation();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SideBarImgTips.this.side.reLocation();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                SideBarImgTips.this.side.reLocation();
            }
        });
    }

    @Override
    public void close() {
        if (this.side != null) {
            this.side.closeWin();
        }
        super.close();
    }

    public void hideWin() {
        this.getDialog().setVisible(false);
        if (this.side != null) {
            this.side.getDialog().setVisible(false);
        }
    }

    public void showWin() {
        this.getDialog().setVisible(true);
        if (this.side != null) {
            this.side.getDialog().setVisible(true);
            this.getDialog().setVisible(false);
        }
    }

    public SideBarArea getSideBarArea() {
        return this.side;
    }

    class SideBarImgMouseListener
    implements MouseListener {
        JPanel panel;

        SideBarImgMouseListener(JPanel p) {
            this.panel = p;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SideBarImgTips.this.getOwner() != null && SideBarImgTips.this.getOwnerWindow() != null && SideBarImgTips.this.getOwnerWindow() instanceof JFrame) {
                if (((JFrame)SideBarImgTips.this.getOwnerWindow()).getExtendedState() != 6) {
                    ((JFrame)SideBarImgTips.this.getOwnerWindow()).setExtendedState(6);
                }
                ((JFrame)SideBarImgTips.this.getOwnerWindow()).setResizable(false);
            }
            if (SideBarImgTips.this.getBillID() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"69_SideBarImgTips"));
                return;
            }
            if (SideBarImgTips.this.side == null) {
                SideBarImgTips.this.side = new SideBarArea(SideBarImgTips.this.getDialog());
            }
            SideBarImgTips.this.side.setDCNumber(SideBarImgTips.this.getDCNumber());
            SideBarImgTips.this.side.setLocal(SideBarImgTips.this.getLocal());
            SideBarImgTips.this.side.setBillID(SideBarImgTips.this.getBillID());
            SideBarImgTips.this.side.hide();
            SwingUtilities.invokeLater(SideBarImgTips.this.side);
            SideBarImgTips.this.getDialog().setVisible(false);
            logger.info((Object)"weibo run finished...");
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.panel.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.panel.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

