/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.tree;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.util.FilterUtility;

public class DefaultLNTreeNodeCtrl
implements ILNTreeNodeCtrl {
    private ITreeBase treeCtrl;

    public DefaultLNTreeNodeCtrl(ITreeBase treeCtrl) {
        this.treeCtrl = treeCtrl;
    }

    @Override
    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level) throws Exception {
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level, null, null);
        TreeBaseCollection result = this.treeCtrl.getTreeBaseCollection(viewInfo);
        return result;
    }

    private EntityViewInfo getViewInfo(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection selector) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "!%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel()), CompareType.GREATER_EQUALS));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel() + level), CompareType.LESS_EQUALS));
        } else {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level), CompareType.LESS_EQUALS));
        }
        if (parentNodeInfo != null && FilterUtility.hasFilterItem(filter)) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        if (viewInfo == null) {
            viewInfo.setFilter(filter);
        }
        if (FilterUtility.hasFilterItem(filter)) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        if (selector != null) {
            for (int i = 0; i < selector.size(); ++i) {
                viewInfo.getSelector().add(selector.get(i));
            }
        } else {
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
        }
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        return viewInfo;
    }

    @Override
    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws Exception {
        return this.getChildren(parentNodeInfo, level, filter, null);
    }

    @Override
    public AbstractObjectCollection getChildren(TreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection selector) throws Exception {
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level, filter, selector);
        TreeBaseCollection result = this.treeCtrl.getTreeBaseCollection(viewInfo);
        return result;
    }
}

