/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.uicontroller;

import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.uicontroller.IService;
import com.kingdee.eas.framework.client.uicontroller.IUIModelListener;
import com.kingdee.eas.framework.client.uicontroller.IUISupport;
import com.kingdee.eas.framework.client.uicontroller.NullService;
import com.kingdee.eas.framework.client.uicontroller.UIServiceConfigManager;
import com.kingdee.eas.framework.client.uicontroller.UIStateEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class UISupport
implements IUISupport {
    private CoreUI ui;
    private Map options;
    private Logger logger = Logger.getLogger(UISupport.class);
    private HashMap services = new HashMap();
    private boolean is_loaded;
    private boolean is_unloaded;
    private boolean is_showed;
    private static IService null_service = new NullService();
    private ArrayList listeners = new ArrayList();

    public UISupport(CoreUI ui) {
        this.ui = ui;
    }

    @Override
    public void init(Map options) {
        this.options = options;
        UIServiceConfigManager.fillServices(this);
    }

    @Override
    public void registService(String service_name, IService service) {
        this.services.put(service_name.toLowerCase(), service);
    }

    @Override
    public void removeService(String service_name) {
        this.services.remove(service_name.toLowerCase());
    }

    public boolean hasService(String service_name) {
        return this.services.containsKey(service_name.toLowerCase());
    }

    @Override
    public IService lookup(String service_name) {
        if (this.services.containsKey(service_name.toLowerCase()) && this.services.get(service_name.toLowerCase()) instanceof IService) {
            IService service = (IService)this.services.get(service_name.toLowerCase());
            return service.isEnable() ? service : null_service;
        }
        return null_service;
    }

    public Object lookupAndExecute(String service_name, String method_name, Object[] params) {
        IService service = this.lookup(service_name);
        return service.doService(method_name, params);
    }

    @Override
    public boolean isUILoad() {
        return this.is_loaded;
    }

    @Override
    public boolean isUIShowed() {
        return this.is_showed;
    }

    @Override
    public boolean isUIUnload() {
        return this.is_unloaded;
    }

    @Override
    public void UILoad() {
        this.is_loaded = true;
        this.fireUIStateChanged(UIStateEnum.OnLoad, UIStateEnum.ONInit);
    }

    @Override
    public void UIShowed() {
        this.is_showed = true;
        this.fireUIStateChanged(UIStateEnum.OnShowed, UIStateEnum.OnLoad);
    }

    @Override
    public void MainOrgChanged(String oldOrgId, String newOrgId) {
        this.fireMainOrgChanged(oldOrgId, newOrgId);
    }

    @Override
    public void UIUnLoad() {
        if (this.isUIShowed()) {
            this.fireUIStateChanged(UIStateEnum.OnUnload, UIStateEnum.OnShowed);
        } else {
            this.fireUIStateChanged(UIStateEnum.OnUnload, UIStateEnum.OnLoad);
        }
    }

    @Override
    public CoreUI getUIView() {
        return this.ui;
    }

    @Override
    public void addUIModelListener(IUIModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeUIModleListener(IUIModelListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireUIStateChanged(UIStateEnum new_state, UIStateEnum old_state) {
        for (IUIModelListener listener : this.listeners) {
            listener.uiStateChanged(new_state, old_state);
        }
    }

    private void fireMainOrgChanged(String oldOrgId, String newOrgId) {
        for (IUIModelListener listener : this.listeners) {
            listener.mainOrgChanged(oldOrgId, newOrgId);
        }
    }
}

