/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.wizard;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.framework.client.wizard.IWizard;
import com.kingdee.eas.framework.client.wizard.IWizardPage;
import java.util.ArrayList;
import java.util.List;

public abstract class Wizard
implements IWizard {
    private KDPanel container = null;
    private List pages = new ArrayList();

    @Override
    public void setContainer(KDPanel wizardContainer) {
        this.container = wizardContainer;
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard(this);
    }

    @Override
    public void addPages() {
    }

    @Override
    public boolean canFinish() {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (((IWizardPage)this.pages.get(i)).isPageComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(index + 1);
    }

    @Override
    public IWizardPage getPage(String name) {
        for (int i = 0; i < this.pages.size(); ++i) {
            IWizardPage page = (IWizardPage)this.pages.get(i);
            String pageName = page.getName();
            if (!pageName.equals(name)) continue;
            return page;
        }
        return null;
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    @Override
    public int indexOfPage(IWizardPage page) {
        return this.pages.indexOf(page);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return (IWizardPage)this.pages.get(index - 1);
    }

    @Override
    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (IWizardPage)this.pages.get(0);
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public abstract boolean performFinish();

    @Override
    public KDPanel getContainer() {
        return this.container;
    }
}

