/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.uistatemanage.ActionState;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.biz.trans.EASWfServiceData;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.FunctionDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.SubflowActivityDef;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.NoOperationRithtException;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogFactory;
import com.kingdee.bos.workflow.metas.WFRProcessInstLogInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public final class EASWfServiceClient {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.eas.framework.client.workflow.EASWfServiceClient");
    private IEnactmentService service = null;
    private String url = "tcp://127.0.0.1";
    private static final String UICONTEXT_WFASSIGNMENTINFOS = "WfAssignmentInfos";
    private static final String UICONTEXT_IDLIST = "IDList";
    private static final String UICONTEXT_OWNER = "Owner";
    private static final String UICONTEXT_WFASSIGNMENTINFO = "WfAssignmentInfo";
    private static final String UICONTEXT_OPEARTIONINFO = "OperationInfo";
    private static final String UICONTEXT_ISFROMWORKFLOW = "isFromWorkflow";
    private static final String UICONTEXT_FUNCTIONOBJECTINFO = "FunctionObjectInfo";
    private static final String UICONTEXT_WFACTINSTINFO = "wfInstInfo";
    private static final String UICONTEXT_USERINFO = "UserInfo";
    private static final String UICONTEXT_USERID = "UserID";
    private static final String UICONTEXT_ISMANUALDICISIONNODE = "isManualDecisionNode";
    private static final String FUNCTIONNAME_MULTIAPPROVE = "com.kingdee.eas.base.multiapprove.client.MultiApproveUIFunction";
    private static final String UINAME_MULTIAPPROVELIST = "com.kingdee.eas.base.multiapprove.client.MultiApproveListUI";
    private static final String UINAME_MULTIAPPROVEUI = "com.kingdee.eas.base.multiapprove.client.MultiApproveUI";
    private static final String UINAME_MULTIASSIGNMENT = "com.kingdee.eas.framework.client.workflow.MultiAssignmentUI";
    private static final String UINAME_MANUALDECISIONUI = "com.kingdee.eas.base.multiapprove.client.ManualDecisionUI";
    private static final String UINAME_MANUALDECISIONBILLUI = "com.kingdee.eas.base.multiapprove.client.ManualDecisionBillUI";
    private static boolean filterWfAssignmentsByBOSType = false;

    public EASWfServiceClient() {
        try {
            this.init();
        }
        catch (BOSException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public String getHostString() {
        return this.url;
    }

    public void setHostString(String hostString) {
        this.url = hostString;
    }

    public void init(String url, String sessionId) throws BOSException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseKpdlFromPath(String filePath) throws Exception {
        String result = null;
        File file = null;
        FileInputStream fileStream = null;
        try {
            file = new File(filePath);
            byte[] buffer = new byte[(int)file.length()];
            fileStream = new FileInputStream(file);
            fileStream.read(buffer);
            result = new String(buffer, "UTF-8");
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.service.releaseProcessDef(result, true);
    }

    public ProcessDefInfo[] getProcDefMetaArrayAll() throws WfException {
        return this.service.getProcDefInfoArrayAll();
    }

    public ProcessDefInfo[] getProcDefArrayDistinct() throws WfException {
        return this.service.getProcDefArrayDistinct();
    }

    public static void invokePassCommentUI(String billObjectId, String sender) throws UIException {
        HashMap<String, String> uiContext = new HashMap<String, String>();
        IUIWindow window = null;
        uiContext.put("boid", billObjectId);
        uiContext.put("sender", sender);
        uiContext.put("canResize", "true");
        window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.base.multiapprove.client.PassCommentUI", uiContext, null, null, 66);
        if (window instanceof UINewFrame) {
            window.getUIObject().getUIMenuBar().setVisible(false);
        }
        window.show();
    }

    public static void invokePassCommentUI(String parameters) throws UIException {
        HashMap<String, String> uiContext = new HashMap<String, String>();
        IUIWindow window = null;
        uiContext.put("parameters", parameters);
        uiContext.put("canResize", "true");
        window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.base.multiapprove.client.PassCommentUI", uiContext, null, null, 66);
        if (window instanceof UINewFrame) {
            window.getUIObject().getUIMenuBar().setVisible(false);
        }
        window.show();
    }

    public void startProcessInst(String procInstId) throws WfException {
        this.service.startProcessInst(procInstId);
    }

    public void startProcessInst(String procInstId, String firstActDefId) throws WfException {
        this.service.startProcessInst(procInstId, firstActDefId);
    }

    public void startProcessInst(String procInstId, String firstActDefId, String firstActPerformerUserId) throws WfException {
        this.service.startProcessInst(procInstId, firstActDefId, firstActPerformerUserId);
    }

    public ProcessInstInfo createProcessInst(String procDefId, String initiatorId, String initiatorName) throws WfException {
        return this.service.createProcessInst(procDefId, initiatorId, initiatorName);
    }

    public ProcessDefInfo releaseProcessDef(String xmlString, boolean enable) throws WfException {
        return this.service.releaseProcessDef(xmlString, enable).getProcessDefInfo();
    }

    public ProcessDefInfo releaseProcessDef(ProcessDefInfo procInfo, boolean enable) throws WfException {
        return this.service.releaseProcessDef(procInfo, enable).getProcessDefInfo();
    }

    public void suspendProcessInst(String procInstId) throws WfException {
        this.service.suspendProcessInst(procInstId);
        this.logProcessOperation(ProcessInstEventEnum.SUSPEND, procInstId);
    }

    public void resumeProcessInst(String procInstId) throws WfException {
        this.service.resumeProcessInst(procInstId);
    }

    public void abortProcessInst(String procInstId) throws WfException {
        this.service.abortProcessInst(procInstId);
        this.logProcessOperation(ProcessInstEventEnum.ABORT, procInstId);
    }

    private void logActivityOperation(ProcessInstEventEnum eventEnum, String actInstId) {
        try {
            ActivityInstInfo activityInstInfo = EnactmentServiceFactory.createRemoteEnactService().getActivityInstByActInstId(actInstId);
            this.logProcessOperation(eventEnum, activityInstInfo.getProcInstId());
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    private void logProcessOperation(ProcessInstEventEnum eventEnum, String procInstId) {
        try {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            String msg = "User[" + userInfo.getNumber() + "] userID[" + userInfo.getId() + "], stack :";
            msg = msg + StringUtils.stackToString((Exception)new Exception());
            ProcessInstInfo processInstInfo = this.getProcessMeta(procInstId);
            WFRProcessInstLogInfo info = new WFRProcessInstLogInfo();
            info.setProcessDefID(BOSUuid.read((String)processInstInfo.getProcDefId()));
            info.setProcessVersion(processInstInfo.getProcDefInnerVersion());
            info.setProcessInstID(BOSUuid.read((String)procInstId));
            info.setLogType(LogTypeEnum.WARN);
            info.setEvent(eventEnum);
            info.setExtendedDescription(msg);
            info.setServer(this.getHostString());
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setTime(time);
            WFRProcessInstLogFactory.getRemoteInstance().addnew(info);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    public void terminateProcessInst(String procInstId) throws WfException {
        this.service.terminateActivityInst(procInstId);
        this.logProcessOperation(ProcessInstEventEnum.ABORT, procInstId);
    }

    public void completeActivityInst(String actInstId) throws WfException {
        this.service.completeActivityInst(actInstId);
    }

    public void abortActivityInst(String activityInstId) throws WfException {
        this.service.abortActivityInst(activityInstId);
        this.logActivityOperation(ProcessInstEventEnum.ABORT, activityInstId);
    }

    public void resumeActInst(String actInstId) throws WfException {
        this.service.resumeActInst(actInstId);
    }

    public void suspendActInst(String actInstId) throws WfException {
        this.service.suspendActInst(actInstId);
        this.logActivityOperation(ProcessInstEventEnum.SUSPEND, actInstId);
    }

    public void terminateActivityInst(String activityInstId) throws WfException {
        this.service.terminateActivityInst(activityInstId);
        this.logActivityOperation(ProcessInstEventEnum.ABORT, activityInstId);
    }

    public ProcessInstInfo getProcessMeta(String procInstId) throws WfException {
        return this.service.getProcessInstInfo(procInstId);
    }

    public AssignmentInfo[] getAssignmentByOwerId(String ownerId) throws WfException {
        return this.service.getAssignmentByOwerId(ownerId);
    }

    public AssignmentInfo[] getAssignmentByProcInstAndOwner(String procInstId, String ownerId, WfAssignmentState assignmentState) throws WfException {
        return this.service.getAssignmentByProcInstAndOwner(procInstId, ownerId, assignmentState);
    }

    public AssignmentInfo getAssignmentById(String assignId) throws WfException {
        return this.service.getAssignmentById(assignId);
    }

    public AssignmentInfo[] getAssignmentById(String[] assignIds, int type) throws WfException {
        return this.service.getAssignmentById(assignIds, type);
    }

    public AssignmentInfo[] getAssignmentByProcInstAndOwner(String procInstId, String ownerId) throws WfException {
        return this.service.getAssignmentByProcInstAndOwner(procInstId, ownerId);
    }

    public AssignmentInfo[] getAssignmentByProcInstId(String procInstId) throws WfException {
        return this.service.getAssignmentByProcInstId(procInstId);
    }

    public AssignmentInfo[] getAssignmentByActInstId(String actInstId) throws WfException {
        return this.service.getAssignmentByActInstId(actInstId);
    }

    public AssignmentInfo[] getAllAssignmentByActInstId(String actInstId) throws WfException {
        return this.service.getAllAssignmentByActInstId(actInstId);
    }

    public AssignmentInfo[] getAssignmentByActInstId(String actInstId, WfAssignmentState state) throws WfException {
        return this.service.getAssignmentByActInstId(actInstId, state);
    }

    public void acceptAssignment(String assignmentId) throws WfException {
        this.service.acceptAssignment(assignmentId);
    }

    public void rejectAssignment(String assignmentId) throws WfException {
        this.service.rejectAssignment(assignmentId);
    }

    public void cancelAssignment(String assignmentId) throws WfException {
        this.service.cancelAssignment(assignmentId);
    }

    public void completeAssignment(String assignmentId) throws WfException {
        this.service.completeActivityInst(assignmentId);
    }

    public AssignmentInfo forwardAssignment(String assignmentId, String destUserId, String destUserName) throws WfException {
        return this.service.forwardAssignment(assignmentId, destUserId);
    }

    public ActivityInstInfo[] getActInstMetaArrayByProcInstId(String procInstId) throws WfException {
        return this.service.getActInstMetaArrayByProcInstId(procInstId);
    }

    public ActivityInstInfo[] getActInstMetaArrayByProcInstIdAndActInstState(String procInstId, String actInstState) throws WfException {
        return this.service.getActInstMetaArrayByProcInstIdAndActInstState(procInstId, actInstState);
    }

    public ActivityInstInfo redoActInst(String actInstId) throws WfException {
        return this.service.redoActInst(actInstId);
    }

    public ActivityInstInfo rollbackActInst(String actInstId) throws WfException {
        return this.service.rollbackActInst(actInstId);
    }

    public void setProviderLoader(String classFullName) throws WfException {
        this.service.setParticipantProvider(classFullName);
    }

    public ProcessInstInfo[] getAllProcessInstances() throws WfException {
        return this.service.getAllProcessInstances();
    }

    public ProcessInstInfo[] getProcessInstancesByProcDefId(String procDefId) throws WfException {
        return this.service.getProcessInstancesByProcDefId(procDefId);
    }

    public ProcessDefInfo getProcessDefInfo(String procDefId) throws WfException {
        return this.service.getProcessDefInfo(procDefId);
    }

    public Map getProcessContext(String procInstId) throws WfException {
        return this.service.getProcessContext(procInstId);
    }

    public FunctionDef[] getStartupFuncDef(ProcessDef procDef) throws WfException {
        ArrayList funcList = new ArrayList();
        this.getStartupFuncDef(funcList, procDef);
        FunctionDef[] funcDefArray = new FunctionDef[funcList.size()];
        funcList.toArray(funcDefArray);
        return funcDefArray;
    }

    private void getStartupFuncDef(Collection funcDefCol, ProcessDef procDef) throws WfException {
        ActivityCollection actCol = procDef.getStartupActivities();
        if (actCol.size() > 0) {
            // empty if block
        }
        for (int i = 0; i < actCol.size(); ++i) {
            ActivityDef actDef = actCol.get(i);
            if (actDef instanceof ManpowerActivityDef) {
                ManpowerActivityDef manpowerDef = (ManpowerActivityDef)actDef;
                ApplicationDef appDef = manpowerDef.getRelatedApplication();
                FunctionDef funcDef = appDef.getFunction();
                funcDefCol.add(funcDef);
                continue;
            }
            if (!(actDef instanceof SubflowActivityDef)) continue;
            SubflowActivityDef subflowDef = (SubflowActivityDef)actDef;
            ProcessDefInfo processDefInfo = this.getProcessDefInfo(subflowDef.getSubflowId());
        }
    }

    public Collection getAllProcessUserRef(String sfactory, String surl, String suser, String spassword) throws WfException {
        try {
            return this.service.getAllProcessUserRef();
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public Collection getAllProcessUserRefByProc(String ProcessID, String sfactory, String surl, String suser, String spassword) throws WfException {
        try {
            return this.service.getAllProcessUserRefByProc(ProcessID);
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public Collection getAllProcessUserRefByUser(String UserID, String sfactory, String surl, String suser, String spassword) throws WfException {
        try {
            return this.service.getAllProcessUserRefByUser(UserID);
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public boolean updateProcessParticipantToUserRef(ProcessDef procdef) throws WfException {
        return this.service.updateProcessParticipantToUserRef(procdef);
    }

    public ProcessDefInfo[] getProcDefArrayDistinctByUserID(String userID) throws WfException {
        return this.service.getProcDefArrayDistinctByUserID(userID);
    }

    public void createUI(String assignmentID, Object owner) throws UIException, WfException {
        this.invokeUI(assignmentID, owner, true);
    }

    public void createUI(String assignmentID, Object owner, boolean isPerm) throws UIException, WfException {
        this.invokeUI(new String[]{assignmentID}, owner, true, isPerm);
    }

    public void invokeUI(String assignmentID, Object owner) throws UIException, WfException {
        this.invokeUI(assignmentID, owner, false);
    }

    public boolean invokeUI(String[] assignmentIds, Object owner) throws UIException, WfException {
        return this.invokeUI(assignmentIds, owner, false, false);
    }

    public void invokeUI(String assignmentID, Object owner, boolean isAddnew) throws UIException, WfException {
        this.invokeUI(new String[]{assignmentID}, owner, isAddnew, false);
    }

    public boolean invokeUI(String[] assignmentIds, Object owner, boolean isAddnew, boolean isPerm) throws UIException, WfException {
        if (owner == null) {
            throw new WfException("EASWfServiceClient.invokeUI owner is null");
        }
        if (assignmentIds == null || assignmentIds.length == 0) {
            throw new WfException("EASWfServiceClient.invokeUI assignmentID is null");
        }
        EASWfServiceData data = null;
        try {
            Method method = IEnactmentService.class.getMethod("getEASWfServiceData", String[].class, Boolean.TYPE);
            data = (EASWfServiceData)ActionCache.get((Object)MultiParamKey.create(IEnactmentService.class, (Method)method, (Object[])new Object[]{assignmentIds, false}).toString());
        }
        catch (Exception e) {
            data = null;
        }
        if (data == null) {
            data = this.service.getEASWfServiceData(assignmentIds, isPerm);
        }
        AssignmentInfo assInfo = data.getAssignmentInfo();
        Map extendedAttrFromActDef = data.getExtendedAttribute();
        if (extendedAttrFromActDef.containsKey("attachMode") && "0".equals(extendedAttrFromActDef.get("attachMode"))) {
            String attachMode = MultiApproveUtil.getMultiapproveAttachmentPermissionMode((String)assignmentIds[0]);
            extendedAttrFromActDef.put("attachMode", attachMode);
        }
        String[] bizObjectID = assInfo.getBizObjectIdArray();
        String bizPackgeName = assInfo.getBizPackage();
        String bizFunName = assInfo.getBizFunction();
        String bizOperation = assInfo.getBizOperation();
        String userID = assInfo.getUserId();
        if (isPerm && !data.isPermission()) {
            throw new NoOperationRithtException("User:\"" + userID + "\" don't have ritht on operation:\"" + bizPackgeName + "." + bizFunName + "." + bizOperation + "\"!");
        }
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        ContextManager.getContext().put((Object)UICONTEXT_USERID, (Object)userID);
        this.appendMap(extendedAttrFromActDef, uiContext);
        this.appendMap(data.getAssignmentArgs(), uiContext);
        this.replaceUICfgSolutionKey(uiContext);
        CoreUIObject ownerUI = null;
        if (owner != null && owner instanceof CoreUIObject) {
            ownerUI = (CoreUIObject)owner;
        } else if (owner != null && owner instanceof Frame) {
            uiContext.put("portalOpenGUI", "true");
        }
        MetaDataPK metaPK = new MetaDataPK(bizPackgeName, bizFunName);
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)metaPK);
        OperationInfo oper = this.getOperation(bizOperation, function);
        if (oper == null || oper.getUiActionRef() == null) {
            throw new WfException("EASWfServiceClient.invokeUI,Operation or UIActionRef is null");
        }
        BOSUuid[] boId = null;
        if (bizObjectID != null && bizObjectID[0] != null && !bizObjectID[0].trim().equals("")) {
            boId = new BOSUuid[bizObjectID.length];
            for (int i = 0; i < bizObjectID.length; ++i) {
                boId[i] = BOSUuid.read((String)bizObjectID[i]);
            }
            uiContext.put("ID", boId[0]);
            RealModeIDList list = new RealModeIDList();
            list.add(boId[0].toString());
            uiContext.put(UICONTEXT_IDLIST, list);
        }
        if (assignmentIds.length > 1) {
            AssignmentInfo[] assignmentInfos = data.getAssignmentInfos();
            ArrayList actualAssginInfoList = this.filteSameAssignmentsByAssign(assignmentInfos, assInfo);
            if (actualAssginInfoList.size() < assignmentInfos.length) {
                int result;
                String billId = assInfo.getBizObjectIds();
                if (billId != null && billId.length() == 0) {
                    billId = null;
                }
                String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Wf_MiscAssign");
                if (!filterWfAssignmentsByBOSType) {
                    try {
                        filterWfAssignmentsByBOSType = "true".equals(ParamManager.getParamValue(null, null, (String)"WfFilterAssignmentsByBOSType"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (filterWfAssignmentsByBOSType && billId != null) {
                    msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"74_EASWfServiceClient");
                }
                if ((result = MsgBox.showConfirm2((Component)ownerUI, (String)msg)) == 2) {
                    return false;
                }
            }
            ArrayList<String> actualBillIdList = new ArrayList<String>();
            for (int i = 0; i < actualAssginInfoList.size(); ++i) {
                actualBillIdList.add(((AssignmentInfo)actualAssginInfoList.get(i)).getBizObjectIds());
            }
            if (actualAssginInfoList.size() == 1) {
                String boIds = ((AssignmentInfo)actualAssginInfoList.get(0)).getBizObjectIds();
                if (boIds == null) {
                    boIds = "";
                    log.warn((Object)"EASWfServiceClient.invokeUI boIds is null!");
                }
                String actualBillId = boIds;
                if (boIds.indexOf(",") > 0) {
                    for (int i = 0; i < boId.length; ++i) {
                        if (boIds.indexOf(boId[i].toString()) <= 0) continue;
                        actualBillId = boId[i].toString();
                    }
                }
                uiContext.put("ID", actualBillId);
                RealModeIDList list = new RealModeIDList();
                list.add(actualBillId);
                uiContext.put(UICONTEXT_IDLIST, list);
                uiContext.put(UICONTEXT_WFASSIGNMENTINFO, (AssignmentInfo)actualAssginInfoList.get(0));
            } else {
                String[] actualBillIds = new String[actualBillIdList.size()];
                AssignmentInfo[] actualAssignInfos = new AssignmentInfo[actualAssginInfoList.size()];
                actualBillIdList.toArray(actualBillIds);
                actualAssginInfoList.toArray(actualAssignInfos);
                if ("ManualDecisionUIFunction".equalsIgnoreCase(actualAssignInfos[0].getBizFunction())) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.ERR_WF_CanNotHandleAssign"));
                    return false;
                }
                uiContext.put(UICONTEXT_IDLIST, actualBillIds);
                uiContext.put(UICONTEXT_WFASSIGNMENTINFOS, actualAssignInfos);
            }
        } else {
            uiContext.put(UICONTEXT_WFASSIGNMENTINFO, assInfo);
        }
        try {
            uiContext.put(UICONTEXT_OWNER, owner);
            uiContext.put(UICONTEXT_OPEARTIONINFO, oper);
            uiContext.put(UICONTEXT_ISFROMWORKFLOW, new Boolean(true));
            uiContext.put(UICONTEXT_FUNCTIONOBJECTINFO, function);
            uiContext.put(UICONTEXT_WFACTINSTINFO, data.getActInstInfo());
            if (ownerUI != null && ownerUI.getUIContext().get(UICONTEXT_USERINFO) != null) {
                uiContext.put(UICONTEXT_USERINFO, ownerUI.getUIContext().get(UICONTEXT_USERINFO));
            }
            this.copyOwnerUIContext(uiContext, ownerUI);
            uiContext.remove("DATAOBJECTS");
            uiContext.remove("DATAOBJECTNAME");
            uiContext.put("UIClassParam", this.getAssignStr(assignmentIds));
            IUIWindow window = EASWfServiceClient.remoteInvokeUI((IMetaDataPK)metaPK, bizOperation, new HashMap(), uiContext, isAddnew, (String)uiContext.get("customUIStatus"));
            if (window != null && window instanceof Window) {
                ((Window)window).addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent event) {
                        IUIObject[] uiObjects = UIFrameUtil.findUIObject((String)MessageCenterUI.class.getName());
                        if (uiObjects != null && uiObjects.length > 0) {
                            MessageServiceProvider.delayRefresh((Object)uiObjects[0]);
                        }
                    }
                });
            }
            return false;
        }
        catch (UIException uiEx) {
            throw uiEx;
        }
        catch (BOSException bosEx) {
            log.error((Object)bosEx);
            throw new WfException("EASWfServiceClient.invokeUI error: " + (Object)((Object)bosEx));
        }
    }

    private Object getAssignStr(String[] assignmentIds) {
        String str = "";
        for (String a : assignmentIds) {
            str = str + a;
        }
        return str;
    }

    private void appendMap(Map srcMap, HashMap uiContext) {
        if (uiContext != null && srcMap != null && srcMap.size() > 0) {
            for (Map.Entry entry : srcMap.entrySet()) {
                uiContext.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void replaceUICfgSolutionKey(Map context) {
        Object obj;
        if (context.containsKey("UIConfSolutionID") && (obj = context.get("UIConfSolutionID")) != null) {
            context.remove("UIConfSolutionID");
            context.put("ConfigureID", obj);
        }
    }

    private ArrayList filteSameAssignmentsByAssign(AssignmentInfo[] assignments, AssignmentInfo assInfo) {
        ArrayList<AssignmentInfo> actualAssignmentInfos = new ArrayList<AssignmentInfo>();
        String billId = assInfo.getBizObjectIds();
        if (billId != null && billId.length() == 0) {
            billId = null;
        }
        if (!filterWfAssignmentsByBOSType) {
            try {
                filterWfAssignmentsByBOSType = "true".equals(ParamManager.getParamValue(null, null, (String)"WfFilterAssignmentsByBOSType"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!filterWfAssignmentsByBOSType || billId == null) {
            String procHash = assInfo.getProcDefHashValue();
            String actDef = assInfo.getActDefId();
            for (int i = 0; i < assignments.length; ++i) {
                if (!procHash.equals(assignments[i].getProcDefHashValue()) || !actDef.equals(assignments[i].getActDefId())) continue;
                actualAssignmentInfos.add(assignments[i]);
            }
        } else {
            BOSObjectType type = BOSUuid.read((String)billId).getType();
            for (int i = 0; i < assignments.length; ++i) {
                billId = assignments[i].getBizObjectIds();
                if (billId == null || billId.length() == 0 || !type.equals((Object)BOSUuid.read((String)billId).getType())) continue;
                actualAssignmentInfos.add(assignments[i]);
            }
        }
        return actualAssignmentInfos;
    }

    private OperationInfo getOperation(String bizOperation, FunctionObjectInfo function) {
        OperationInfo oper = null;
        OperationCollection operCol = function.getOperation();
        for (int i = 0; i < operCol.size(); ++i) {
            if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)bizOperation)) continue;
            oper = operCol.get(i);
            break;
        }
        return oper;
    }

    private void copyOwnerUIContext(HashMap uiContext, CoreUIObject ownerUI) {
        Map ownerContext;
        if (uiContext != null && ownerUI != null && (ownerContext = ownerUI.getUIContext()) != null) {
            for (Map.Entry entry : ownerContext.entrySet()) {
                if (uiContext.containsKey(entry.getKey())) continue;
                uiContext.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static IUIWindow remoteInvokeUI(IMetaDataPK pk, String operationName, Map dataObjects, Map uiContext, boolean isAddnew, String cusStatus) throws UIException, BOSException {
        return EASWfServiceClient.remoteInvokeUI(pk, operationName, null, dataObjects, uiContext, isAddnew, cusStatus);
    }

    public static IUIWindow remoteInvokeUI(IMetaDataPK pk, String operationName, String uiTypeName, Map dataObjects, Map uiContext, boolean isAddNew, String cusStatus) throws UIException, BOSException {
        String isPortalOpenGUI;
        String status;
        if (pk == null) {
            throw new IllegalArgumentException("EASWfServiceClient.remoteInvokeUI, Parameters IMetaDataPK is null!");
        }
        FunctionObjectInfo function = (FunctionObjectInfo)uiContext.get(UICONTEXT_FUNCTIONOBJECTINFO);
        OperationInfo operation = (OperationInfo)uiContext.get(UICONTEXT_OPEARTIONINFO);
        String canResize = "true";
        if (isAddNew) {
            status = "ADDNEW";
        } else if ("com.kingdee.eas.base.multiapprove.client".equalsIgnoreCase(pk.getPackage()) && "MultiApproveUIFunction".equalsIgnoreCase(pk.getName())) {
            status = operation.getUiActionRef().getUIStatus();
            if (!StringUtils.isEmpty((String)cusStatus)) {
                uiContext.put("customBizUIStatus", cusStatus);
            }
        } else {
            status = !StringUtils.isEmpty((String)cusStatus) ? cusStatus : operation.getUiActionRef().getUIStatus();
        }
        UIObjectInfo ui = operation.getUiActionRef().getUIObjectRef();
        String uiClass = ui.getReleasePackage() + "." + ui.getReleaseClass();
        if (uiContext.get(UICONTEXT_WFASSIGNMENTINFOS) != null) {
            uiClass = function.getFullName().equalsIgnoreCase(FUNCTIONNAME_MULTIAPPROVE) ? UINAME_MULTIAPPROVELIST : UINAME_MULTIASSIGNMENT;
        }
        String showBillUI = (String)uiContext.get("ShowBillUI");
        if (uiContext.get(UICONTEXT_ISMANUALDICISIONNODE) != null && (showBillUI == null || showBillUI.equalsIgnoreCase("false"))) {
            uiClass = UINAME_MANUALDECISIONBILLUI;
            canResize = "false";
        }
        uiTypeName = "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        String name = (String)uiContext.get("MultiapproveUIConf");
        if (uiClass.equalsIgnoreCase(UINAME_MULTIAPPROVEUI) && name != null && !StringUtils.isEmpty((String)name)) {
            uiClass = name;
        }
        IUIWindow window = null;
        uiContext.put("canResize", canResize);
        window = !StringUtils.isEmpty((String)uiTypeName) ? UIFactory.createUIFactory((String)uiTypeName).create(uiClass, uiContext, dataObjects, status, 95) : UIFactory.createUIFactory().create(uiClass, uiContext, dataObjects, status, 95);
        String string = isPortalOpenGUI = uiContext.get("portalOpenGUI") != null ? uiContext.get("portalOpenGUI").toString() : "";
        if (window instanceof UINewFrame && isPortalOpenGUI.equals("true")) {
            UINewFrame uiNewFrame = (UINewFrame)window;
            uiNewFrame.setAlwaysOnTop(true);
            uiNewFrame.show();
            uiNewFrame.setAlwaysOnTop(false);
            return uiNewFrame;
        }
        try {
            Class<?> msgHandlerCls = EASWfServiceClient.class.getClassLoader().loadClass("com.kingdee.bos.apploader.message.MessageHandler");
            if (msgHandlerCls != null) {
                Method sendCloseDivMsg = msgHandlerCls.getMethod("sendCloseDivMsg", new Class[0]);
                sendCloseDivMsg.invoke(null, null);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        window.show();
        return window;
    }

    public ProcessDefInfo updateProcessSchedule(String procDefId, String scheduleXml) throws WfException {
        return this.service.updateProcessSchedule(procDefId, scheduleXml);
    }

    public void setProcessDefEnable(String procDefId, boolean enable) throws WfException {
        this.service.setProcessDefEnable(procDefId, enable);
    }

    public String createJobProcessInst(String procDefId, Map jobContext, String initiatorId) throws WfException {
        return this.service.createJobProcessInst(procDefId, jobContext, initiatorId);
    }

    public String createJobProcessDef(String name, FunctionObjectInfo func, OperationInfo operation, Map jobContext, String scheduale, Locale locale) throws WfException {
        return this.service.createJobProcessDef(name, func, operation, jobContext, scheduale, locale);
    }

    public String[] getPassedTransDefArray(String procInstId) throws WfException {
        return this.service.getPassedTransDefArray(procInstId);
    }

    private boolean isLegalUuid(String id) {
        if (!StringUtils.isEmpty((String)id)) {
            try {
                BOSUuid.read((String)id);
                return true;
            }
            catch (Throwable t) {
                log.error((Object)t.getMessage(), t);
            }
        }
        return false;
    }

    public boolean canAccept(String assignId) throws WfException {
        if (!this.isLegalUuid(assignId)) {
            log.error((Object)"Assignment ID is invalide");
            return false;
        }
        AssignmentInfo assign = this.service.getAssignmentById(assignId);
        if (assign == null) {
            log.error((Object)"Can not get assignment by assignment ID");
            return false;
        }
        int state = assign.getState().getValue();
        if (state != 1) {
            log.error((Object)"assignment's state is not fit");
            return false;
        }
        return true;
    }

    public boolean canDeal(String assignId) throws WfException {
        if (!this.isLegalUuid(assignId)) {
            log.error((Object)"Assignment ID is invalide");
            return false;
        }
        AssignmentInfo assign = this.service.getAssignmentById(assignId);
        if (assign == null) {
            log.error((Object)"Can not get assignment by assignment ID");
            return false;
        }
        int state = assign.getState().getValue();
        if (state != 2) {
            log.error((Object)"assignment's state is not fit");
            return false;
        }
        return true;
    }

    public boolean canForward(String assignId) throws WfException {
        if (!this.isLegalUuid(assignId)) {
            log.error((Object)"Assignment ID is invalide");
            return false;
        }
        AssignmentInfo assign = this.service.getAssignmentById(assignId);
        if (assign == null) {
            log.error((Object)"Can not get assignment by assignment ID");
            return false;
        }
        int state = assign.getState().getValue();
        if (state != 2) {
            log.error((Object)"assignment's state is not fit");
            return false;
        }
        return true;
    }

    public boolean canReject(String assignId) throws WfException {
        if (!this.isLegalUuid(assignId)) {
            log.error((Object)"Assignment ID is invalide");
            return false;
        }
        AssignmentInfo assign = this.service.getAssignmentById(assignId);
        if (assign == null) {
            log.error((Object)"Can not get assignment by assignment ID");
            return false;
        }
        int state = assign.getState().getValue();
        if (state != 2) {
            log.error((Object)"assignment's state is not fit");
            return false;
        }
        return true;
    }

    public boolean canRollBack(String assignId) throws WfException {
        if (!this.isLegalUuid(assignId)) {
            log.error((Object)"Assignment ID is invalide");
            return false;
        }
        AssignmentInfo assign = this.service.getAssignmentById(assignId);
        if (assign == null) {
            log.error((Object)"Can not get assignment by assignment ID");
            return false;
        }
        int state = assign.getState().getValue();
        if (state != 16) {
            log.error((Object)"assignment's state is not fit");
            return false;
        }
        return true;
    }

    public SubmitAssignResult virtualSubmitAssignment(String assignmentID) throws WfException {
        return this.service.virtualSubmitAssignment(assignmentID);
    }

    public String getProcInstLog(String procInstId) throws WfException {
        return this.service.getProcInstLog(procInstId);
    }

    public void reassignToPerson(String actInstId, String[] userIdArray) throws WfException {
        this.service.reassignToPerson(actInstId, userIdArray);
    }

    public IEnactmentService getService() {
        return this.service;
    }

    public Map getActionState(Map uiContext, IObjectPK voPK, IObjectPK userInfoPK, IMetaDataPK uiPK, Map actionSet) throws WfException {
        AssignmentInfo[] assignments = new AssignmentInfo[]{};
        HashMap<String, ActionState> rtnActions = new HashMap<String, ActionState>();
        if (actionSet == null || voPK == null || userInfoPK == null || uiPK == null) {
            return rtnActions;
        }
        ActionState disActionState = new ActionState();
        disActionState.setState(0);
        if (uiContext != null && uiContext.get(UICONTEXT_WFASSIGNMENTINFO) != null) {
            assignments = new AssignmentInfo[]{(AssignmentInfo)uiContext.get(UICONTEXT_WFASSIGNMENTINFO)};
        } else {
            ProcessInstInfo[] procInstInfos = this.service.getProcessInstanceByHoldedObjectId(voPK.toString());
            if (procInstInfos != null && procInstInfos.length > 0) {
                try {
                    assignments = this.service.checkAssignmentInfo(voPK.toString(), userInfoPK.toString(), uiPK, null);
                }
                catch (MatchAssignmentException ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (assignments != null && assignments.length > 0 && assignments[0] != null) {
            Iterator it = actionSet.keySet().iterator();
            String uiActionName = "";
            while (it.hasNext()) {
                uiActionName = it.next().toString();
                boolean isEnable = false;
                for (int i = 0; i < assignments.length; ++i) {
                    if (!uiActionName.equalsIgnoreCase(assignments[i].getBizOperation())) continue;
                    isEnable = true;
                    break;
                }
                if (isEnable) continue;
                ActionState state = (ActionState)actionSet.get(uiActionName);
                String actionInstName = state.getActionName();
                rtnActions.put(actionInstName, disActionState);
            }
        }
        return rtnActions;
    }

    private void init() throws BOSException {
        this.service = EnactmentServiceFactory.createRemoteEnactService();
    }
}

