/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.exception.CannotForwardException;
import com.kingdee.bos.workflow.exception.ForbidForwardException;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.MultiApproveException;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.workflow.AbstractMultiAssignmentUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.framework.client.workflow.IMultiAssignmentUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class MultiAssignmentUI
extends AbstractMultiAssignmentUI
implements IMultiAssignmentUI {
    private static final long serialVersionUID = 1974121158221204772L;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.framework.client.workflow.MultiAssignmentUI");
    private final String LISTUI_CLASSNAME = "listUI";
    private final String CTX_ASSIGNMENTS = "WfAssignmentInfos";
    private BOSObjectType billObjectType;
    private EntityObjectInfo billObjectInfo;
    private AssignmentInfo[] assignmentInfos;
    private String[] billIds;
    private ListUI billListUI;
    private ItemAction currentAction;
    private KDWorkButton currentButton;
    private boolean isNewWindowShow;
    private EASWfServiceClient workflowClient;
    private static final String RES = "com.kingdee.eas.base.message.client.MessageCenter";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        String billListUI;
        super.onLoad();
        this.isNewWindowShow = true;
        HashMap uiContext = (HashMap)this.getUIContext();
        if (uiContext == null) {
            throw new IllegalArgumentException("MultiAssignmentUI onLoad. uicontext is null!");
        }
        if (uiContext.get("WfAssignmentInfos") != null) {
            this.assignmentInfos = (AssignmentInfo[])uiContext.get("WfAssignmentInfos");
        }
        if (this.assignmentInfos == null || this.assignmentInfos.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.ERR_WF_AssignIsNull"));
            this.abort();
        }
        this.billIds = this.getBillIdByAssign(this.assignmentInfos);
        if (this.billIds == null || this.billIds.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.ERR_WF_BillIsNull"));
            this.abort();
        }
        boolean allIsEmpty = false;
        for (int i = 0; i < this.billIds.length; ++i) {
            if (!StringUtils.isEmpty((String)this.billIds[i])) continue;
            allIsEmpty = true;
            break;
        }
        if (allIsEmpty) {
            String resClassName = "com.kingdee.eas.framework.client.workflow.MultiAssignmentUIProp";
            String msg = EASResource.getString((String)resClassName, (String)"NOT_SUPPORT");
            msg = StringUtils.cnulls((String)msg, (String)"NOT_SUPPORT");
            MsgBox.showError((String)msg);
            this.abort();
        }
        this.billIds = this.trimBillArray(this.billIds);
        if (this.billIds == null || this.billIds.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.ERR_WF_CanNotHandleAssign"));
            this.abort();
        }
        if (StringUtils.isEmpty((String)(billListUI = this.getEntityExtendProperty(this.billIds[0], "listUI")))) {
            String resClassName = "com.kingdee.eas.framework.client.workflow.MultiAssignmentUIProp";
            String msg = EASResource.getString((String)resClassName, (String)"NOT_SUPPORT");
            msg = StringUtils.cnulls((String)msg, (String)"NOT_SUPPORT");
            MsgBox.showError((String)msg);
            this.abort();
        }
        this.initBillListPanel(billListUI, this.billIds);
        this.initWorkButton();
        this.initAssignmentMsg(this.assignmentInfos);
    }

    private String[] trimBillArray(String[] oldIds) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (int i = 0; i < oldIds.length; ++i) {
            if (StringUtils.isEmpty((String)oldIds[i])) continue;
            retVal.add(oldIds[i]);
        }
        return retVal.toArray(new String[retVal.size()]);
    }

    private void initAssignmentMsg(AssignmentInfo[] assigns) {
        int assignmentCount = 0;
        if (assigns != null) {
            assignmentCount = assigns.length;
        }
        String assignMsg = this.kdlAssignmentMsg.getText();
        assignMsg = StringUtils.replace((String)assignMsg, (String)"{0}", (String)(assignmentCount + ""));
        this.kdlAssignmentMsg.setText(assignMsg);
    }

    private String[] getBillIdByAssign(AssignmentInfo[] assignments) {
        String[] billId = new String[assignments.length];
        for (int i = 0; i < assignments.length; ++i) {
            billId[i] = assignments[i].getBizObjectIds();
        }
        return billId;
    }

    private String getEntityExtendProperty(String billId, String propertyName) {
        if (billId == null || billId.length() <= 0) {
            String msg = "";
            throw new IllegalArgumentException(msg);
        }
        BOSUuid id = BOSUuid.read((String)billId);
        this.billObjectType = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.billObjectInfo = loader.getEntity(this.billObjectType);
        if (this.billObjectInfo == null) {
            throw new IllegalArgumentException("BillObject is null");
        }
        String propertyValue = this.billObjectInfo.getExtendedProperty(propertyName);
        return propertyValue;
    }

    private void initBillListPanel(String billListUIClassName, String[] billId) throws Exception {
        IUIObject ui = AbstractUIFactory.createUIObjectNoInit((String)billListUIClassName);
        if (ui instanceof ListUI) {
            this.billListUI = (ListUI)ui;
        } else {
            MsgBox.showWarning((String)(ui.getClass().getName() + EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"75_MultiAssignmentUI")));
            this.abort();
        }
        this.billListUI.getUIContext().put("IDList", billId);
        this.billListUI.getUIContext().put("parentFrame", this);
        this.billListUI.getUIContext().put("isLightWeight", "isLightWeight");
        this.billListUI.getUIContext().put("IsBatchDispose", new Boolean(true));
        this.billListUI.getUIContext().put("RequestModel", String.valueOf(0));
        this.billListUI.setIsNeedDefaultFilter(false);
        this.billListUI.onLoad();
        this.billListUI.getMainTable().getStyleAttributes().setLocked(true);
        this.billListUI.initLayout();
        this.kdpBillListUI.add((Component)((Object)this.billListUI), (Object)"Center");
        KDTable kdTable = this.billListUI.getMainTable();
        this.kdpBillListUI.putClientProperty((Object)"OriginalBounds", (Object)this.kdpBillListUI.getBounds());
        this.kdpBillListUI.setPreferredSize(new Dimension(this.kdpBillListUI.getWidth(), this.kdpBillListUI.getHeight()));
        this.kdpBillListUI.setLayout((LayoutManager)new KDLayout());
        this.kdpBillListUI.add((Component)((Object)this.billListUI), (Object)new KDLayout.Constraints(0, 0, this.kdpBillListUI.getWidth(), this.kdpBillListUI.getHeight(), 15));
        kdTable.checkParsed();
        kdTable.getDataRequestManager().setDataRequestMode(0);
        EventListener[] mouseListener = kdTable.getListeners(KDTMouseListener.class);
        for (int i = 0; i < mouseListener.length; ++i) {
            kdTable.removeKDTMouseListener((KDTMouseListener)mouseListener[i]);
        }
        kdTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    MultiAssignmentUI.this.billTable_tableSelected(e);
                }
                catch (Exception exc) {
                    MultiAssignmentUI.this.handUIException(exc);
                }
            }
        });
        this.billListUI.setSelectForTable(true);
        this.selectAllBill();
        String operation = this.assignmentInfos[0].getBizOperation();
        this.currentAction = null;
        this.currentButton = null;
        this.currentButton = this.getWorkButton(this.billListUI.getUIToolBar().getComponents(), operation);
        if (this.currentButton == null) {
            HashMap map = this.billListUI.getActionManager().getActionSet();
            ItemAction action = (ItemAction)map.get(operation);
            if (action == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.ERR_WF_CanNotHandleAssign"));
                this.abort();
            }
            this.currentButton = new KDWorkButton();
            if (action != null) {
                this.currentButton.setAction((Action)action);
                String name = (String)action.getValue("Name");
                this.btnHandleAssignment.setText(name);
                this.currentAction = action.getItemAction();
            }
        } else {
            this.currentAction = ((IItemAction)this.currentButton.getAction()).getItemAction();
            this.btnHandleAssignment.setText(this.currentButton.getText());
            this.btnHandleAssignment.setToolTipText(this.currentButton.getToolTipText());
            if (this.currentButton.getIcon() != null) {
                this.btnHandleAssignment.setIcon(this.currentButton.getIcon());
            }
        }
    }

    private void selectAllBill() {
        if (this.billListUI == null) {
            log.error((Object)"BillListUI is null.");
            return;
        }
        this.billListUI.getMainTable().getRow(0);
        int rowCount = this.billListUI.getMainTable().getRowCount() - 1;
        if (rowCount < 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.framework.client.workflow.MultiAssignmentUIProp", (String)"LOAD_BIZ_DATA_FAILED");
            msg = StringUtils.cnulls((String)msg, (String)"LOAD_BIZ_DATA_FAILED");
            MsgBox.showError((String)msg);
            this.abort();
        }
        this.billListUI.getMainTable().getSelectManager().select(0, 0, rowCount, 0, 2);
    }

    private KDWorkButton getWorkButton(Component[] comps, String operation) {
        KDWorkButton button = null;
        String actionName = null;
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Container && (button = this.getWorkButton(((Container)comps[i]).getComponents(), operation)) != null) {
                return button;
            }
            if (!(comps[i] instanceof KDWorkButton) || ((KDWorkButton)comps[i]).getAction() == null) continue;
            actionName = ((IItemAction)((KDWorkButton)comps[i]).getAction()).getItemAction().getClass().getName();
            if (!operation.equalsIgnoreCase(actionName = actionName.substring(actionName.indexOf("$") + 1, actionName.length()))) continue;
            return (KDWorkButton)comps[i];
        }
        return button;
    }

    protected ArrayList getBillListSelectedIdValues() {
        ArrayList<String> list = new ArrayList<String>();
        KDTSelectBlock selectBlock = null;
        int size = this.billListUI.getMainTable().getSelectManager().size();
        if (size == 0 || this.billListUI.getMainTable().getSelectManager().getActiveRowIndex() < 0) {
            return list;
        }
        if (size == 1 && this.billListUI.getMainTable().getSelectManager().get().getTop() == this.billListUI.getMainTable().getSelectManager().get().getBottom()) {
            int rowNum = this.billListUI.getMainTable().getSelectManager().get().getTop();
            ICell cell = this.billListUI.getMainTable().getRow(rowNum).getCell(this.getBillListUIKeyField());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            list.add(cell.getValue().toString());
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.billListUI.getMainTable().getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    String id;
                    ICell cell = this.billListUI.getMainTable().getRow(j).getCell(this.getBillListUIKeyField());
                    if (cell == null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                        SysUtil.abort();
                    }
                    if (list.contains(id = cell.getValue().toString())) continue;
                    list.add(id);
                }
            }
        }
        return list;
    }

    protected void billTable_tableSelected(KDTSelectEvent e) throws Exception {
        this.btnHandleAssignment.setEnabled(true);
        int index = e.getSelectBlock().getTop();
        if (this.billListUI.getMainTable() == null || this.billListUI.getMainTable().getRow(index) == null) {
            String msg = EASResource.getString((String)"com.kingdee.eas.framework.client.workflow.MultiAssignmentUIProp", (String)"LOAD_BIZ_DATA_FAILED");
            msg = StringUtils.cnulls((String)msg, (String)"LOAD_BIZ_DATA_FAILED");
            MsgBox.showError((String)msg);
        }
    }

    protected String getBillListUIKeyField() {
        if (this.billListUI == null) {
            return "id";
        }
        String rtnValue = this.billListUI.getKeyFieldNameForWF();
        if (StringUtils.isEmpty((String)rtnValue)) {
            rtnValue = "id";
        }
        return rtnValue;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnHandleAssignment.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnRefresh.setVisible(false);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnSelectAll.setEnabled(true);
        this.btnSelectAll.setVisible(true);
        this.btnDeliver.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
        this.btnDeliver.setEnabled(true);
        this.btnDeliver.setVisible(true);
    }

    @Override
    public void actionHandleAssignment_actionPerformed(ActionEvent e) throws Exception {
        this.currentButton.doClick();
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.selectAllBill();
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        this.showBillUI(this.getSelectedKeyValue());
    }

    protected String getSelectedKeyValue() {
        ArrayList selectedList = this.getBillListSelectedIdValues();
        if (selectedList != null && selectedList.size() > 0) {
            return selectedList.get(0).toString();
        }
        return null;
    }

    protected void showBillUI(String selectedBillId) {
        this.getUIContext().put("isNewWindow", Boolean.TRUE);
        this.getUIContext().put("Owner", this);
        IUIFactory uiFactory = null;
        try {
            String billUIStr = this.getEditUIName();
            IObjectValue dataObjectTmp = (IObjectValue)this.getDataObjects().get("billInfo");
            if (dataObjectTmp == null || !selectedBillId.equals(dataObjectTmp.get("id").toString())) {
                BOSUuid pk = BOSUuid.read((String)selectedBillId);
                IObjectValue dataObject = DynamicObjectFactory.getRemoteInstance().getValue(pk.getType(), (IObjectPK)new ObjectUuidPK(pk));
                if (dataObject == null) {
                    throw new EASBizException(MultiApproveException.DATAOBJECT_IS_NULL);
                }
                this.setDataObject("billInfo", dataObject);
                this.getUIContext().put("ID", selectedBillId);
            }
            RealModeIDList list = new RealModeIDList();
            list.add(selectedBillId);
            this.getUIContext().put("IDList", list);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow billWindow = uiFactory.create(billUIStr, this.getUIContext(), this.getDataObjects(), "FINDVIEW");
            if (this.isNewWindowShow) {
                billWindow.show();
            }
        }
        catch (Exception ex1) {
            log.error((Object)ex1);
        }
    }

    protected String getEditUIName() {
        if (this.billObjectInfo == null) {
            return "com.kingdee.eas.base.multiapprove.client.MultiApproveUI";
        }
        return this.billObjectInfo.getExtendedProperty("editUI");
    }

    protected void initStatusBar() {
        this.statusBar.getPart(0);
        this.statusBar.setVisible(true);
        this.statusBar.revalidate();
        this.statusBar.repaint();
    }

    @Override
    public void billUIChanged(CoreUIObject obj) {
    }

    @Override
    public void setNewWindowShow(boolean b) {
        this.isNewWindowShow = b;
    }

    @Override
    public boolean destroyWindow() {
        if (this.billListUI != null) {
            this.billListUI.destroyWindow();
        }
        return super.destroyWindow();
    }

    @Override
    public void actionDeliver_actionPerformed(ActionEvent e) throws Exception {
        EASWfServiceClient client = this.getWorkflowClient();
        IEnactmentService service = client.getService();
        String[] assignmentsIds = this.getAssigmentIdByAssign(this.assignmentInfos);
        if (assignmentsIds == null || assignmentsIds.length <= 0) {
            String msg = MultiApproveUtil.getMultiApproveResource((String)"ASSIGNMENT_IS_NULL");
            Component owner = (Component)this.getUIContext().get("Owner");
            MsgBox.showInfo((Component)owner, (String)msg);
            return;
        }
        boolean allowForward = true;
        allowForward = service.allowForward(assignmentsIds);
        if (!allowForward) {
            String msg = MultiApproveUtil.getMultiApproveResource((String)"DISABLEFORWARD");
            Component owner = (Component)this.getUIContext().get("Owner");
            MsgBox.showInfo((Component)owner, (String)msg);
            return;
        }
        try {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.base.message.client.MsgForwardOpinionUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            IUIObject opinionUi = uiWindow.getUIObject();
            Method isCanceledMethod = opinionUi.getClass().getMethod("isCanceled", null);
            Boolean isCanceled = (Boolean)isCanceledMethod.invoke((Object)opinionUi, null);
            if (!isCanceled.booleanValue()) {
                Method getMsgOpinionMethod = opinionUi.getClass().getMethod("getMsgOpinon", null);
                Map opinon = (Map)getMsgOpinionMethod.invoke((Object)opinionUi, null);
                Method getUserIdMethod = opinionUi.getClass().getMethod("getUserID", null);
                String userId = (String)getUserIdMethod.invoke((Object)opinionUi, null);
                MultiApproveUtil.forwardAssignmentsWithOpinion((String[])assignmentsIds, (String)userId, (Map)opinon);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"deliverTaskSucceed"));
            }
        }
        catch (CannotForwardException ex) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"canNotDeliverEndFlow"));
        }
        catch (ForbidForwardException ef) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"flowForbidDeliver"));
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"deliverTaskFail"));
        }
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
        }
        return this.workflowClient;
    }

    private String[] getAssigmentIdByAssign(AssignmentInfo[] assignments) {
        ArrayList<String> assignIds = new ArrayList<String>();
        ArrayList billIdSelectList = this.getBillListSelectedIdValues();
        for (int i = 0; i < assignments.length; ++i) {
            String billID = assignments[i].getBizObjectIds();
            if (!billIdSelectList.contains(billID)) continue;
            assignIds.add(assignments[i].getAssignmentId());
        }
        return assignIds.toArray(new String[0]);
    }
}

