/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import java.io.Serializable;

public class UIActionHelper {
    protected final IUIObject uiObject;
    protected final IUIActionPostman postman;

    public UIActionHelper() {
        this(null, true);
    }

    public UIActionHelper(boolean isPrepare) {
        this(null, isPrepare);
    }

    public UIActionHelper(IUIObject object, boolean isPrepare) {
        this.uiObject = object;
        this.postman = this.createUIHanlderPostman();
        this.postman.setAvailabe(isPrepare);
    }

    private IUIActionPostman createUIHanlderPostman() {
        IUIActionPostman postman = UIActionPostman.getInstance(this.uiObject);
        RequestContext requestContext = new RequestContext();
        postman.setRequestContext((Serializable)requestContext);
        return postman;
    }

    protected void prepareRequestContext(RequestContext requestContext) {
    }

    public final void callHandler() throws Exception {
        this.postman.callHandler();
    }

    private void callHandler(IActionCallBack callBack) throws Exception {
        if (this.postman.isAvailabe()) {
            RequestContext requestContext = (RequestContext)this.postman.getRequestContext();
            callBack.prepareRequestContext(requestContext);
            this.postman.callHandler();
        }
    }

    public final Object execute(IActionCallBack callBack) throws Exception {
        this.callHandler(callBack);
        return callBack.execute();
    }

    public static interface IActionCallBack {
        public Object execute() throws Exception;

        public void prepareRequestContext(RequestContext var1) throws Exception;
    }
}

