/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.config.ConfigServiceFactory;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.DownloadList;
import com.kingdee.bos.metadata.configure.IConfigMDDownloader;
import com.kingdee.bos.metadata.configure.MetadataStoreUtil;
import com.kingdee.bos.metadata.configure.UpdateDoc;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.metadata.util.ZipFileUtils;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.ILoginListener;
import com.kingdee.eas.common.client.ILogoutListener;
import com.kingdee.eas.common.client.LoginEvent;
import com.kingdee.eas.common.client.LogoutEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.jdom2.Document;

public class ConfigServiceInitializerListener
implements ILoginListener,
ILogoutListener {
    private static Logger logger = Logger.getLogger(ConfigServiceInitializerListener.class);

    public void logined(LoginEvent e) throws BOSException, EASBizException {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String eashome = System.getProperty("EAS_HOME");
                if (eashome == null) {
                    eashome = System.getProperty("eashome.path");
                }
                return System.setProperty("BOS_HOME", eashome);
            }
        });
        ConfigServiceFactory.initClientConfigService();
        this.downloadConfigMetas();
    }

    private DownloadList getDownloadConfigMetasFromCache() {
        Object downLoadList = null;
        try {
            Class<?> c = Class.forName("com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil");
            Method m = c.getMethod("downloadConfigMetas", new Class[0]);
            downLoadList = m.invoke(c, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (downLoadList != null && downLoadList instanceof DownloadList) {
            return (DownloadList)downLoadList;
        }
        return null;
    }

    private void cacheDownloadConfigMetas(DownloadList downLoadList) {
        try {
            Class<?> c = Class.forName("com.kingdee.eas.base.uiframe.client.LoginParamCacheUtil");
            Method m = c.getMethod("cacheParam", String.class, String.class, Object.class);
            if (downLoadList == null) {
                downLoadList = new DownloadList(new UpdateDoc[0], new String[0], 0L);
            }
            m.invoke(c, "downloadConfigMetas", null, downLoadList);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void downloadConfigMetas() throws BOSException {
        Context ctx = ConfigMDUtil.getContextFromEnv();
        ConfigureResourceLoader loader = ConfigureResourceLoader.getInstance((Context)ctx);
        HashMap<String, String> pkToSizeTime = new HashMap<String, String>();
        File configureJar = new File(loader.getConfigureJar());
        DownloadList mdl = this.getDownloadConfigMetasFromCache();
        if (mdl == null) {
            if (configureJar.exists()) {
                try {
                    JarFile jf = new JarFile(configureJar);
                    Enumeration<JarEntry> enume = jf.entries();
                    while (enume.hasMoreElements()) {
                        String name;
                        JarEntry entry = enume.nextElement();
                        if (entry.isDirectory() || !MetadataStoreUtil.acceptSuffix((String)(name = entry.getName()))) continue;
                        String sizeTime = entry.getSize() + "_" + entry.getTime();
                        pkToSizeTime.put(name, sizeTime);
                    }
                    jf.close();
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            } else {
                pkToSizeTime = null;
            }
            IConfigMDDownloader md = (IConfigMDDownloader)RPCEngineFactory.getEngine((String)ORMRPCServiceLocator.getCurrentServiceURL()).createObject("com.kingdee.bos.metadata.configure.ConfigMDDownloader", IConfigMDDownloader.class);
            mdl = md.download(ctx.getAIS(), pkToSizeTime);
            this.cacheDownloadConfigMetas(mdl);
        }
        if (mdl == null) {
            return;
        }
        UpdateDoc[] mds = mdl.getUpdates();
        String[] dls = mdl.getDeletes();
        if (mds.length > 0 || dls != null && dls.length > 0) {
            File tempDir = new File(configureJar.getParent() + "/temp2/");
            if (tempDir.exists()) {
                FileUtil.deleteDir((File)tempDir);
            }
            try {
                long time;
                if (configureJar.exists()) {
                    ZipFileUtils.unJarFile((String)configureJar.getPath(), (String)tempDir.getPath());
                }
                if (dls != null && dls.length > 0) {
                    for (int i = 0; i < dls.length; ++i) {
                        new File(tempDir, dls[i]).delete();
                    }
                }
                if (mds.length > 0) {
                    for (int i = 0; i < mds.length; ++i) {
                        File out = new File(tempDir, mds[i].getPk());
                        if (!out.getParentFile().exists()) {
                            out.getParentFile().mkdirs();
                        }
                        FileOutputStream os = new FileOutputStream(out);
                        XmlUtils.output((Document)mds[i].getDoc(), (OutputStream)os);
                        ((OutputStream)os).close();
                        String sizeTime = mds[i].getsizeTime();
                        String time2 = sizeTime.substring(sizeTime.indexOf(95) + 1);
                        out.setLastModified(Long.parseLong(time2));
                    }
                }
                if ((time = mdl.getTime()) == 0L) {
                    time = System.currentTimeMillis();
                }
                MetadataStoreUtil.zip((String)configureJar.getPath(), null, (String)tempDir.getPath(), (long)time);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                FileUtil.deleteDir((File)tempDir);
            }
        }
    }

    public void logout(LogoutEvent e) throws BOSException, EASBizException {
        ConfigServiceFactory.getConfigService().reset();
    }
}

