/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ConfigControllerFactory;
import com.kingdee.util.StringUtils;
import java.util.HashMap;

public final class ConfigServiceUtils {
    private static HashMap cachedCongfigData = new HashMap();
    private static String oldSessionId = null;

    public static String getUserConfigData(String key) {
        try {
            String newSessionId = SysContext.getSysContext().getSessionID();
            if (StringUtils.isEmpty((String)oldSessionId) || !newSessionId.equals(oldSessionId)) {
                cachedCongfigData.clear();
            }
            oldSessionId = newSessionId;
            Object obj = cachedCongfigData.get(key);
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return null;
                }
                return obj.toString();
            }
            String configStr = ConfigControllerFactory.getRemoteInstance().getUserConfigData(key);
            if (configStr == null) {
                cachedCongfigData.put(key, Boolean.FALSE);
            } else {
                cachedCongfigData.put(key, configStr);
            }
            return configStr;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getUserConfigData(String key, CoreUI ui) {
        try {
            Object obj;
            String newSessionId = SysContext.getSysContext().getSessionID();
            if (StringUtils.isEmpty((String)oldSessionId) || !newSessionId.equals(oldSessionId)) {
                cachedCongfigData.clear();
            }
            oldSessionId = newSessionId;
            String newKey = key;
            if (ui != null) {
                newKey = newKey + ui.getClass().getName();
            }
            if ((obj = cachedCongfigData.get(newKey)) != null) {
                if (obj instanceof Boolean) {
                    return null;
                }
                return obj.toString();
            }
            String configStr = ConfigControllerFactory.getRemoteInstance().getUserConfigData(key, ui.getMetaDataPK().getFullName());
            if (configStr == null) {
                cachedCongfigData.put(newKey, Boolean.FALSE);
            } else {
                cachedCongfigData.put(newKey, configStr);
            }
            return configStr;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveUserConfigData(String key, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveUserConfigData(key, value);
            cachedCongfigData.clear();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void saveUserConfigData(String key, CoreUI ui, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveUserConfigData(key, ui.getMetaDataPK().getFullName(), value);
            cachedCongfigData.clear();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static String getDCConfigData(String key) {
        try {
            return ConfigControllerFactory.getRemoteInstance().getDCConfigData(key);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDCConfigData(String key, CoreUI ui) {
        try {
            return ConfigControllerFactory.getRemoteInstance().getDCConfigData(key, ui.getMetaDataPK().getFullName());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveDCConfigData(String key, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveDCConfigData(key, value);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void saveDCConfigData(String key, CoreUI ui, String value) {
        try {
            ConfigControllerFactory.getRemoteInstance().saveDCConfigData(key, ui.getMetaDataPK().getFullName(), value);
            cachedCongfigData.clear();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }
}

