/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.framework.config.client.ToolBarCustomerConfigUI;
import java.awt.Component;
import org.apache.log4j.Logger;

public class CustomToolBar {
    private static final Logger logger = CoreUIObject.getLogger(ToolBarCustomerConfigUI.class);
    public static final String CUSTOMTOOLBAR = "EAS_CustomToolBar";
    public static final String CUSTOMTOOLBARSEPARATOR = "#";
    private int index;
    private String name;
    private String[] hideBtns;
    private String[] enableShowBtns;
    private Component[] hides;
    private Component[] comps;
    private KDWorkButton[] btns;
    private KDToolBar toolBar = null;
    private CoreUI coreUI = null;

    public CustomToolBar(CoreUI ui) {
        this.coreUI = ui;
        this.toolBar = ui.getUIToolBar();
        if (this.toolBar != null) {
            this.comps = this.toolBar.getToolBarComponents();
            int hideCount = 0;
            this.btns = new KDWorkButton[this.comps.length];
            for (int i = 0; i < this.comps.length; ++i) {
                if (!(this.comps[i] instanceof KDWorkButton)) continue;
                this.btns[i] = (KDWorkButton)this.comps[i];
                if (this.btns[i].isVisible()) continue;
                ++hideCount;
            }
            this.hideBtns = new String[hideCount];
            this.hides = new KDWorkButton[hideCount];
            int j = 0;
            for (int i = 0; i < this.comps.length; ++i) {
                KDWorkButton hBtn;
                if (!(this.comps[i] instanceof KDWorkButton) || (hBtn = (KDWorkButton)this.comps[i]).isVisible()) continue;
                this.hideBtns[j] = hBtn.getText();
                if (this.hideBtns[j] == null || "".equals(this.hideBtns[j])) {
                    this.hideBtns[j] = hBtn.getToolTipText();
                }
                this.hides[j] = this.comps[i];
                ++j;
            }
        }
    }

    public String getName(int index) {
        if (this.btns[index] != null) {
            return this.btns[index].getName();
        }
        return null;
    }

    public String[] getDefaultHideBtns() {
        return this.hideBtns;
    }

    public Component[] getHideBtns() {
        return this.hides;
    }

    public void setEnableShowBtns(String[] enableShowBtns) {
        this.enableShowBtns = enableShowBtns;
    }

    public void initCustomToolBar() {
        String[] configs = this.getCustomToolBarNames();
        if (configs != null) {
            if (this.btns != null) {
                for (int j = 0; j < this.btns.length; ++j) {
                    if (this.btns[j] == null || this.btns[j].getName() == null) continue;
                    this.btns[j].setVisible(false);
                }
            }
            for (int i = 0; i < configs.length; ++i) {
                if (this.btns == null) continue;
                for (int j = 0; j < this.btns.length; ++j) {
                    if (this.btns[j] == null || !configs[i].equals(this.btns[j].getName())) continue;
                    this.btns[j].setVisible(true);
                }
            }
        }
    }

    public String[] getCustomToolBarNames() {
        String config = ConfigServiceUtils.getUserConfigData(CUSTOMTOOLBAR, this.coreUI);
        String[] configs = config != null ? config.split(CUSTOMTOOLBARSEPARATOR) : null;
        return configs;
    }

    public void saveCustomToolBar() {
        String CustomToolBarValue = null;
        for (int i = 0; i < this.btns.length; ++i) {
            if (CustomToolBarValue == null) {
                if (this.btns[i] == null || !this.btns[i].isVisible() || !(this.btns[i] instanceof KDWorkButton)) continue;
                CustomToolBarValue = this.btns[i].getName();
                continue;
            }
            if (this.btns[i] == null || !this.btns[i].isVisible()) continue;
            CustomToolBarValue = CustomToolBarValue + CUSTOMTOOLBARSEPARATOR;
            CustomToolBarValue = CustomToolBarValue + this.btns[i].getName();
        }
        ConfigServiceUtils.saveUserConfigData(CUSTOMTOOLBAR, this.coreUI, CustomToolBarValue);
    }
}

