/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config.client;

import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.IUserCustomConfigItemUI;
import com.kingdee.eas.framework.config.UserCustomConfigData;
import com.kingdee.eas.framework.config.UserCustomConfigHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItem;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserCustomConfigSolution;
import com.kingdee.eas.framework.config.client.TableStyleSettingUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;

public class TableStyleSettingContainerUI
extends CoreUI
implements IUserCustomConfigItemUI {
    private KDPanel container = new KDPanel();
    private TableStyleSettingUI tableUI = null;
    private UserCustomConfigData userConfigData;
    private UserCustomConfigSolution solution;
    private UserCustomConfigItem item;
    private UserCustomConfigHelper helper;
    private KDTable tableComponent;
    public static final String ROWHEAD_HEIGHT = "RowHeadHeight";
    public static final String ROWODD_HEIGHT = "RowODDHeight";
    public static final String ROWEVEN_HEIGHT = "RowEvenHeight";
    public static final String ROWHEAD_FCOLOR = "RowHeadFColor";
    public static final String ROWHEAD_BCOLOR = "RowHeadBColor";
    public static final String SELECTED_BCOLOR = "SelectedBColor";
    public static final String ROWODD_FCOLOR = "RowODDFColor";
    public static final String ROWODD_BCOLOR = "RowODDBColor";
    public static final String ROWEVEN_FCOLOR = "RowEvenFColor";
    public static final String ROWEVEN_BCOLOR = "RowEvenBColor";

    public TableStyleSettingContainerUI() throws Exception {
        this.initialize();
        this.setLayout(new BorderLayout());
        this.add((Component)this.container, "Center");
    }

    private void initialize() throws Exception {
        this.tableUI = new TableStyleSettingUI();
        this.tableUI.initLayout();
        this.tableUI.onLoad();
        this.container.setLayout((LayoutManager)new BorderLayout());
        this.container.add((Component)((Object)this.tableUI), (Object)"Center");
    }

    @Override
    public void setItem(UserCustomConfigData data, UserCustomConfigSolution solution, UserCustomConfigItem item, UserCustomConfigHelper helper) {
        this.userConfigData = data;
        this.solution = solution;
        this.item = item;
        this.helper = helper;
        if (item.getComponent() != null) {
            this.tableComponent = (KDTable)item.getComponent();
            UserCustomConfigItemData itemData = solution.isSelected() ? this.getStyleDataFromTable(this.tableComponent) : this.userConfigData.getItemData(solution.getName(), item.getName());
            data.setItemData(solution.getName(), item.getName(), itemData);
            this.tableUI.fillDataToUI(itemData);
        }
    }

    private UserCustomConfigItemData getStyleDataFromTable(KDTable tb) {
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        KDTColumns columns = tb.getColumns();
        Map values = itemData.getColumnData();
        if (tb.getHeadRowCount() == 1) {
            values.put(ROWHEAD_HEIGHT, String.valueOf(tb.getHeadRow(0).getHeight()));
            values.put(ROWHEAD_BCOLOR, this.getColorString(tb.getHeadRow(0).getStyleAttributes().getBackground()));
            values.put(ROWHEAD_FCOLOR, this.getColorString(tb.getHeadRow(0).getStyleAttributes().getFontColor()));
        }
        if (tb.getRowCount() > 1) {
            values.put(ROWODD_HEIGHT, String.valueOf(tb.getRow(0).getHeight()));
            values.put(ROWODD_BCOLOR, this.getColorString(tb.getRow(0).getStyleAttributes().getBackground()));
            values.put(ROWODD_FCOLOR, this.getColorString(tb.getRow(0).getStyleAttributes().getFontColor()));
        }
        if (tb.getRowCount() > 2) {
            values.put(ROWEVEN_HEIGHT, String.valueOf(tb.getRow(1).getHeight()));
            values.put(ROWEVEN_BCOLOR, this.getColorString(tb.getRow(1).getStyleAttributes().getBackground()));
            values.put(ROWEVEN_FCOLOR, this.getColorString(tb.getRow(1).getStyleAttributes().getFontColor()));
        }
        return itemData;
    }

    private String getColorString(Color c) {
        String result = "";
        result = result + c.getRed() + ",";
        result = result + c.getGreen() + ",";
        result = result + c.getBlue();
        return result;
    }

    @Override
    public void saveData(UserCustomConfigData data) {
        data.setItemData(this.solution.getName(), this.item.getName(), this.tableUI.getDataFromUI());
    }

    @Override
    public UserCustomConfigItemData getItemDataFromUI(UserCustomConfigItem item) {
        UserCustomConfigItemData itemData = null;
        if (item != null && item.getComponent() instanceof KDTable) {
            itemData = this.getStyleDataFromTable((KDTable)item.getComponent());
        }
        return itemData;
    }

    @Override
    public void applyConfig(UserCustomConfigData configData, UserCustomConfigItem item) {
        if (item.getComponent() != null && item.getComponent() instanceof KDTable && this.getDefaultItemData(configData, item.getName()) != null) {
            this.applyToTable((KDTable)item.getComponent(), this.getDefaultItemData(configData, item.getName()));
        }
    }

    private void applyToTable(KDTable tb, UserCustomConfigItemData itemData) {
        if (itemData == null) {
            return;
        }
        Map values = itemData.getColumnData();
        if (tb.getHeadRowCount() == 1) {
            tb.getHeadRow(0).setHeight(Integer.parseInt((String)values.get(ROWHEAD_HEIGHT)));
            tb.getHeadRow(0).getStyleAttributes().setBackground(this.getColor((String)values.get(ROWHEAD_BCOLOR)));
            tb.getHeadRow(0).getStyleAttributes().setFontColor(this.getColor((String)values.get(ROWHEAD_FCOLOR)));
        }
    }

    private UserCustomConfigItemData getDefaultItemData(UserCustomConfigData configData, String itemName) {
        return configData.getItemData(configData.getDefaultSolution().getName(), itemName);
    }

    private Color getColor(String s) {
        String[] rgb;
        if (s != null && (rgb = s.split(",")).length == 3) {
            return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        return null;
    }
}

