/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.framework.query.CompareEnumUtility;
import com.kingdee.eas.framework.query.IFilterItemPanel;
import com.kingdee.eas.framework.util.DateUtility;
import com.kingdee.eas.framework.util.QueryUtility;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class FilterItemPanel
extends KDPanel
implements IFilterItemPanel {
    private static final Logger logger = Logger.getLogger(FilterItemPanel.class);
    private static final String IS_COMMON_QUERY_FILTER = "isCommonQueryFilter";
    private static final String DEFAULT_F7_QUERY = "defaultF7Query";
    private static final String F7_DISPLAY_FORMAT = "displayFormat";
    private static final String DEFAULT_DISPLAY_FIELD = "defaultDisplayField";
    protected MetaDataPK queryInfo;
    protected String fieldName;
    protected KDComboBox compareSignComboBox;
    protected FilterItemInfo filterItemInfo;
    protected KDLabel nameLabel;
    private Object initValue;
    private static final Set<StringEnum> NOVALUE_ENUMS = new HashSet<StringEnum>();

    public FilterItemPanel(MetaDataPK queryInfo, String fieldName) throws BOSException {
        this.queryInfo = queryInfo;
        this.fieldName = fieldName;
        this.init(null);
    }

    public FilterItemPanel(MetaDataPK queryInfo, FilterItemInfo filterItemInfo, String sign) throws BOSException {
        this.queryInfo = queryInfo;
        this.fieldName = filterItemInfo.getPropertyName();
        this.filterItemInfo = filterItemInfo;
        this.init(sign);
    }

    public FilterItemPanel(MetaDataPK queryInfo, FilterItemInfo filterItemInfo, String sign, Object initValue) throws BOSException {
        this.queryInfo = queryInfo;
        this.fieldName = filterItemInfo.getPropertyName();
        this.filterItemInfo = filterItemInfo;
        this.initValue = initValue;
        this.init(sign);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    private void init(String sign) throws BOSException {
        SimplePropertyUnit fieldInfo;
        this.setLayout(null);
        String displayName = "";
        DataObject dataInfo = null;
        SimplePropertyUnitCollection col = QueryUtility.getQueryFieldInfo(this.queryInfo, this.fieldName);
        if (col != null && (fieldInfo = col.get(this.fieldName)) != null) {
            displayName = fieldInfo.getDisplayName();
            dataInfo = Util.getRefMetaData((MetaDataPK)this.queryInfo, (String)fieldInfo.getName());
        }
        this.nameLabel = new KDLabel(displayName);
        this.nameLabel.setBounds(5, 5, 100, 20);
        if (dataInfo == null) {
            return;
        }
        if (sign == null) {
            sign = dataInfo.getName().equals("String") ? "LIKE" : "=";
        }
        this.add((Component)this.nameLabel);
        this.compareSignComboBox = this.getCompareSignComboBox(dataInfo, sign);
        this.compareSignComboBox.setBounds(110, 5, 120, 20);
        this.add((Component)this.compareSignComboBox);
        String compareType = "=";
        if (this.filterItemInfo != null) {
            compareType = this.filterItemInfo.getCompareType().getName();
        }
        String compareValue = "";
        if (this.initValue != null) {
            compareValue = this.initValue instanceof Date ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)this.initValue) : this.initValue.toString();
        }
        if (CompareType.LIKE.getName().equals(compareType)) {
            RowObject rowObject = new RowObject();
            Util.updateLikeRowObject((RowObject)rowObject, (Object)compareValue, (CompareType)this.filterItemInfo.getCompareType());
            compareType = rowObject.getCompare();
            compareValue = StringUtils.cnulls((Object)rowObject.getCompareValue());
        }
    }

    private KDComboBox getCompareSignComboBox(DataObject dataInfo, String compareType) {
        String dataType = dataInfo.getName();
        String compareEnumClassString = CompareEnumUtility.getCompareEnumClassNameByDateType(dataType);
        return CompareEnumUtility.getSelectedEnumComboBox(compareEnumClassString, compareType);
    }

    String getCompareSignString() {
        Object selectedSignItem = this.getCompareSign();
        if (selectedSignItem instanceof StringEnum) {
            return ((StringEnum)selectedSignItem).getValue();
        }
        return "=";
    }

    private Object getCompareSign() {
        return this.compareSignComboBox.getSelectedItem();
    }

    FilterItemInfo getFilterItemInfo(boolean withoutValue) throws BOSException {
        FilterItemInfo filterItemInfo = new FilterItemInfo();
        String condition = this.fieldName;
        Object compareSign = this.getCompareSign();
        Object compareValue = null;
        String compareSignString = this.getCompareSignString();
        if ("YESTERDAY".equalsIgnoreCase(compareSignString) || "TODAY".equalsIgnoreCase(compareSignString) || "TOMORROW".equalsIgnoreCase(compareSignString) || "LASTWEEK".equalsIgnoreCase(compareSignString) || "THISWEEK".equalsIgnoreCase(compareSignString) || "NEXTWEEK".equalsIgnoreCase(compareSignString) || "LASTMONTH".equalsIgnoreCase(compareSignString) || "THISMONTH".equalsIgnoreCase(compareSignString) || "NEXTMONTH".equalsIgnoreCase(compareSignString) || "BEFORETODAY".equalsIgnoreCase(compareSignString) || "AFTERTODAY".equalsIgnoreCase(compareSignString)) {
            filterItemInfo = new FilterItemInfo(condition, (Object)compareSignString, CompareType.getEnum((String)"="));
        } else if ("IS".equalsIgnoreCase(compareSignString)) {
            filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.IS);
        } else if ("IS NOT".equalsIgnoreCase(compareSignString)) {
            filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.ISNOT);
        } else {
            DataObject dataInfo;
            if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                if (withoutValue) {
                    compareValue = "*";
                }
                if (CompareSignStringEnum.LEFTLIKESIGN.equals(compareSign) || CompareSignStringEnum.RIGHTLIKESIGN.equals(compareSign)) {
                    compareSignString = "like";
                } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN) {
                    compareSignString = "not like";
                }
                compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
            }
            if ((dataInfo = Util.getRefMetaData((MetaDataPK)this.queryInfo, (String)condition)) != null) {
                String dataType = dataInfo.getName();
                if (CommonFilterUtil.isIntType((String)dataType)) {
                    filterItemInfo = new FilterItemInfo(condition, null, CompareType.getEnum((String)compareSignString));
                } else {
                    if (DataType.DATE.getName().equals(dataType)) {
                        Date date = (Date)compareValue;
                        Timestamp start = DateUtility.startOfThisDay(date);
                        compareValue = start;
                    }
                    filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compareSignString.toLowerCase()));
                }
            }
        }
        return filterItemInfo;
    }

    static {
        NOVALUE_ENUMS.add((StringEnum)CompareSignStringEnum.NULLSIGN);
        NOVALUE_ENUMS.add((StringEnum)CompareSignStringEnum.NOTNULLSIGN);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.NULLSIGN);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.NOTNULLSIGN);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.AFTERTODAY);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.BEFORETODAY);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.LASTMONTH);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.LASTWEEK);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.THISMONTH);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.THISWEEK);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.TODAY);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.TOMORROW);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.YESTERDAY);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.NEXTMONTH);
        NOVALUE_ENUMS.add((StringEnum)CompareSignDateEnum.NEXTWEEK);
    }
}

