/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionUtils;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.IFastFilter;
import com.kingdee.eas.framework.query.IFastQuery;
import com.kingdee.eas.framework.query.IQuickSearchQuery;
import com.kingdee.eas.framework.query.ISolutionChangedListener;
import com.kingdee.eas.framework.query.QueryServiceFacadeFactory;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.query.SolutionItem;
import com.kingdee.eas.framework.query.SystemSolutionItem;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

class MySolutionList
implements IFastFilter {
    private static final Logger logger = Logger.getLogger(MySolutionList.class);
    private static final String BLANK_SOLUTION = QuickFilterResources.getMessage("BLANK_SOLUTION");
    private QuerySolutionInfo blankSolution;
    private SolutionItem blankSolutionItem;
    static final Color COLOR_PANE = new Color(241, 244, 249);
    private SolutionItem _currentSelectedSolution;
    private IFastQuery fastQuery;
    private LinkedList<SolutionItem> _solutionItems = new LinkedList();
    private Map<SolutionItem, Boolean> solutionStates = new HashMap<SolutionItem, Boolean>();
    private ISolutionChangedListener solutionListPanel;
    private IQuickSearchQuery quickSearchQuery;
    private boolean noNeedToExecuteAtCanceled = false;
    private boolean isSolutionChangedByDialog = false;
    private QuickFilteringSupportItems supportItems;
    private OrgUnitCollection authOrgs;

    private void createBlankSolution() {
        this.blankSolution = new QuerySolutionInfo();
        QueryPanelCollection queryPanelCollection = new QueryPanelCollection();
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelCollection.add(queryPanelInfo);
        this.blankSolution.getQueryPanelInfo().addCollection(queryPanelCollection);
        this.blankSolution.setName(BLANK_SOLUTION);
        this.blankSolution.setSolutionType(SolutionTypeEnum.SYSTEM_SOLUTION);
        this.blankSolution.setId(new ObjectUuidPK(BOSObjectType.create((String)"F93E381C")).getKeyValue());
        this.blankSolutionItem = new SolutionItem(this, this.getBlankQuerySolution());
    }

    MySolutionList(IQuickSearchQuery quickSearchQuery, IFastQuery fastQuery, ISolutionChangedListener solutionListPanel, QuickFilteringSupportItems supportItems) {
        this.quickSearchQuery = quickSearchQuery;
        this.fastQuery = fastQuery;
        this.solutionListPanel = solutionListPanel;
        this.supportItems = supportItems;
        this.createBlankSolution();
        this.loadSolutionList();
    }

    private void initSolutionList(QuerySolutionInfo solutionInfo) {
        this.solutionListPanel.solutionChanged(solutionInfo, true);
    }

    @Override
    public OrgUnitCollection getAuthOrgsByType() {
        if (this.authOrgs != null) {
            return this.authOrgs;
        }
        IMetaDataPK queryPK = this.quickSearchQuery.getMainQueryPK();
        OrgType mainOrgType = this.quickSearchQuery.getMainType();
        try {
            this.authOrgs = QueryServiceFacadeFactory.getRemoteInstance().getAuthOrgsByType(mainOrgType, queryPK);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return this.authOrgs;
    }

    @Override
    public QuerySolutionInfo getCurrentSelectedSolution() {
        if (this._currentSelectedSolution == null) {
            return this.getBlankQuerySolution();
        }
        return this._currentSelectedSolution.getSolutionInfo();
    }

    @Override
    public QuerySolutionInfo getBlankQuerySolution() {
        return this.blankSolution;
    }

    @Override
    public MetaDataPK getQueryPK() {
        return (MetaDataPK)this.quickSearchQuery.getMainQueryPK();
    }

    @Override
    public boolean isBlankSolution(QuerySolutionInfo querySolutionInfo) {
        return BLANK_SOLUTION.equals(querySolutionInfo.getName());
    }

    @Override
    public boolean isBlankSolution() {
        return this.isBlankSolution(this.getCurrentSelectedSolution());
    }

    @Override
    public void solutionChanged(QuerySolutionInfo solutionInfo, boolean refreshList) {
        boolean hasSolution = refreshList;
        if (refreshList) {
            hasSolution = this.refreshSolutionList(solutionInfo);
        }
        if (solutionInfo != null) {
            this.isSolutionChangedByDialog = true;
            SolutionItem item = this.setCurrentSolution(solutionInfo);
            try {
                this.reloadSolutionAtFirstTime(item);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.fastQuery.solutionChanged(solutionInfo, false);
            this.isSolutionChangedByDialog = false;
        }
    }

    private boolean refreshSolutionList(QuerySolutionInfo solutionInfo) {
        this.loadSolutionList();
        this.initSolutionList(solutionInfo);
        if (solutionInfo == null && this._currentSelectedSolution != null && !this._currentSelectedSolution.getSolutionInfo().equals((Object)this.getBlankQuerySolution())) {
            for (SolutionItem item : this._solutionItems) {
                if (!this._currentSelectedSolution.getSolutionInfo().getId().equals((Object)item.getSolutionInfo().getId())) continue;
                this.noNeedToExecuteAtCanceled = true;
                this.setCurrentSolutionItem(item);
                this.noNeedToExecuteAtCanceled = false;
                return true;
            }
            this.setCurrentSolution(this.getBlankQuerySolution());
            return false;
        }
        return true;
    }

    private SolutionItem setCurrentSolution(QuerySolutionInfo solutionInfo) {
        for (SolutionItem item : this._solutionItems) {
            if (!item.getSolutionInfo().getId().equals((Object)solutionInfo.getId())) continue;
            if (!this.isBlankSolution(item.getSolutionInfo())) {
                item.setSolutionInfo(solutionInfo);
            }
            this.setCurrentSolutionItem(item);
            return item;
        }
        return null;
    }

    @Override
    public boolean executeDefaultSolution(QuerySolutionInfo defaultSolution) {
        SolutionItem defaultSolutionItem = this.getDefaultSolutionItem(defaultSolution);
        boolean isBlank = this.isBlankSolution(defaultSolutionItem.getSolutionInfo());
        if (isBlank) {
            this.solutionChangedForFastQuery(defaultSolutionItem);
        } else {
            this.isSolutionChangedByDialog = true;
            this.executeSolutionItem(defaultSolutionItem);
            this.isSolutionChangedByDialog = false;
        }
        return !isBlank;
    }

    private SolutionItem getDefaultSolutionItem(QuerySolutionInfo defaultSolution) {
        for (SolutionItem si : this._solutionItems) {
            boolean isDefault = defaultSolution != null && si.getSolutionInfo().getId().toString().equals(defaultSolution.getId().toString());
            if (!isDefault) continue;
            if (this.isBlankSolution(si.getSolutionInfo())) break;
            si.setSolutionInfo(defaultSolution);
            return si;
        }
        return new SolutionItem(this, this.getBlankQuerySolution());
    }

    private void loadSolutionList() {
        this._solutionItems.clear();
        this.solutionStates.clear();
        try {
            SolutionItem item = null;
            item = this.supportItems.getSystemSolutionItem();
            this._solutionItems.add(item);
            QuerySolutionCollection querySolutionCollection = QuerySolutionUtils.getAllQuerySolutionColForFastQuery(null, (String)this.fastQuery.getCurrentUIName(), (String)this.quickSearchQuery.getMainQueryPK().getFullName());
            StringBuilder sb = new StringBuilder();
            sb.append(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"84_MySolutionList")).append(querySolutionCollection.size()).append(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"85_MySolutionList"));
            int count = querySolutionCollection.size();
            for (int index = 0; index < count; ++index) {
                QuerySolutionInfo solution = querySolutionCollection.get(index);
                if (SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)solution.getSolutionType())) {
                    item = this.supportItems.getSystemSolutionItem();
                    item.setSolutionInfo(solution);
                } else {
                    item = new SolutionItem(this, solution);
                    this._solutionItems.add(item);
                }
                this.solutionStates.put(item, Boolean.FALSE);
                sb.append(item.toString()).append("\uff1b");
            }
            logger.info((Object)sb.toString());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void executeSolutionItem(SolutionItem item) {
        if (item == null || this.noNeedToExecuteAtCanceled) {
            return;
        }
        if (this.quickSearchQuery.isSameSolutionExecuted(item.getSolutionInfo())) {
            return;
        }
        this.doExecuteSolutionItem(item);
    }

    private void doExecuteSolutionItem(SolutionItem item) {
        try {
            FilterInfo filter = null;
            this.setCurrentSolutionItem(item);
            if (!this.isBlankSolution(item.getSolutionInfo())) {
                try {
                    this.reloadSolutionAtFirstTime(item);
                }
                catch (ObjectNotFoundException e) {
                    MsgBox.showWarning((Component)((Component)((Object)this.quickSearchQuery)), (String)QuickFilterResources.getMessage("SOLUTIONNOTFOUND", new String[]{item.getSolutionInfo().getName()}));
                    this.solutionChanged(null, true);
                    return;
                }
                List mainOrgs = null;
                if (item instanceof SystemSolutionItem) {
                    filter = ((SystemSolutionItem)item).getDefaultFilter().getFilter();
                    mainOrgs = ((SystemSolutionItem)item).getMainOrgs();
                }
                this.quickSearchQuery.doQuery(item.getSolutionInfo(), filter, mainOrgs, false);
            } else {
                this.clearTableRows();
            }
            this.solutionChangedForFastQuery(item);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    private void solutionChangedForFastQuery(SolutionItem item) {
        if (this.fastQuery == null) {
            return;
        }
        this.fastQuery.solutionChanged(item.getSolutionInfo(), false);
    }

    private void setCurrentSolutionItem(SolutionItem item) {
        this._currentSelectedSolution = item;
    }

    private void reloadSolutionAtFirstTime(SolutionItem item) throws Exception {
        if (item == null || SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)item.getSolutionInfo().getSolutionType()) || this.isBlankSolution(item.getSolutionInfo())) {
            return;
        }
        Boolean state = this.solutionStates.get(item);
        if (state == null || !state.booleanValue()) {
            QuerySolutionInfo solution = QuerySolutionUtils.getFullQuerySolution(null, (String)item.getSolutionInfo().getId().toString());
            if (solution == null) {
                this.solutionChanged(null, true);
            } else {
                item.setSolutionInfo(solution);
                this.solutionStates.put(item, Boolean.TRUE);
            }
        }
    }

    private void clearTableRows() {
        this.quickSearchQuery.getMainTable().removeRows(false);
    }

    @Override
    public void setDefaultSolution() {
        if (this._currentSelectedSolution == null) {
            MsgBox.showWarning((Component)((Component)((Object)this.quickSearchQuery)), (String)QuickFilterResources.getMessage("SOLUTIONNOTSELECTED"));
            return;
        }
        if (this.isBlankSolution()) {
            return;
        }
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            iQuerySolution.saveDefaultSolution(this._currentSelectedSolution.getSolutionInfo().getId().toString(), this.fastQuery.getCurrentUIName(), this.getQueryPK().getFullName(), this._currentSelectedSolution.getSolutionInfo().getRowCount(), true);
        }
        catch (EASBizException e) {
            ((ListUI)this.quickSearchQuery).handUIException(e);
        }
        catch (BOSException e) {
            ((ListUI)this.quickSearchQuery).handUIException(e);
        }
        MsgBox.showInfo((Component)((Component)((Object)this.quickSearchQuery)), (String)QuickFilterResources.getMessage("SETDEFAULTSOLUTIONSUCCESS"));
    }

    @Override
    public List<SolutionItem> getSolutionItems() {
        return this._solutionItems;
    }

    @Override
    public SolutionItem getCurrentSelectedSolutionItem() {
        return this._currentSelectedSolution;
    }

    @Override
    public void executeItem(IListPopupItem item, boolean isOnRefresh) {
        this._currentSelectedSolution = this.blankSolutionItem;
    }
}

