/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query;

import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.query.component.AbstractListPopupItem;
import com.kingdee.eas.framework.query.component.CompositeListPopupItem;
import com.kingdee.eas.framework.query.component.IJSONStringSupport;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.eas.framework.util.ProfileIOUtility;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class RecentQuickSearchItemsMananger {
    private static final Logger logger = Logger.getLogger(RecentQuickSearchItemsMananger.class);
    private static final int MAX_ITEMS = 3;
    private static final String DIR_QUICKSEARCH = File.separator + "cache" + File.separator + "quicksearch" + File.separator;
    private static final String DIR_USER = System.getProperty("user.dir");
    private String userName = SysContext.getSysContext().getUserName();
    private String uiName;
    private MetaDataPK queryPK;
    private IListPopupItemExecute executor;
    private LinkedList<IListPopupItem> items;

    public RecentQuickSearchItemsMananger(String uiName) {
        this.uiName = uiName;
    }

    RecentQuickSearchItemsMananger(String uiName, MetaDataPK queryPK, IListPopupItemExecute executor) {
        this.uiName = uiName;
        this.queryPK = queryPK;
        this.executor = executor;
    }

    private File openQuickSearchFile() {
        String fileName = DIR_USER + DIR_QUICKSEARCH + this.uiName + ".cfg";
        logger.info((Object)("\u6253\u5f00\u4fdd\u5b58\u5feb\u901f\u8fc7\u6ee4\u7684\u4e34\u65f6\u6587\u4ef6\uff1a" + fileName));
        File file = new File(fileName);
        return file;
    }

    private String[] loadQuickSearchConfig() {
        File file = this.openQuickSearchFile();
        if (!file.exists()) {
            return null;
        }
        String[] values = null;
        String section = this.getQuickSearchSectionName();
        try {
            values = ProfileIOUtility.getProfileStrings(file, section);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return values;
    }

    private String getQuickSearchSectionName() {
        return "search items for " + this.userName;
    }

    private String getBlankTableParamsSectionName() {
        String blankSolutionName = QuickFilterResources.getMessage("BLANK_SOLUTION");
        return this.getTableParamsSectionName(blankSolutionName);
    }

    List<IListPopupItem> loadRecentQuickSearchItems() {
        String[] values = this.loadQuickSearchConfig();
        if (values == null) {
            return null;
        }
        this.items = new LinkedList();
        for (String value : values) {
            CompositeListPopupItem item = CompositeListPopupItem.valueOf(value, this.executor, this.queryPK);
            if (item == null) continue;
            this.items.add(item);
        }
        return this.items;
    }

    List<IListPopupItem> getRecentQuickSearchItems() {
        return this.items;
    }

    void saveRecentQuickSearchItems() {
        if (this.items == null || this.items.size() == 0) {
            return;
        }
        String[] values = new String[this.items.size()];
        File file = this.openQuickSearchFile();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            String section = this.getQuickSearchSectionName();
            int i = 0;
            for (IListPopupItem item : this.items) {
                if (!(item instanceof IJSONStringSupport)) continue;
                values[i++] = ((IJSONStringSupport)((Object)item)).toJSONString();
            }
            ProfileIOUtility.setProfileStrings(file, section, values);
        }
        catch (IOException e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    void addRecentQuickSearchItem(IListPopupItem item) {
        String joString = ((IJSONStringSupport)((Object)item)).toJSONString();
        if (StringUtils.isEmpty((String)joString)) {
            return;
        }
        if (this.items == null) {
            this.items = new LinkedList();
        }
        for (IListPopupItem aItem : this.items) {
            if (!((AbstractListPopupItem)aItem).equals((AbstractListPopupItem)item)) continue;
            this.items.remove(aItem);
            this.items.addFirst(aItem);
            return;
        }
        this.items.addFirst(item);
        if (this.items.size() > 3) {
            this.items.removeLast();
        }
    }

    String loadBlankSolutionTableParams() {
        String section = this.getBlankTableParamsSectionName();
        return this.loadSolutionTableParams(section);
    }

    private String loadSolutionTableParams(String section) {
        File file = this.openQuickSearchFile();
        if (!file.exists()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] values = null;
        try {
            for (String value : values = ProfileIOUtility.getProfileStrings(file, section)) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(value);
            }
            return sb.toString();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    void saveBlankSolutionTableParams(String tableParams) {
        if (StringUtils.isEmpty((String)tableParams)) {
            return;
        }
        String section = this.getBlankTableParamsSectionName();
        this.saveSolutionTableParamsToFile(tableParams, section);
    }

    private void saveSolutionTableParamsToFile(String tableParams, String section) {
        try {
            File file = this.openQuickSearchFile();
            if (!file.exists()) {
                file.createNewFile();
            }
            ProfileIOUtility.setProfileStrings(file, section, new String[]{tableParams});
        }
        catch (IOException e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    private String getTableParamsSectionName(String solutionName) {
        return solutionName + " tableparams for " + this.userName;
    }

    private String getTableParamsSectionName(String solutionName, String queryPK) {
        return solutionName + " tableparams for " + this.userName + " for " + queryPK;
    }

    static {
        File file = new File(DIR_USER + DIR_QUICKSEARCH);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

