/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.test.cache;

import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.framework.cache.CacheService;
import com.kingdee.eas.framework.cache.EntityViewPK;
import com.kingdee.eas.framework.cache.OqlPK;
import com.kingdee.eas.framework.cache.QueryCacheObject;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class TestCacheService
extends TestCase {
    static Logger logger = Logger.getLogger((String)"TestCacheService");

    public TestCacheService(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(TestCacheService.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateRegion() {
        String regionName = "com.kingdee.eas";
        CacheRegion region = CacheService.createRegion(regionName);
        TestCacheService.assertTrue((boolean)CacheService.existRegion(regionName));
        logger.info((Object)("regionName: " + region.getName()));
        TestCacheService.assertTrue((boolean)regionName.equals(CacheService.getCacheRegion(regionName).getName()));
    }

    public void testQuery1() throws Exception {
        MetaDataPK metaPk = new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "CurrencyQuery");
        EntityViewPK dataPk = new EntityViewPK();
        CacheService.addCacheObject(new QueryCacheObject((IMetaDataPK)metaPk, dataPk));
        TestCacheService.assertTrue((CacheService.getCacheRegion(metaPk.toString()) != null ? 1 : 0) != 0);
        Object obj = CacheService.getCacheObject((IMetaDataPK)metaPk, dataPk);
        TestCacheService.assertTrue((boolean)(obj instanceof IRowSet));
        logger.info((Object)"CurrencyQuery start dump:");
        IRowSet rs = (IRowSet)obj;
        while (rs.next()) {
            logger.info((Object)rs.getString(1));
        }
        logger.info((Object)"CurrencyQuery end dump:");
    }

    public void testQuery2() throws Exception {
        MetaDataPK metaPk = new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "CurrencyQuery");
        OqlPK dataPk = new OqlPK();
        logger.info(dataPk.getArgs());
        CacheService.addCacheObject(new QueryCacheObject((IMetaDataPK)metaPk, dataPk));
        TestCacheService.assertTrue((CacheService.getCacheRegion(metaPk.toString()) != null ? 1 : 0) != 0);
        Object obj = CacheService.getCacheObject((IMetaDataPK)metaPk, dataPk);
        TestCacheService.assertTrue((boolean)(obj instanceof IRowSet));
        logger.info((Object)"CurrencyQuery start dump:");
        IRowSet rs = (IRowSet)obj;
        while (rs.next()) {
            logger.info((Object)rs.getString(1));
        }
        logger.info((Object)"CurrencyQuery end dump:");
    }

    public void testPerformance() {
        LowTimer timer = new LowTimer();
        MetaDataPK metaPK = new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "CurrencyQuery");
        Object obj = CacheService.getCacheObject((IMetaDataPK)metaPK, true);
        TestCacheService.assertTrue((boolean)(obj instanceof IRowSet));
        logger.info((Object)("reload time: " + timer.msValue()));
        timer.reset();
        for (int i = 0; i < 100; ++i) {
            CacheService.getCacheObject((IMetaDataPK)metaPK);
        }
        logger.info((Object)("getCache time: " + (double)timer.msValue() / 100.0));
    }

    public void testRepeatAdd() throws Exception {
        MetaDataPK metaPk = new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "CurrencyQuery");
        EntityViewPK dataPk = new EntityViewPK();
        for (int i = 0; i < 10; ++i) {
            CacheService.addCacheObject(new QueryCacheObject((IMetaDataPK)metaPk, dataPk));
        }
        Object obj = CacheService.getCacheObject((IMetaDataPK)metaPk, dataPk);
        TestCacheService.assertTrue((boolean)(obj instanceof IRowSet));
        logger.info((Object)"CurrencyQuery start dump:");
        IRowSet rs = (IRowSet)obj;
        while (rs.next()) {
            logger.info((Object)rs.getString(1));
        }
        logger.info((Object)"CurrencyQuery end dump:");
    }

    public void testAutoGet() throws SQLException {
        MetaDataPK metaPK = new MetaDataPK("com.kingdee.eas.basedata.assistant.app", "AddressQuery");
        Object obj = CacheService.getCacheObject((IMetaDataPK)metaPK);
        TestCacheService.assertTrue((boolean)(obj instanceof IRowSet));
        logger.info((Object)"AddressQuery start dump:");
        IRowSet rs = (IRowSet)obj;
        rs.beforeFirst();
        while (rs.next()) {
            logger.info((Object)rs.getString(1));
        }
        logger.info((Object)"AddressQuery end dump:");
    }
}

