/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mbos.common.util;

import com.kingdee.mbos.common.util.CMeta;
import com.kingdee.mbos.common.util.FileInfo;
import java.io.File;

public class FileStore {
    private String eid;
    private String urlRoot;
    private String fileRoot;
    private File rootFile;

    public FileStore(String eid) {
        this.eid = eid;
        String eashome = System.getProperty("EAS_HOME");
        String storeDir = eashome + "/server/deploy/eas.ear/mbos_eas.war/store/";
        if (storeDir != null) {
            this.fileRoot = storeDir.endsWith("/") ? storeDir + eid + "/" : storeDir + "/" + eid + "/";
        }
        this.rootFile = new File(this.fileRoot);
        if (!this.rootFile.exists()) {
            this.rootFile.mkdirs();
        }
        if (!this.rootFile.exists()) {
            try {
                throw new Exception("\u6ca1\u6709\u6587\u4ef6\u5939" + this.fileRoot);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.urlRoot = this.fileRoot;
    }

    public String getType() {
        return "default";
    }

    public FileInfo createFile(String path, CMeta meta) {
        boolean b;
        String relativePath;
        FileInfo fileInfo = new FileInfo();
        fileInfo.relativePath = relativePath = this.getRelativePath(path, meta.getName());
        fileInfo.url = this.urlRoot + relativePath;
        fileInfo.absolutePath = this.fileRoot + relativePath;
        File file = new File(fileInfo.absolutePath);
        File parent = file.getParentFile();
        if (!parent.exists() && !(b = parent.mkdirs())) {
            try {
                throw new Exception("\u6ca1\u6709\u6587\u4ef6\u5939");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fileInfo;
    }

    public FileInfo createPackage(String path, CMeta meta) {
        String relativePath;
        FileInfo fileInfo = new FileInfo();
        fileInfo.relativePath = relativePath = this.getRelativePath(path, meta.getName());
        fileInfo.url = this.urlRoot + relativePath;
        fileInfo.absolutePath = this.fileRoot + relativePath;
        File file = new File(fileInfo.absolutePath);
        if (file.exists()) {
            if (file.isFile()) {
                try {
                    throw new Exception("\u6ca1\u6709\u6587\u4ef6\u5939");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return fileInfo;
        }
        this.makeDir(fileInfo.absolutePath);
        return fileInfo;
    }

    private void makeDir(String path) {
        try {
            File file = new File(path);
            file.mkdirs();
        }
        catch (Exception e) {
            try {
                throw new Exception("\u6ca1\u6709\u6587\u4ef6\u5939");
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public String getRelativePath(String path, String name) {
        return path + "/" + name;
    }

    public String getAbsPath(String path) {
        return this.fileRoot + path;
    }

    public String getAbsPath(String path, String name) {
        return this.fileRoot + path + "/" + name;
    }

    public void deleteFileCascade(FileInfo fileInfo) {
        File file = new File(fileInfo.absolutePath);
        this.delete(file);
    }

    private boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            boolean b = file.delete();
            return b;
        }
        return false;
    }

    public void deletePackageCascade(String fullName) {
        String fullPath = this.getAbsPath(fullName);
        File file = new File(fullPath);
        if (!file.exists()) {
            return;
        }
        boolean b = this.deleteCascade(file);
    }

    private boolean deleteCascade(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        if (file.equals(this.rootFile)) {
            return false;
        }
        File[] children = file.listFiles();
        if (children == null || children.length == 0) {
            return file.delete();
        }
        boolean all = true;
        for (int i = 0; i < children.length; ++i) {
            if (!this.deleteCascade(children[i])) {
                all = false;
            }
            if (!all) continue;
            all = file.delete();
        }
        file.delete();
        return all;
    }
}

