/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.workflow.cust.WFRoleGroupEntrysFactory;
import com.kingdee.bos.workflow.cust.WFRoleState;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class WFRoleClientUtils {
    public static String ADMINISTRATOR = "00000000-0000-0000-0000-00000000000013B7DE7F";

    public static boolean checkRoleInGroup(String id) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("roleid", (Object)id));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        int count = WFRoleGroupEntrysFactory.getRemoteInstance().getCount(viewInfo);
        return count > 0;
    }

    public static List<String> checkRoleInGroup(List<String> ids) throws BOSException, SQLException {
        ArrayList<String> retList = new ArrayList<String>();
        if (ids == null || ids.size() == 0) {
            return retList;
        }
        String sql = "select distinct froleid roleid from T_WFR_WFRoleGroupEntrys where froleid in (" + WFRoleClientUtils.concat(ids) + ")";
        SQLExecutor se = new SQLExecutor(sql);
        IRowSet rows = se.executeSQL();
        while (rows.next()) {
            retList.add(rows.getString("roleid").toString());
        }
        return retList;
    }

    public static boolean checkRoleInProc(String id) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        StringBuffer bf = new StringBuffer("select count(*) \"count(*)\" ");
        bf.append("from T_WFR_ProcDef AS PROCDEF right join T_WFR_PRODEFROLE as b");
        bf.append(" on PROCDEF.fprocdefid = b.fprocdefid ");
        bf.append("WHERE  (PROCDEF.FPROCDEFTYPE = 'NORMAL' OR PROCDEF.FPROCDEFTYPE = 'MICRO') and  b.fwfroleid= '");
        bf.append(id);
        bf.append("'");
        SQLExecutor se = new SQLExecutor(bf.toString());
        IRowSet rows = se.executeSQL();
        return rows.next() && rows.getBigDecimal(1).intValue() > 0;
    }

    public static List<String> checkRoleInProc(List<String> ids) throws BOSException, SQLException {
        ArrayList<String> retList = new ArrayList<String>();
        if (ids == null || ids.size() == 0) {
            return retList;
        }
        String sql = "select distinct b.FWfRoleId roleid from T_WFR_PROCDEF as a right join T_WFR_PRODEFROLE as b on a.fprocdefid = b.fprocdefid where (a.fprocdeftype = 'NORMAL' or a.fprocdeftype='MICRO') and b.fwfroleid in (" + WFRoleClientUtils.concat(ids) + ")";
        SQLExecutor se = new SQLExecutor(sql);
        IRowSet rows = se.executeSQL();
        while (rows.next()) {
            retList.add(rows.getString("roleid").toString());
        }
        return retList;
    }

    public static List<String> checkRoleInStartScheme(List<String> ids) throws BOSException, SQLException {
        ArrayList<String> retList = new ArrayList<String>();
        return retList;
    }

    public static List<String> checkRoleGroupInStartScheme(List<String> ids) throws BOSException, SQLException {
        ArrayList<String> retList = new ArrayList<String>();
        return retList;
    }

    public static List<String> filterEnableOrDisableRole(List<String> ids, WFRoleState t) throws BOSException, SQLException {
        ArrayList<String> retList = new ArrayList<String>();
        if (ids == null || ids.size() == 0) {
            return retList;
        }
        String sql = "select fid roleid from T_WFR_WFRole where FSTATE = " + t.getValue() + " and fid in (" + WFRoleClientUtils.concat(ids) + ")";
        SQLExecutor se = new SQLExecutor(sql);
        IRowSet rows = se.executeSQL();
        while (rows.next()) {
            retList.add(rows.getString("roleid").toString());
        }
        return retList;
    }

    public static IRowSet getProcTableData(String id, int type) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        StringBuffer bf = new StringBuffer("(select distinct ");
        bf.append(" PROCDEF.FNAME_l2 AS name, PROCDEF.FProcCode AS number, ");
        bf.append(" PROCDEF.FAUTHOR AS creator ");
        bf.append("from T_WFR_ProcDef AS PROCDEF right join T_WFR_PRODEFROLE as b");
        bf.append(" on PROCDEF.fprocdefid = b.fprocdefid ");
        bf.append("WHERE  (PROCDEF.FPROCDEFTYPE = 'NORMAL' OR PROCDEF.FPROCDEFTYPE = 'MICRO') and  b.fwfroleid= '");
        bf.append(id);
        bf.append("' and b.FType = ");
        bf.append(type);
        bf.append(") union all (");
        bf.append("select distinct ");
        bf.append(" PROCDEF.FNAME_l2||'('||scheme.fname_l2||')' AS name, PROCDEF.FProcCode AS number, ");
        bf.append(" PROCDEF.FAUTHOR AS creator ");
        bf.append("from T_WFR_ProcDef AS PROCDEF right join T_WFR_WFStartScheme as scheme");
        bf.append(" on PROCDEF.fprocdefid = scheme.fprocdefid ");
        bf.append("WHERE  (PROCDEF.FPROCDEFTYPE = 'NORMAL' OR PROCDEF.FPROCDEFTYPE = 'MICRO') and  ");
        if (type == 1) {
            bf.append("(scheme.fwfroleid= '" + id + "' or scheme.FWFORGROLEID ='" + id + "' )");
        } else {
            bf.append("(scheme.fwfrolegroup= '" + id + "' or scheme.FWFORGROLEGROUP ='" + id + "' )");
        }
        bf.append(") ");
        SQLExecutor se = new SQLExecutor(bf.toString());
        return se.executeSQL();
    }

    public static String concat(List<String> ids) {
        StringBuffer bf = new StringBuffer();
        if (ids == null || ids.size() == 0) {
            return bf.toString();
        }
        for (String s : ids) {
            bf.append("'");
            bf.append(s);
            bf.append("',");
        }
        return bf.toString().substring(0, bf.toString().length() - 1);
    }

    public static AdminOrgUnitInfo formatName(AdminOrgUnitInfo info, String s) {
        if (info == null) {
            return null;
        }
        String displayname = info.getDisplayName();
        String name = s + "_";
        if (displayname != null && displayname.startsWith(name)) {
            info.setName(displayname.substring(name.length()));
        }
        return info;
    }
}

