/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupInfo;
import com.kingdee.bos.workflow.cust.client.AbstractWFRoleGroupListUI;
import com.kingdee.bos.workflow.cust.client.WFRoleClientUtils;
import com.kingdee.bos.workflow.cust.client.WFRoleGroupEditUI;
import com.kingdee.bos.workflow.cust.client.WFRoleGroupUsageConditionUI;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WFRoleGroupListUI
extends AbstractWFRoleGroupListUI {
    private static final Logger logger = CoreUIObject.getLogger(WFRoleGroupListUI.class);
    private static String resClassName = "com.kingdee.bos.workflow.cust.WFRoleResource";

    public WFRoleGroupListUI() throws Exception {
        this.checkPermission();
    }

    public void checkPermission() throws BOSException, EASBizException {
        IPermission permission = PermissionFactory.getRemoteInstance();
        permission.checkFunctionPermission(this.getUserPk(), this.getOrgPK(), "wf_rolegroup_read");
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WFRoleGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return WFRoleGroupEditUI.class.getName();
    }

    protected ArrayList getSelectedIdValues() {
        return super.getSelectedIdValues();
    }

    protected IObjectValue createNewData() {
        WFRoleGroupInfo objectValue = new WFRoleGroupInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.getUIContext().put("checkLicense", "false");
        super.onLoad();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList list;
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock sb = this.tblMain.getSelectManager().get(i);
                int begin = sb.getTop();
                int end = sb.getBottom();
                for (int j = begin; j <= end; ++j) {
                    String createId;
                    IRow row = this.tblMain.getRow(j);
                    ICell cell = row.getCell("creator");
                    if (cell == null || cell.getValue() == null || (createId = cell.getValue().toString()).equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) || SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals(WFRoleClientUtils.ADMINISTRATOR)) continue;
                    if (size == 1) {
                        MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"removePermTip"));
                    } else {
                        MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selDataDelTip"));
                    }
                    SysUtil.abort();
                }
            }
        }
        if ((list = this.getSelectedIdValues()) != null && list.size() > 0) {
            if (list.size() == 1) {
                if (WFRoleClientUtils.checkRoleInProc(list.get(0).toString())) {
                    MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"groupRefInProc"));
                    SysUtil.abort();
                }
                if (WFRoleClientUtils.checkRoleGroupInStartScheme(list).size() != 0) {
                    MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"groupQuotedBySS"));
                    SysUtil.abort();
                }
            } else {
                Map map = this.getSelectedIdNumber();
                StringBuffer bf = new StringBuffer();
                StringBuffer bf2 = new StringBuffer();
                boolean flag = false;
                List<String> procRet = WFRoleClientUtils.checkRoleInProc(list);
                for (int i = 0; i < procRet.size(); ++i) {
                    if (map.get(procRet.get(i)) == null) {
                        flag = true;
                        break;
                    }
                    bf.append(map.get(procRet.get(i)) + "\r\n");
                }
                if (flag) {
                    bf.append(EASResource.getString((String)resClassName, (String)"aso"));
                }
                flag = false;
                List<String> SchemeRet = WFRoleClientUtils.checkRoleGroupInStartScheme(list);
                for (int i = 0; i < SchemeRet.size(); ++i) {
                    if (map.get(SchemeRet.get(i)) == null) {
                        flag = true;
                        break;
                    }
                    bf2.append(map.get(SchemeRet.get(i)) + "\r\n");
                }
                if (flag) {
                    bf2.append(EASResource.getString((String)resClassName, (String)"aso"));
                }
                StringBuffer sb = new StringBuffer();
                if (procRet.size() > 0) {
                    sb.append(EASResource.getString((String)resClassName, (String)"groupRemovePermTip") + "\r\n");
                    sb.append(bf);
                }
                StringBuffer sb2 = new StringBuffer();
                if (SchemeRet.size() > 0) {
                    sb2.append(EASResource.getString((String)resClassName, (String)"groupsQuotedBySS") + "\r\n");
                    sb2.append(bf2);
                }
                if (SchemeRet.size() > 0 || procRet.size() > 0) {
                    MsgBox.showWarning((String)sb.append("\r\n").append(sb2).toString());
                    SysUtil.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String createId;
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectRowTip"));
            SysUtil.abort();
        }
        if (this.tblMain.getSelectManager().size() > 1 || this.tblMain.getSelectManager().get().getEndRow() - this.tblMain.getSelectManager().get().getBeginRow() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"modifyOnlyOne"));
            SysUtil.abort();
        }
        if ((createId = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("creator").getValue().toString()).equals(SysContext.getSysContext().getCurrentUserInfo().getId().toString()) || SysContext.getSysContext().getCurrentUserInfo().getId().toString().equals(WFRoleClientUtils.ADMINISTRATOR)) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"modifyPermTip"));
        }
    }

    @Override
    protected void btnUsageCondition_actionPerformed(ActionEvent e) throws Exception {
        super.btnUsageCondition_actionPerformed(e);
        this.checkSelected();
        if (this.tblMain.getSelectManager().size() > 1 || this.tblMain.getSelectManager().get().getEndRow() - this.tblMain.getSelectManager().get().getBeginRow() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)resClassName, (String)"selectOnlyOne"));
            SysUtil.abort();
        }
        String id = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(WFRoleGroupUsageConditionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

