/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.cust.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.cust.WFRoleFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupEntrysFactory;
import com.kingdee.bos.workflow.cust.WFRoleGroupEntrysInfo;
import com.kingdee.bos.workflow.cust.WFRoleInfo;
import com.kingdee.bos.workflow.cust.client.AbstractWFRoleUsageConditionUI;
import com.kingdee.bos.workflow.cust.client.WFOrgF7PromptBox;
import com.kingdee.bos.workflow.cust.client.WFRoleClientUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class WFRoleUsageConditionUI
extends AbstractWFRoleUsageConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(WFRoleUsageConditionUI.class);

    public WFRoleUsageConditionUI() throws Exception {
        this.tblMain1.checkParsed();
        this.tblMain2.checkParsed();
        this.tblMain1.getSelectManager().setSelectMode(2);
        this.tblMain2.getSelectManager().setSelectMode(2);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("RoleName"));
        sic.add(new SelectorItemInfo("RoleDescribe"));
        sic.add(new SelectorItemInfo("RoleType"));
        sic.add(new SelectorItemInfo("State"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("Admin.*"));
        } else {
            sic.add(new SelectorItemInfo("Admin.id"));
            sic.add(new SelectorItemInfo("Admin.number"));
            sic.add(new SelectorItemInfo("Admin.name"));
        }
        sic.add(new SelectorItemInfo("number"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("treeid.*"));
        } else {
            sic.add(new SelectorItemInfo("treeid.id"));
            sic.add(new SelectorItemInfo("treeid.number"));
            sic.add(new SelectorItemInfo("treeid.name"));
        }
        return sic;
    }

    protected IObjectValue createNewData() {
        WFRoleInfo objectValue = new WFRoleInfo();
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WFRoleFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtAdmin.setDisplayFormat("$name$");
        this.prmtTreeid.setSelector((KDPromptSelector)new WFOrgF7PromptBox());
        this.loadProcTableData();
        this.loadRoleGroupTableData();
        this.tblMain1.removeColumn(this.tblMain1.getColumnIndex("createTime"));
        this.tblMain1.removeColumn(this.tblMain1.getColumnIndex("version"));
        this.tblMain1.getColumn("number").setWidth(250);
        this.tblMain1.getColumn("name").setWidth(250);
        this.tblMain1.getColumn("creator").setWidth(255);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    private void loadProcTableData() throws BOSException, SQLException {
        IRowSet rs = WFRoleClientUtils.getProcTableData(this.editData.getId().toString(), 1);
        while (rs.next()) {
            IRow row = this.tblMain1.addRow();
            row.getCell("number").setValue((Object)rs.getString("number"));
            row.getCell("name").setValue((Object)rs.getString("name"));
            row.getCell("creator").setValue((Object)rs.getString("creator"));
        }
    }

    private void loadRoleGroupTableData() throws BOSException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("RoleID", (Object)this.editData.getId().toString());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(filterItemInfo);
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("parentID.id"));
        sic.add(new SelectorItemInfo("parentID.number"));
        sic.add(new SelectorItemInfo("parentID.name"));
        sic.add(new SelectorItemInfo("parentID.creator.name"));
        sic.add(new SelectorItemInfo("parentID.createTime"));
        CoreBaseCollection col = WFRoleGroupEntrysFactory.getRemoteInstance().getCollection(viewInfo);
        for (WFRoleGroupEntrysInfo info : col) {
            IRow row = this.tblMain2.addRow();
            row.getCell("id").setValue((Object)info.getParentID().getId());
            row.getCell("number").setValue((Object)info.getParentID().getNumber());
            row.getCell("name").setValue((Object)info.getParentID().getName());
            row.getCell("creator").setValue((Object)info.getParentID().getCreator());
            row.getCell("createTime").setValue((Object)info.getParentID().getCreateTime());
        }
    }
}

