/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.master.account.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AbstractAccountImportDlg;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.DatataskRunServerFactory;
import com.kingdee.eas.tools.datatask.IDatataskRunServer;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.client.DlgEASDatataskLog;
import com.kingdee.eas.tools.datatask.client.ServerTemplateExport;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.runtime.UploadFileToServerHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountImportDlg
extends AbstractAccountImportDlg {
    private static final Logger logger = CoreUIObject.getLogger(AccountImportDlg.class);
    private AccountTableInfo acctTblInfo;
    private CompanyOrgUnitInfo company;
    private String FILEDIR;
    private String eas_home;
    private static final String path = "\\client\\template\\AccountTemplate\\";
    private static final String commonName = "AccountImportTemplate-ForCommonCompany.xls";
    private static final String stockName = "AccountImportTemplate-ForStockCompany.xls";
    private static final String industryName = "AccountImportTemplate-ForIndustryCompany.xls";
    private static final String financeName = "AccountImportTemplate-ForFinancialCompany.xls";
    private static final String businessName = "AccountImportTemplate-ForBusinessCompany.xls";
    private static final String realEstateName = "AccountImportTemplate-ForRealEstateCompany.xls";
    private static final String travelServiceName = "AccountImportTemplate-ForTravelServiceCompany.xls";
    private static final String ForCommon2007Company = "AccountImportTemplate-2007ForCommonCompany.xls";
    private static final String ForNewGovernmentAccount = "AccountImportTemplate-ForGovernmentAccount.xls";

    @Override
    protected void initUIP() {
        super.initUIP();
    }

    public void onLoad() throws Exception {
        this.actionImport.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.actionView.setEnabled(true);
        this.acctTblInfo = (AccountTableInfo)this.getUIContext().get("ACCOUNTTABLEINFO");
        this.company = (CompanyOrgUnitInfo)this.getUIContext().get("currentCompany");
        super.onLoad();
        this.eas_home = System.getProperty("EAS_HOME", "w:\\eas");
        this.FILEDIR = this.eas_home + path;
        this.fillAccountTemplate(this.FILEDIR);
    }

    private void fillAccountTemplate(String fileDirPath) throws Exception {
        String[] fileList = new String[]{commonName, stockName, industryName, financeName, businessName, realEstateName, travelServiceName, ForCommon2007Company, ForNewGovernmentAccount};
        int count = fileList.length;
        for (int i = 0; i < count; ++i) {
            FileTemplateInfo fileTemplateInfo = new FileTemplateInfo(fileList[i]);
            this.cbxAccountTemplate.addItem((Object)fileTemplateInfo);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        super.actionImport_actionPerformed(e);
        this.beforeThreadRun();
        Thread importThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List log = null;
                Exception ex = null;
                try {
                    log = AccountImportDlg.this.importAccountTemplate();
                }
                catch (Exception e) {
                    ex = e;
                }
                finally {
                    AccountImportDlg.this.showImportLog(ex, log);
                }
            }
        });
        importThread.start();
    }

    private void beforeThreadRun() {
        this.progressBar.setIndeterminate(true);
        this.btnImport.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnPageSetup.setEnabled(false);
        this.btnView.setEnabled(false);
        this.cbxAccountTemplate.setEnabled(false);
    }

    private void showImportLog(Exception ex, List log) {
        this.afterThreadRun();
        if (ex == null) {
            if (log != null) {
                TaskLog acctLog;
                TaskLog acctTypeLog = (TaskLog)log.get(0);
                TaskLog mergedLog = this.mergeTaskLog(acctTypeLog, acctLog = (TaskLog)log.get(1));
                if (mergedLog.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importSucceeded"));
                } else {
                    DlgEASDatataskLog dlgLog = new DlgEASDatataskLog((KDDialog)this.getUIWindow(), mergedLog);
                    dlgLog.setModal(true);
                    dlgLog.show();
                }
            }
        } else {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private void afterThreadRun() {
        this.progressBar.setIndeterminate(false);
        this.btnImport.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnPageSetup.setEnabled(true);
        this.btnView.setEnabled(true);
        this.cbxAccountTemplate.setEnabled(true);
    }

    private List importAccountTemplate() throws Exception {
        IAccountView iAcct = AccountViewFactory.getRemoteInstance();
        File file = this.getCurrentFile();
        boolean isDebug = true;
        if (isDebug) {
            String fileName = file.getAbsolutePath();
            ArrayList<TaskLog> logList = new ArrayList<TaskLog>();
            IDatataskRunServer iDataTask = DatataskRunServerFactory.getRemoteInstance();
            DatataskParameter param = new DatataskParameter();
            param.datataskMode = 8;
            param.setFileType("xls");
            Hashtable<String, String> dataTaskCtx = new Hashtable<String, String>();
            dataTaskCtx.put("varAccountTableID", this.acctTblInfo.get("id").toString());
            dataTaskCtx.put("varCUID", SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
            dataTaskCtx.put("varCompanyID", this.company.getId().toString());
            param.setContextParam(dataTaskCtx);
            ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
            paramList.add(param);
            TaskLog acctTypeLog = null;
            TaskLog acctLog = null;
            try {
                param.solutionName = "eas.basedata.common.accounttype";
                UploadFileToServerHelper helper = new UploadFileToServerHelper();
                param.setOpenFileName(helper.uploadFile(fileName));
                String strAlias = "com.kingdee.eas.basedata.master.account.AllAccountResource";
                param.alias = EASResource.getString((String)strAlias, (String)"accountType");
                String logUuid = Uuid.create().toString();
                param.setLogUuID(logUuid);
                iDataTask.run(paramList);
                acctTypeLog = iDataTask.getTaskLog(logUuid);
                iDataTask.clearTaskLog(logUuid);
                logUuid = Uuid.create().toString();
                param.setLogUuID(logUuid);
                param.solutionName = "eas.basedata.common.accountview";
                helper = new UploadFileToServerHelper();
                param.setOpenFileName(helper.uploadFile(fileName));
                param.alias = EASResource.getString((String)strAlias, (String)"accountantSubject");
                iDataTask.run(paramList);
                acctLog = iDataTask.getTaskLog(logUuid);
                iDataTask.clearTaskLog(logUuid);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)e);
                throw e;
            }
            finally {
                logList.add(acctTypeLog);
                logList.add(acctLog);
            }
            return logList;
        }
        List log = iAcct.importAccountTemplate(file.getAbsolutePath(), this.acctTblInfo);
        return log;
    }

    private TaskLog mergeTaskLog(TaskLog acctTypeLog, TaskLog acctLog) {
        int i;
        int successRecordCount = acctTypeLog.getSuccessRecordCount() + acctLog.getSuccessRecordCount();
        int failRecordCount = acctTypeLog.getFailRecordCount() + acctLog.getFailRecordCount();
        int recordCount = successRecordCount + failRecordCount;
        TaskLog mergedLog = new TaskLog(recordCount);
        mergedLog.setSuccessRecordCount(successRecordCount);
        mergedLog.setFailRecordCount(failRecordCount);
        int count = acctTypeLog.getErrorDetailCount();
        for (i = 0; i < count; ++i) {
            mergedLog.addException(acctTypeLog.getErrorSubject(i), (Throwable)new Exception(acctTypeLog.getException(i)), null);
        }
        count = acctLog.getErrorDetailCount();
        for (i = 0; i < count; ++i) {
            mergedLog.addException(acctLog.getErrorSubject(i), (Throwable)new Exception(acctLog.getException(i)), null);
        }
        if (acctTypeLog.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND) && acctLog.getTaskState().equals((Object)TaskStateEnum.SUCCESSEND)) {
            mergedLog.setTaskState(TaskStateEnum.SUCCESSEND);
        } else {
            mergedLog.setTaskState(TaskStateEnum.FAILEND);
        }
        return mergedLog;
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        this.beforeThreadRun();
        Thread viewThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccountViewCollection acctCols = null;
                Exception ex = null;
                try {
                    acctCols = AccountImportDlg.this.getAccountColsForView();
                }
                catch (Exception e) {
                    ex = e;
                }
                finally {
                    AccountImportDlg.this.showAccountColsInDialog(acctCols, ex);
                }
            }
        });
        viewThread.start();
    }

    public AccountViewCollection getAccountColsForView() throws BOSException, AccountException {
        AccountViewCollection acctCols = null;
        IAccountView iAcct = AccountViewFactory.getRemoteInstance();
        File file = this.getCurrentFile();
        if (file != null) {
            boolean isDebug = true;
            acctCols = isDebug ? this.getAccountColsFromExternalExcel(file.getAbsolutePath(), this.acctTblInfo) : iAcct.getAccountColsFromExternalExcel(file.getAbsolutePath(), this.acctTblInfo);
        }
        return acctCols;
    }

    public void showAccountColsInDialog(AccountViewCollection acctCols, Exception e) {
        this.afterThreadRun();
        if (e == null) {
            try {
                if (acctCols != null) {
                    IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    UIContext uiCtx = new UIContext((Object)this);
                    uiCtx.put("ACCOUNTCOLS", acctCols);
                    IUIWindow uiWin = uiFactory.create("com.kingdee.eas.basedata.master.account.client.AccountImportListUIDlg", (Map)uiCtx);
                    uiWin.show();
                }
            }
            catch (UIException ue) {
                ExceptionHandler.handle((Throwable)ue);
            }
        } else {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AccountViewCollection getAccountColsFromExternalExcel(String fileName, AccountTableInfo acctTblInfo2) throws AccountException, BOSException {
        byte[] content;
        block9: {
            content = null;
            FileInputStream input = null;
            try {
                input = new FileInputStream(fileName);
                content = new byte[input.available()];
                input.read(content);
                if (input == null) break block9;
            }
            catch (FileNotFoundException e1) {
                try {
                    throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
                    catch (IOException ie) {
                        throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
                    }
                }
                catch (Throwable throwable) {
                    if (input == null) throw throwable;
                    try {
                        input.close();
                        throw throwable;
                    }
                    catch (IOException ie) {
                        throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
                    }
                }
            }
            try {
                input.close();
            }
            catch (IOException ie) {
                throw new AccountException(AccountException.READFILEERROR, new Object[]{fileName});
            }
        }
        IAccountView iAcct = AccountViewFactory.getRemoteInstance();
        return iAcct.getAccountColsFromExternalExcel(content, this.acctTblInfo);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    private File getCurrentFile() throws AccountException {
        FileTemplateInfo fileTemplateInfo = (FileTemplateInfo)this.cbxAccountTemplate.getSelectedItem();
        String fileName = fileTemplateInfo.getFileName();
        try {
            ServerTemplateExport te = new ServerTemplateExport("AccountTemplate\\" + fileName);
            te.export(this.FILEDIR + fileName, false);
        }
        catch (FileNotFoundException e) {
            throw new AccountException(AccountException.FILENOTFOUND, new Object[]{fileName});
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
        File file = new File(this.FILEDIR + fileName);
        if (file.isFile() && file.exists()) {
            return file;
        }
        throw new AccountException(AccountException.FILENOTFOUND, new Object[]{fileName});
    }

    private class FileTemplateInfo {
        String fileName;
        String fileAlias;

        public FileTemplateInfo(String fileName) {
            this.setFileName(fileName);
            this.setFileAlias(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)fileName));
        }

        public String getFileAlias() {
            return this.fileAlias;
        }

        public void setFileAlias(String fileAlias) {
            this.fileAlias = fileAlias;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String toString() {
            return this.getFileAlias();
        }
    }
}

